// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.marketplacemetering.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A `UsageRecord` indicates a quantity of usage for a given product, customer, dimension and time.
 *
 * Multiple requests with the same `UsageRecords` as input will be de-duplicated to prevent double charges.
 */
public class UsageRecord private constructor(builder: Builder) {
    /**
     * The `CustomerIdentifier` is obtained through the `ResolveCustomer` operation and represents an individual buyer in your application.
     */
    public val customerIdentifier: kotlin.String? = builder.customerIdentifier
    /**
     * During the process of registering a product on AWS Marketplace, dimensions are specified. These represent different units of value in your application.
     */
    public val dimension: kotlin.String? = builder.dimension
    /**
     * The quantity of usage consumed by the customer for the given dimension and time. Defaults to `0` if not specified.
     */
    public val quantity: kotlin.Int? = builder.quantity
    /**
     * Timestamp, in UTC, for which the usage is being reported.
     *
     * Your application can meter usage for up to one hour in the past. Make sure the `timestamp` value is not before the start of the software usage.
     */
    public val timestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.timestamp
    /**
     * The set of `UsageAllocations` to submit. The sum of all `UsageAllocation` quantities must equal the Quantity of the `UsageRecord`.
     */
    public val usageAllocations: List<UsageAllocation>? = builder.usageAllocations

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.marketplacemetering.model.UsageRecord = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UsageRecord(")
        append("customerIdentifier=$customerIdentifier,")
        append("dimension=$dimension,")
        append("quantity=$quantity,")
        append("timestamp=$timestamp,")
        append("usageAllocations=$usageAllocations)")
    }

    override fun hashCode(): kotlin.Int {
        var result = customerIdentifier?.hashCode() ?: 0
        result = 31 * result + (dimension?.hashCode() ?: 0)
        result = 31 * result + (quantity ?: 0)
        result = 31 * result + (timestamp?.hashCode() ?: 0)
        result = 31 * result + (usageAllocations?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UsageRecord

        if (customerIdentifier != other.customerIdentifier) return false
        if (dimension != other.dimension) return false
        if (quantity != other.quantity) return false
        if (timestamp != other.timestamp) return false
        if (usageAllocations != other.usageAllocations) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.marketplacemetering.model.UsageRecord = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The `CustomerIdentifier` is obtained through the `ResolveCustomer` operation and represents an individual buyer in your application.
         */
        public var customerIdentifier: kotlin.String? = null
        /**
         * During the process of registering a product on AWS Marketplace, dimensions are specified. These represent different units of value in your application.
         */
        public var dimension: kotlin.String? = null
        /**
         * The quantity of usage consumed by the customer for the given dimension and time. Defaults to `0` if not specified.
         */
        public var quantity: kotlin.Int? = null
        /**
         * Timestamp, in UTC, for which the usage is being reported.
         *
         * Your application can meter usage for up to one hour in the past. Make sure the `timestamp` value is not before the start of the software usage.
         */
        public var timestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The set of `UsageAllocations` to submit. The sum of all `UsageAllocation` quantities must equal the Quantity of the `UsageRecord`.
         */
        public var usageAllocations: List<UsageAllocation>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.marketplacemetering.model.UsageRecord) : this() {
            this.customerIdentifier = x.customerIdentifier
            this.dimension = x.dimension
            this.quantity = x.quantity
            this.timestamp = x.timestamp
            this.usageAllocations = x.usageAllocations
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.marketplacemetering.model.UsageRecord = UsageRecord(this)
    }
}
