// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.marketplaceentitlementservice.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * An entitlement represents capacity in a product owned by the customer. For example, a customer might own some number of users or seats in an SaaS application or some amount of data capacity in a multi-tenant database.
 */
public class Entitlement private constructor(builder: Builder) {
    /**
     * The customer identifier is a handle to each unique customer in an application. Customer identifiers are obtained through the ResolveCustomer operation in AWS Marketplace Metering Service.
     */
    public val customerIdentifier: kotlin.String? = builder.customerIdentifier
    /**
     * The dimension for which the given entitlement applies. Dimensions represent categories of capacity in a product and are specified when the product is listed in AWS Marketplace.
     */
    public val dimension: kotlin.String? = builder.dimension
    /**
     * The expiration date represents the minimum date through which this entitlement is expected to remain valid. For contractual products listed on AWS Marketplace, the expiration date is the date at which the customer will renew or cancel their contract. Customers who are opting to renew their contract will still have entitlements with an expiration date.
     */
    public val expirationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.expirationDate
    /**
     * The product code for which the given entitlement applies. Product codes are provided by AWS Marketplace when the product listing is created.
     */
    public val productCode: kotlin.String? = builder.productCode
    /**
     * The EntitlementValue represents the amount of capacity that the customer is entitled to for the product.
     */
    public val value: aws.sdk.kotlin.services.marketplaceentitlementservice.model.EntitlementValue? = builder.value

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.marketplaceentitlementservice.model.Entitlement = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Entitlement(")
        append("customerIdentifier=$customerIdentifier,")
        append("dimension=$dimension,")
        append("expirationDate=$expirationDate,")
        append("productCode=$productCode,")
        append("value=$value")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = customerIdentifier?.hashCode() ?: 0
        result = 31 * result + (dimension?.hashCode() ?: 0)
        result = 31 * result + (expirationDate?.hashCode() ?: 0)
        result = 31 * result + (productCode?.hashCode() ?: 0)
        result = 31 * result + (value?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Entitlement

        if (customerIdentifier != other.customerIdentifier) return false
        if (dimension != other.dimension) return false
        if (expirationDate != other.expirationDate) return false
        if (productCode != other.productCode) return false
        if (value != other.value) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.marketplaceentitlementservice.model.Entitlement = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The customer identifier is a handle to each unique customer in an application. Customer identifiers are obtained through the ResolveCustomer operation in AWS Marketplace Metering Service.
         */
        public var customerIdentifier: kotlin.String? = null
        /**
         * The dimension for which the given entitlement applies. Dimensions represent categories of capacity in a product and are specified when the product is listed in AWS Marketplace.
         */
        public var dimension: kotlin.String? = null
        /**
         * The expiration date represents the minimum date through which this entitlement is expected to remain valid. For contractual products listed on AWS Marketplace, the expiration date is the date at which the customer will renew or cancel their contract. Customers who are opting to renew their contract will still have entitlements with an expiration date.
         */
        public var expirationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The product code for which the given entitlement applies. Product codes are provided by AWS Marketplace when the product listing is created.
         */
        public var productCode: kotlin.String? = null
        /**
         * The EntitlementValue represents the amount of capacity that the customer is entitled to for the product.
         */
        public var value: aws.sdk.kotlin.services.marketplaceentitlementservice.model.EntitlementValue? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.marketplaceentitlementservice.model.Entitlement) : this() {
            this.customerIdentifier = x.customerIdentifier
            this.dimension = x.dimension
            this.expirationDate = x.expirationDate
            this.productCode = x.productCode
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.marketplaceentitlementservice.model.Entitlement = Entitlement(this)

        /**
         * construct an [aws.sdk.kotlin.services.marketplaceentitlementservice.model.EntitlementValue] inside the given [block]
         */
        public fun value(block: aws.sdk.kotlin.services.marketplaceentitlementservice.model.EntitlementValue.Builder.() -> kotlin.Unit) {
            this.value = aws.sdk.kotlin.services.marketplaceentitlementservice.model.EntitlementValue.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
