// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.marketplaceentitlementservice.model



/**
 * The GetEntitlementsRequest contains parameters for the GetEntitlements operation.
 */
public class GetEntitlementsRequest private constructor(builder: Builder) {
    /**
     * Filter is used to return entitlements for a specific customer or for a specific dimension. Filters are described as keys mapped to a lists of values. Filtered requests are *unioned* for each value in the value list, and then *intersected* for each filter key.
     */
    public val filter: Map<String, List<String>>? = builder.filter
    /**
     * The maximum number of items to retrieve from the GetEntitlements operation. For pagination, use the NextToken field in subsequent calls to GetEntitlements.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * For paginated calls to GetEntitlements, pass the NextToken from the previous GetEntitlementsResult.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * Product code is used to uniquely identify a product in AWS Marketplace. The product code will be provided by AWS Marketplace when the product listing is created.
     */
    public val productCode: kotlin.String? = builder.productCode

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.marketplaceentitlementservice.model.GetEntitlementsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetEntitlementsRequest(")
        append("filter=$filter,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("productCode=$productCode")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = filter?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (productCode?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetEntitlementsRequest

        if (filter != other.filter) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (productCode != other.productCode) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.marketplaceentitlementservice.model.GetEntitlementsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Filter is used to return entitlements for a specific customer or for a specific dimension. Filters are described as keys mapped to a lists of values. Filtered requests are *unioned* for each value in the value list, and then *intersected* for each filter key.
         */
        public var filter: Map<String, List<String>>? = null
        /**
         * The maximum number of items to retrieve from the GetEntitlements operation. For pagination, use the NextToken field in subsequent calls to GetEntitlements.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * For paginated calls to GetEntitlements, pass the NextToken from the previous GetEntitlementsResult.
         */
        public var nextToken: kotlin.String? = null
        /**
         * Product code is used to uniquely identify a product in AWS Marketplace. The product code will be provided by AWS Marketplace when the product listing is created.
         */
        public var productCode: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.marketplaceentitlementservice.model.GetEntitlementsRequest) : this() {
            this.filter = x.filter
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.productCode = x.productCode
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.marketplaceentitlementservice.model.GetEntitlementsRequest = GetEntitlementsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
