// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.marketplacedeployment.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class PutDeploymentParameterRequest private constructor(builder: Builder) {
    /**
     * The unique identifier of the agreement.
     */
    public val agreementId: kotlin.String? = builder.agreementId
    /**
     * The catalog related to the request. Fixed value: `AWSMarketplace`
     */
    public val catalog: kotlin.String? = builder.catalog
    /**
     * The idempotency token for deployment parameters. A unique identifier for the new version.
     *
     * This field is not required if you're calling using an AWS SDK. Otherwise, a `clientToken` must be provided with the request.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The deployment parameter targeted to the acceptor of an agreement for which to create the AWS Secret Manager resource.
     */
    public val deploymentParameter: aws.sdk.kotlin.services.marketplacedeployment.model.DeploymentParameterInput? = builder.deploymentParameter
    /**
     * The date when deployment parameters expire and are scheduled for deletion.
     */
    public val expirationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.expirationDate
    /**
     * The product for which AWS Marketplace will save secrets for the buyer’s account.
     */
    public val productId: kotlin.String? = builder.productId
    /**
     * A map of key-value pairs, where each pair represents a tag saved to the resource. Tags will only be applied for create operations, and they'll be ignored if the resource already exists.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.marketplacedeployment.model.PutDeploymentParameterRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutDeploymentParameterRequest(")
        append("agreementId=$agreementId,")
        append("catalog=$catalog,")
        append("clientToken=$clientToken,")
        append("deploymentParameter=$deploymentParameter,")
        append("expirationDate=$expirationDate,")
        append("productId=$productId,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = agreementId?.hashCode() ?: 0
        result = 31 * result + (catalog?.hashCode() ?: 0)
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (deploymentParameter?.hashCode() ?: 0)
        result = 31 * result + (expirationDate?.hashCode() ?: 0)
        result = 31 * result + (productId?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutDeploymentParameterRequest

        if (agreementId != other.agreementId) return false
        if (catalog != other.catalog) return false
        if (clientToken != other.clientToken) return false
        if (deploymentParameter != other.deploymentParameter) return false
        if (expirationDate != other.expirationDate) return false
        if (productId != other.productId) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.marketplacedeployment.model.PutDeploymentParameterRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The unique identifier of the agreement.
         */
        public var agreementId: kotlin.String? = null
        /**
         * The catalog related to the request. Fixed value: `AWSMarketplace`
         */
        public var catalog: kotlin.String? = null
        /**
         * The idempotency token for deployment parameters. A unique identifier for the new version.
         *
         * This field is not required if you're calling using an AWS SDK. Otherwise, a `clientToken` must be provided with the request.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The deployment parameter targeted to the acceptor of an agreement for which to create the AWS Secret Manager resource.
         */
        public var deploymentParameter: aws.sdk.kotlin.services.marketplacedeployment.model.DeploymentParameterInput? = null
        /**
         * The date when deployment parameters expire and are scheduled for deletion.
         */
        public var expirationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The product for which AWS Marketplace will save secrets for the buyer’s account.
         */
        public var productId: kotlin.String? = null
        /**
         * A map of key-value pairs, where each pair represents a tag saved to the resource. Tags will only be applied for create operations, and they'll be ignored if the resource already exists.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.marketplacedeployment.model.PutDeploymentParameterRequest) : this() {
            this.agreementId = x.agreementId
            this.catalog = x.catalog
            this.clientToken = x.clientToken
            this.deploymentParameter = x.deploymentParameter
            this.expirationDate = x.expirationDate
            this.productId = x.productId
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.marketplacedeployment.model.PutDeploymentParameterRequest = PutDeploymentParameterRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.marketplacedeployment.model.DeploymentParameterInput] inside the given [block]
         */
        public fun deploymentParameter(block: aws.sdk.kotlin.services.marketplacedeployment.model.DeploymentParameterInput.Builder.() -> kotlin.Unit) {
            this.deploymentParameter = aws.sdk.kotlin.services.marketplacedeployment.model.DeploymentParameterInput.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
