// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.marketplacecommerceanalytics.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Container for the parameters to the StartSupportDataExport operation.
 */
class StartSupportDataExportRequest private constructor(builder: BuilderImpl) {
    /**
     * (Optional) Key-value pairs which will be returned, unmodified, in the
     * Amazon SNS notification message and the data set metadata file.
     */
    val customerDefinedValues: Map<String, String>? = builder.customerDefinedValues
    /**
     * Specifies the data set type to be written to the output csv file. The data set types customer_support_contacts_data and
     * test_customer_support_contacts_data both result in a csv file containing the following fields: Product Id, Product Code, Customer Guid,
     * Subscription Guid, Subscription Start Date, Organization, AWS Account Id, Given Name, Surname, Telephone Number, Email, Title,
     * Country Code, ZIP Code, Operation Type, and Operation Time.
     * customer_support_contacts_data Customer support contact data. The data set will contain all changes (Creates, Updates, and Deletes) to customer support contact data from the date specified in the from_date parameter.
     * test_customer_support_contacts_data An example data set containing static test data in the same format as customer_support_contacts_data
     */
    val dataSetType: SupportDataSetType? = builder.dataSetType
    /**
     * The name (friendly name, not ARN) of the destination S3 bucket.
     */
    val destinationS3BucketName: String? = builder.destinationS3BucketName
    /**
     * (Optional) The desired S3 prefix for the published data set, similar to a directory path in standard file systems.
     * For example, if given the bucket name "mybucket" and the prefix "myprefix/mydatasets", the output file
     * "outputfile" would be published to "s3://mybucket/myprefix/mydatasets/outputfile".
     * If the prefix directory structure does not exist, it will be created.
     * If no prefix is provided, the data set will be published to the S3 bucket root.
     */
    val destinationS3Prefix: String? = builder.destinationS3Prefix
    /**
     * The start date from which to retrieve the data set in UTC.  This parameter only affects the customer_support_contacts_data data set type.
     */
    val fromDate: Instant? = builder.fromDate
    /**
     * The Amazon Resource Name (ARN) of the Role with an attached permissions policy to interact with the provided
     * AWS services.
     */
    val roleNameArn: String? = builder.roleNameArn
    /**
     * Amazon Resource Name (ARN) for the SNS Topic that will be notified when the data set has been published or if an
     * error has occurred.
     */
    val snsTopicArn: String? = builder.snsTopicArn

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): StartSupportDataExportRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("StartSupportDataExportRequest(")
        append("customerDefinedValues=$customerDefinedValues,")
        append("dataSetType=$dataSetType,")
        append("destinationS3BucketName=$destinationS3BucketName,")
        append("destinationS3Prefix=$destinationS3Prefix,")
        append("fromDate=$fromDate,")
        append("roleNameArn=$roleNameArn,")
        append("snsTopicArn=$snsTopicArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = customerDefinedValues?.hashCode() ?: 0
        result = 31 * result + (dataSetType?.hashCode() ?: 0)
        result = 31 * result + (destinationS3BucketName?.hashCode() ?: 0)
        result = 31 * result + (destinationS3Prefix?.hashCode() ?: 0)
        result = 31 * result + (fromDate?.hashCode() ?: 0)
        result = 31 * result + (roleNameArn?.hashCode() ?: 0)
        result = 31 * result + (snsTopicArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as StartSupportDataExportRequest

        if (customerDefinedValues != other.customerDefinedValues) return false
        if (dataSetType != other.dataSetType) return false
        if (destinationS3BucketName != other.destinationS3BucketName) return false
        if (destinationS3Prefix != other.destinationS3Prefix) return false
        if (fromDate != other.fromDate) return false
        if (roleNameArn != other.roleNameArn) return false
        if (snsTopicArn != other.snsTopicArn) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): StartSupportDataExportRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): StartSupportDataExportRequest
        /**
         * (Optional) Key-value pairs which will be returned, unmodified, in the
         * Amazon SNS notification message and the data set metadata file.
         */
        fun customerDefinedValues(customerDefinedValues: Map<String, String>): FluentBuilder
        /**
         * Specifies the data set type to be written to the output csv file. The data set types customer_support_contacts_data and
         * test_customer_support_contacts_data both result in a csv file containing the following fields: Product Id, Product Code, Customer Guid,
         * Subscription Guid, Subscription Start Date, Organization, AWS Account Id, Given Name, Surname, Telephone Number, Email, Title,
         * Country Code, ZIP Code, Operation Type, and Operation Time.
         * customer_support_contacts_data Customer support contact data. The data set will contain all changes (Creates, Updates, and Deletes) to customer support contact data from the date specified in the from_date parameter.
         * test_customer_support_contacts_data An example data set containing static test data in the same format as customer_support_contacts_data
         */
        fun dataSetType(dataSetType: SupportDataSetType): FluentBuilder
        /**
         * The name (friendly name, not ARN) of the destination S3 bucket.
         */
        fun destinationS3BucketName(destinationS3BucketName: String): FluentBuilder
        /**
         * (Optional) The desired S3 prefix for the published data set, similar to a directory path in standard file systems.
         * For example, if given the bucket name "mybucket" and the prefix "myprefix/mydatasets", the output file
         * "outputfile" would be published to "s3://mybucket/myprefix/mydatasets/outputfile".
         * If the prefix directory structure does not exist, it will be created.
         * If no prefix is provided, the data set will be published to the S3 bucket root.
         */
        fun destinationS3Prefix(destinationS3Prefix: String): FluentBuilder
        /**
         * The start date from which to retrieve the data set in UTC.  This parameter only affects the customer_support_contacts_data data set type.
         */
        fun fromDate(fromDate: Instant): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the Role with an attached permissions policy to interact with the provided
         * AWS services.
         */
        fun roleNameArn(roleNameArn: String): FluentBuilder
        /**
         * Amazon Resource Name (ARN) for the SNS Topic that will be notified when the data set has been published or if an
         * error has occurred.
         */
        fun snsTopicArn(snsTopicArn: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * (Optional) Key-value pairs which will be returned, unmodified, in the
         * Amazon SNS notification message and the data set metadata file.
         */
        var customerDefinedValues: Map<String, String>?
        /**
         * Specifies the data set type to be written to the output csv file. The data set types customer_support_contacts_data and
         * test_customer_support_contacts_data both result in a csv file containing the following fields: Product Id, Product Code, Customer Guid,
         * Subscription Guid, Subscription Start Date, Organization, AWS Account Id, Given Name, Surname, Telephone Number, Email, Title,
         * Country Code, ZIP Code, Operation Type, and Operation Time.
         * customer_support_contacts_data Customer support contact data. The data set will contain all changes (Creates, Updates, and Deletes) to customer support contact data from the date specified in the from_date parameter.
         * test_customer_support_contacts_data An example data set containing static test data in the same format as customer_support_contacts_data
         */
        var dataSetType: SupportDataSetType?
        /**
         * The name (friendly name, not ARN) of the destination S3 bucket.
         */
        var destinationS3BucketName: String?
        /**
         * (Optional) The desired S3 prefix for the published data set, similar to a directory path in standard file systems.
         * For example, if given the bucket name "mybucket" and the prefix "myprefix/mydatasets", the output file
         * "outputfile" would be published to "s3://mybucket/myprefix/mydatasets/outputfile".
         * If the prefix directory structure does not exist, it will be created.
         * If no prefix is provided, the data set will be published to the S3 bucket root.
         */
        var destinationS3Prefix: String?
        /**
         * The start date from which to retrieve the data set in UTC.  This parameter only affects the customer_support_contacts_data data set type.
         */
        var fromDate: Instant?
        /**
         * The Amazon Resource Name (ARN) of the Role with an attached permissions policy to interact with the provided
         * AWS services.
         */
        var roleNameArn: String?
        /**
         * Amazon Resource Name (ARN) for the SNS Topic that will be notified when the data set has been published or if an
         * error has occurred.
         */
        var snsTopicArn: String?

        fun build(): StartSupportDataExportRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var customerDefinedValues: Map<String, String>? = null
        override var dataSetType: SupportDataSetType? = null
        override var destinationS3BucketName: String? = null
        override var destinationS3Prefix: String? = null
        override var fromDate: Instant? = null
        override var roleNameArn: String? = null
        override var snsTopicArn: String? = null

        constructor(x: StartSupportDataExportRequest) : this() {
            this.customerDefinedValues = x.customerDefinedValues
            this.dataSetType = x.dataSetType
            this.destinationS3BucketName = x.destinationS3BucketName
            this.destinationS3Prefix = x.destinationS3Prefix
            this.fromDate = x.fromDate
            this.roleNameArn = x.roleNameArn
            this.snsTopicArn = x.snsTopicArn
        }

        override fun build(): StartSupportDataExportRequest = StartSupportDataExportRequest(this)
        override fun customerDefinedValues(customerDefinedValues: Map<String, String>): FluentBuilder = apply { this.customerDefinedValues = customerDefinedValues }
        override fun dataSetType(dataSetType: SupportDataSetType): FluentBuilder = apply { this.dataSetType = dataSetType }
        override fun destinationS3BucketName(destinationS3BucketName: String): FluentBuilder = apply { this.destinationS3BucketName = destinationS3BucketName }
        override fun destinationS3Prefix(destinationS3Prefix: String): FluentBuilder = apply { this.destinationS3Prefix = destinationS3Prefix }
        override fun fromDate(fromDate: Instant): FluentBuilder = apply { this.fromDate = fromDate }
        override fun roleNameArn(roleNameArn: String): FluentBuilder = apply { this.roleNameArn = roleNameArn }
        override fun snsTopicArn(snsTopicArn: String): FluentBuilder = apply { this.snsTopicArn = snsTopicArn }
    }
}
