// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.marketplacecommerceanalytics.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Container for the parameters to the GenerateDataSet operation.
 */
class GenerateDataSetRequest private constructor(builder: BuilderImpl) {
    /**
     * (Optional) Key-value pairs which will be returned, unmodified, in the
     * Amazon SNS notification message and the data set metadata file. These
     * key-value pairs can be used to correlated responses with tracking
     * information from other systems.
     */
    val customerDefinedValues: Map<String, String>? = builder.customerDefinedValues
    /**
     * The date a data set was published.
     * For daily data sets, provide a date with day-level granularity for the desired day.
     * For monthly data sets except those with prefix disbursed_amount, provide a date with month-level granularity for the desired month (the day value will be ignored).
     * For data sets with prefix disbursed_amount, provide a date with day-level granularity for the desired day. For these data sets we will look backwards in time over the range of 31 days until the first data set is found (the latest one).
     */
    val dataSetPublicationDate: Instant? = builder.dataSetPublicationDate
    /**
     * The desired data set type.
     * customer_subscriber_hourly_monthly_subscriptions
     * From 2017-09-15 to present: Available daily by 24:00 UTC.
     * customer_subscriber_annual_subscriptions
     * From 2017-09-15 to present: Available daily by 24:00 UTC.
     * daily_business_usage_by_instance_type
     * From 2017-09-15 to present: Available daily by 24:00 UTC.
     * daily_business_fees
     * From 2017-09-15 to present: Available daily by 24:00 UTC.
     * daily_business_free_trial_conversions
     * From 2017-09-15 to present: Available daily by 24:00 UTC.
     * daily_business_new_instances
     * From 2017-09-15 to present: Available daily by 24:00 UTC.
     * daily_business_new_product_subscribers
     * From 2017-09-15 to present: Available daily by 24:00 UTC.
     * daily_business_canceled_product_subscribers
     * From 2017-09-15 to present: Available daily by 24:00 UTC.
     * monthly_revenue_billing_and_revenue_data
     * From 2017-09-15 to present: Available monthly on the 15th day of the month by 24:00 UTC. Data includes metered transactions (e.g. hourly) from one month prior.
     * monthly_revenue_annual_subscriptions
     * From 2017-09-15 to present: Available monthly on the 15th day of the month by 24:00 UTC. Data includes up-front software charges (e.g. annual) from one month prior.
     * monthly_revenue_field_demonstration_usage
     * From 2018-03-15 to present: Available monthly on the 15th day of the month by 24:00 UTC.
     * monthly_revenue_flexible_payment_schedule
     * From 2018-11-15 to present: Available monthly on the 15th day of the month by 24:00 UTC.
     * disbursed_amount_by_product
     * From 2017-09-15 to present: Available every 30 days by 24:00 UTC.
     * disbursed_amount_by_instance_hours
     * From 2017-09-15 to present: Available every 30 days by 24:00 UTC.
     * disbursed_amount_by_customer_geo
     * From 2017-09-15 to present: Available every 30 days by 24:00 UTC.
     * disbursed_amount_by_age_of_uncollected_funds
     * From 2017-09-15 to present: Available every 30 days by 24:00 UTC.
     * disbursed_amount_by_age_of_disbursed_funds
     * From 2017-09-15 to present: Available every 30 days by 24:00 UTC.
     * disbursed_amount_by_age_of_past_due_funds
     * From 2018-04-07 to present: Available every 30 days by 24:00 UTC.
     * disbursed_amount_by_uncollected_funds_breakdown
     * From 2019-10-04 to present: Available every 30 days by 24:00 UTC.
     * sales_compensation_billed_revenue
     * From 2017-09-15 to present: Available monthly on the 15th day of the month by 24:00 UTC. Data includes metered transactions (e.g. hourly) from one month prior, and up-front software charges (e.g. annual) from one month prior.
     * us_sales_and_use_tax_records
     * From 2017-09-15 to present: Available monthly on the 15th day of the month by 24:00 UTC.
     * disbursed_amount_by_product_with_uncollected_funds
     * This data set is deprecated. Download related reports from AMMP instead!
     * customer_profile_by_industry
     * This data set is deprecated. Download related reports from AMMP instead!
     * customer_profile_by_revenue
     * This data set is deprecated. Download related reports from AMMP instead!
     * customer_profile_by_geography
     * This data set is deprecated. Download related reports from AMMP instead!
     */
    val dataSetType: DataSetType? = builder.dataSetType
    /**
     * The name (friendly name, not ARN) of the destination S3 bucket.
     */
    val destinationS3BucketName: String? = builder.destinationS3BucketName
    /**
     * (Optional) The desired S3 prefix for the published data set, similar to a directory path in standard file systems.
     * For example, if given the bucket name "mybucket" and the prefix "myprefix/mydatasets", the output file
     * "outputfile" would be published to "s3://mybucket/myprefix/mydatasets/outputfile".
     * If the prefix directory structure does not exist, it will be created.
     * If no prefix is provided, the data set will be published to the S3 bucket root.
     */
    val destinationS3Prefix: String? = builder.destinationS3Prefix
    /**
     * The Amazon Resource Name (ARN) of the Role with an attached permissions policy to interact with the provided
     * AWS services.
     */
    val roleNameArn: String? = builder.roleNameArn
    /**
     * Amazon Resource Name (ARN) for the SNS Topic that will be notified when the data set has been published or if an
     * error has occurred.
     */
    val snsTopicArn: String? = builder.snsTopicArn

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): GenerateDataSetRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("GenerateDataSetRequest(")
        append("customerDefinedValues=$customerDefinedValues,")
        append("dataSetPublicationDate=$dataSetPublicationDate,")
        append("dataSetType=$dataSetType,")
        append("destinationS3BucketName=$destinationS3BucketName,")
        append("destinationS3Prefix=$destinationS3Prefix,")
        append("roleNameArn=$roleNameArn,")
        append("snsTopicArn=$snsTopicArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = customerDefinedValues?.hashCode() ?: 0
        result = 31 * result + (dataSetPublicationDate?.hashCode() ?: 0)
        result = 31 * result + (dataSetType?.hashCode() ?: 0)
        result = 31 * result + (destinationS3BucketName?.hashCode() ?: 0)
        result = 31 * result + (destinationS3Prefix?.hashCode() ?: 0)
        result = 31 * result + (roleNameArn?.hashCode() ?: 0)
        result = 31 * result + (snsTopicArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as GenerateDataSetRequest

        if (customerDefinedValues != other.customerDefinedValues) return false
        if (dataSetPublicationDate != other.dataSetPublicationDate) return false
        if (dataSetType != other.dataSetType) return false
        if (destinationS3BucketName != other.destinationS3BucketName) return false
        if (destinationS3Prefix != other.destinationS3Prefix) return false
        if (roleNameArn != other.roleNameArn) return false
        if (snsTopicArn != other.snsTopicArn) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): GenerateDataSetRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): GenerateDataSetRequest
        /**
         * (Optional) Key-value pairs which will be returned, unmodified, in the
         * Amazon SNS notification message and the data set metadata file. These
         * key-value pairs can be used to correlated responses with tracking
         * information from other systems.
         */
        fun customerDefinedValues(customerDefinedValues: Map<String, String>): FluentBuilder
        /**
         * The date a data set was published.
         * For daily data sets, provide a date with day-level granularity for the desired day.
         * For monthly data sets except those with prefix disbursed_amount, provide a date with month-level granularity for the desired month (the day value will be ignored).
         * For data sets with prefix disbursed_amount, provide a date with day-level granularity for the desired day. For these data sets we will look backwards in time over the range of 31 days until the first data set is found (the latest one).
         */
        fun dataSetPublicationDate(dataSetPublicationDate: Instant): FluentBuilder
        /**
         * The desired data set type.
         * customer_subscriber_hourly_monthly_subscriptions
         * From 2017-09-15 to present: Available daily by 24:00 UTC.
         * customer_subscriber_annual_subscriptions
         * From 2017-09-15 to present: Available daily by 24:00 UTC.
         * daily_business_usage_by_instance_type
         * From 2017-09-15 to present: Available daily by 24:00 UTC.
         * daily_business_fees
         * From 2017-09-15 to present: Available daily by 24:00 UTC.
         * daily_business_free_trial_conversions
         * From 2017-09-15 to present: Available daily by 24:00 UTC.
         * daily_business_new_instances
         * From 2017-09-15 to present: Available daily by 24:00 UTC.
         * daily_business_new_product_subscribers
         * From 2017-09-15 to present: Available daily by 24:00 UTC.
         * daily_business_canceled_product_subscribers
         * From 2017-09-15 to present: Available daily by 24:00 UTC.
         * monthly_revenue_billing_and_revenue_data
         * From 2017-09-15 to present: Available monthly on the 15th day of the month by 24:00 UTC. Data includes metered transactions (e.g. hourly) from one month prior.
         * monthly_revenue_annual_subscriptions
         * From 2017-09-15 to present: Available monthly on the 15th day of the month by 24:00 UTC. Data includes up-front software charges (e.g. annual) from one month prior.
         * monthly_revenue_field_demonstration_usage
         * From 2018-03-15 to present: Available monthly on the 15th day of the month by 24:00 UTC.
         * monthly_revenue_flexible_payment_schedule
         * From 2018-11-15 to present: Available monthly on the 15th day of the month by 24:00 UTC.
         * disbursed_amount_by_product
         * From 2017-09-15 to present: Available every 30 days by 24:00 UTC.
         * disbursed_amount_by_instance_hours
         * From 2017-09-15 to present: Available every 30 days by 24:00 UTC.
         * disbursed_amount_by_customer_geo
         * From 2017-09-15 to present: Available every 30 days by 24:00 UTC.
         * disbursed_amount_by_age_of_uncollected_funds
         * From 2017-09-15 to present: Available every 30 days by 24:00 UTC.
         * disbursed_amount_by_age_of_disbursed_funds
         * From 2017-09-15 to present: Available every 30 days by 24:00 UTC.
         * disbursed_amount_by_age_of_past_due_funds
         * From 2018-04-07 to present: Available every 30 days by 24:00 UTC.
         * disbursed_amount_by_uncollected_funds_breakdown
         * From 2019-10-04 to present: Available every 30 days by 24:00 UTC.
         * sales_compensation_billed_revenue
         * From 2017-09-15 to present: Available monthly on the 15th day of the month by 24:00 UTC. Data includes metered transactions (e.g. hourly) from one month prior, and up-front software charges (e.g. annual) from one month prior.
         * us_sales_and_use_tax_records
         * From 2017-09-15 to present: Available monthly on the 15th day of the month by 24:00 UTC.
         * disbursed_amount_by_product_with_uncollected_funds
         * This data set is deprecated. Download related reports from AMMP instead!
         * customer_profile_by_industry
         * This data set is deprecated. Download related reports from AMMP instead!
         * customer_profile_by_revenue
         * This data set is deprecated. Download related reports from AMMP instead!
         * customer_profile_by_geography
         * This data set is deprecated. Download related reports from AMMP instead!
         */
        fun dataSetType(dataSetType: DataSetType): FluentBuilder
        /**
         * The name (friendly name, not ARN) of the destination S3 bucket.
         */
        fun destinationS3BucketName(destinationS3BucketName: String): FluentBuilder
        /**
         * (Optional) The desired S3 prefix for the published data set, similar to a directory path in standard file systems.
         * For example, if given the bucket name "mybucket" and the prefix "myprefix/mydatasets", the output file
         * "outputfile" would be published to "s3://mybucket/myprefix/mydatasets/outputfile".
         * If the prefix directory structure does not exist, it will be created.
         * If no prefix is provided, the data set will be published to the S3 bucket root.
         */
        fun destinationS3Prefix(destinationS3Prefix: String): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the Role with an attached permissions policy to interact with the provided
         * AWS services.
         */
        fun roleNameArn(roleNameArn: String): FluentBuilder
        /**
         * Amazon Resource Name (ARN) for the SNS Topic that will be notified when the data set has been published or if an
         * error has occurred.
         */
        fun snsTopicArn(snsTopicArn: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * (Optional) Key-value pairs which will be returned, unmodified, in the
         * Amazon SNS notification message and the data set metadata file. These
         * key-value pairs can be used to correlated responses with tracking
         * information from other systems.
         */
        var customerDefinedValues: Map<String, String>?
        /**
         * The date a data set was published.
         * For daily data sets, provide a date with day-level granularity for the desired day.
         * For monthly data sets except those with prefix disbursed_amount, provide a date with month-level granularity for the desired month (the day value will be ignored).
         * For data sets with prefix disbursed_amount, provide a date with day-level granularity for the desired day. For these data sets we will look backwards in time over the range of 31 days until the first data set is found (the latest one).
         */
        var dataSetPublicationDate: Instant?
        /**
         * The desired data set type.
         * customer_subscriber_hourly_monthly_subscriptions
         * From 2017-09-15 to present: Available daily by 24:00 UTC.
         * customer_subscriber_annual_subscriptions
         * From 2017-09-15 to present: Available daily by 24:00 UTC.
         * daily_business_usage_by_instance_type
         * From 2017-09-15 to present: Available daily by 24:00 UTC.
         * daily_business_fees
         * From 2017-09-15 to present: Available daily by 24:00 UTC.
         * daily_business_free_trial_conversions
         * From 2017-09-15 to present: Available daily by 24:00 UTC.
         * daily_business_new_instances
         * From 2017-09-15 to present: Available daily by 24:00 UTC.
         * daily_business_new_product_subscribers
         * From 2017-09-15 to present: Available daily by 24:00 UTC.
         * daily_business_canceled_product_subscribers
         * From 2017-09-15 to present: Available daily by 24:00 UTC.
         * monthly_revenue_billing_and_revenue_data
         * From 2017-09-15 to present: Available monthly on the 15th day of the month by 24:00 UTC. Data includes metered transactions (e.g. hourly) from one month prior.
         * monthly_revenue_annual_subscriptions
         * From 2017-09-15 to present: Available monthly on the 15th day of the month by 24:00 UTC. Data includes up-front software charges (e.g. annual) from one month prior.
         * monthly_revenue_field_demonstration_usage
         * From 2018-03-15 to present: Available monthly on the 15th day of the month by 24:00 UTC.
         * monthly_revenue_flexible_payment_schedule
         * From 2018-11-15 to present: Available monthly on the 15th day of the month by 24:00 UTC.
         * disbursed_amount_by_product
         * From 2017-09-15 to present: Available every 30 days by 24:00 UTC.
         * disbursed_amount_by_instance_hours
         * From 2017-09-15 to present: Available every 30 days by 24:00 UTC.
         * disbursed_amount_by_customer_geo
         * From 2017-09-15 to present: Available every 30 days by 24:00 UTC.
         * disbursed_amount_by_age_of_uncollected_funds
         * From 2017-09-15 to present: Available every 30 days by 24:00 UTC.
         * disbursed_amount_by_age_of_disbursed_funds
         * From 2017-09-15 to present: Available every 30 days by 24:00 UTC.
         * disbursed_amount_by_age_of_past_due_funds
         * From 2018-04-07 to present: Available every 30 days by 24:00 UTC.
         * disbursed_amount_by_uncollected_funds_breakdown
         * From 2019-10-04 to present: Available every 30 days by 24:00 UTC.
         * sales_compensation_billed_revenue
         * From 2017-09-15 to present: Available monthly on the 15th day of the month by 24:00 UTC. Data includes metered transactions (e.g. hourly) from one month prior, and up-front software charges (e.g. annual) from one month prior.
         * us_sales_and_use_tax_records
         * From 2017-09-15 to present: Available monthly on the 15th day of the month by 24:00 UTC.
         * disbursed_amount_by_product_with_uncollected_funds
         * This data set is deprecated. Download related reports from AMMP instead!
         * customer_profile_by_industry
         * This data set is deprecated. Download related reports from AMMP instead!
         * customer_profile_by_revenue
         * This data set is deprecated. Download related reports from AMMP instead!
         * customer_profile_by_geography
         * This data set is deprecated. Download related reports from AMMP instead!
         */
        var dataSetType: DataSetType?
        /**
         * The name (friendly name, not ARN) of the destination S3 bucket.
         */
        var destinationS3BucketName: String?
        /**
         * (Optional) The desired S3 prefix for the published data set, similar to a directory path in standard file systems.
         * For example, if given the bucket name "mybucket" and the prefix "myprefix/mydatasets", the output file
         * "outputfile" would be published to "s3://mybucket/myprefix/mydatasets/outputfile".
         * If the prefix directory structure does not exist, it will be created.
         * If no prefix is provided, the data set will be published to the S3 bucket root.
         */
        var destinationS3Prefix: String?
        /**
         * The Amazon Resource Name (ARN) of the Role with an attached permissions policy to interact with the provided
         * AWS services.
         */
        var roleNameArn: String?
        /**
         * Amazon Resource Name (ARN) for the SNS Topic that will be notified when the data set has been published or if an
         * error has occurred.
         */
        var snsTopicArn: String?

        fun build(): GenerateDataSetRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var customerDefinedValues: Map<String, String>? = null
        override var dataSetPublicationDate: Instant? = null
        override var dataSetType: DataSetType? = null
        override var destinationS3BucketName: String? = null
        override var destinationS3Prefix: String? = null
        override var roleNameArn: String? = null
        override var snsTopicArn: String? = null

        constructor(x: GenerateDataSetRequest) : this() {
            this.customerDefinedValues = x.customerDefinedValues
            this.dataSetPublicationDate = x.dataSetPublicationDate
            this.dataSetType = x.dataSetType
            this.destinationS3BucketName = x.destinationS3BucketName
            this.destinationS3Prefix = x.destinationS3Prefix
            this.roleNameArn = x.roleNameArn
            this.snsTopicArn = x.snsTopicArn
        }

        override fun build(): GenerateDataSetRequest = GenerateDataSetRequest(this)
        override fun customerDefinedValues(customerDefinedValues: Map<String, String>): FluentBuilder = apply { this.customerDefinedValues = customerDefinedValues }
        override fun dataSetPublicationDate(dataSetPublicationDate: Instant): FluentBuilder = apply { this.dataSetPublicationDate = dataSetPublicationDate }
        override fun dataSetType(dataSetType: DataSetType): FluentBuilder = apply { this.dataSetType = dataSetType }
        override fun destinationS3BucketName(destinationS3BucketName: String): FluentBuilder = apply { this.destinationS3BucketName = destinationS3BucketName }
        override fun destinationS3Prefix(destinationS3Prefix: String): FluentBuilder = apply { this.destinationS3Prefix = destinationS3Prefix }
        override fun roleNameArn(roleNameArn: String): FluentBuilder = apply { this.roleNameArn = roleNameArn }
        override fun snsTopicArn(snsTopicArn: String): FluentBuilder = apply { this.snsTopicArn = snsTopicArn }
    }
}
