// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.marketplacecommerceanalytics

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.execution.AuthAttributes
import aws.sdk.kotlin.runtime.http.engine.crt.CrtHttpEngine
import aws.sdk.kotlin.services.marketplacecommerceanalytics.model.*
import aws.sdk.kotlin.services.marketplacecommerceanalytics.transform.*
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.util.putIfAbsent


const val ServiceId: String = "Marketplace Commerce Analytics"
const val ServiceApiVersion: String = "2015-07-01"
const val SdkVersion: String = "0.8.0-alpha"

internal class DefaultMarketplaceCommerceAnalyticsClient(override val config: MarketplaceCommerceAnalyticsClient.Config) : MarketplaceCommerceAnalyticsClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: CrtHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }

    /**
     * Given a data set type and data set publication date, asynchronously publishes the requested data set to the specified
     * S3 bucket and notifies the specified SNS topic once the data is available. Returns a unique request identifier that
     * can be used to correlate requests with notifications from the SNS topic.
     * Data sets will be published in comma-separated values (CSV) format with the file name {data_set_type}_YYYY-MM-DD.csv.
     * If a file with the same name already exists (e.g. if the same data set is requested twice), the original file will
     * be overwritten by the new file.
     * Requires a Role with an attached permissions policy providing Allow permissions for the following actions:
     * s3:PutObject, s3:GetBucketLocation, sns:GetTopicAttributes, sns:Publish, iam:GetRolePolicy.
     */
    override suspend fun generateDataSet(input: GenerateDataSetRequest): GenerateDataSetResponse {
        val op = SdkHttpOperation.build<GenerateDataSetRequest, GenerateDataSetResponse> {
            serializer = GenerateDataSetOperationSerializer()
            deserializer = GenerateDataSetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GenerateDataSet"
            }
        }
        registerGenerateDataSetMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Given a data set type and a from date, asynchronously publishes the requested customer support data
     * to the specified S3 bucket and notifies the specified SNS topic once the data is available. Returns a unique request
     * identifier that can be used to correlate requests with notifications from the SNS topic.
     * Data sets will be published in comma-separated values (CSV) format with the file name {data_set_type}_YYYY-MM-DD'T'HH-mm-ss'Z'.csv.
     * If a file with the same name already exists (e.g. if the same data set is requested twice), the original file will
     * be overwritten by the new file.
     * Requires a Role with an attached permissions policy providing Allow permissions for the following actions:
     * s3:PutObject, s3:GetBucketLocation, sns:GetTopicAttributes, sns:Publish, iam:GetRolePolicy.
     */
    override suspend fun startSupportDataExport(input: StartSupportDataExportRequest): StartSupportDataExportResponse {
        val op = SdkHttpOperation.build<StartSupportDataExportRequest, StartSupportDataExportResponse> {
            serializer = StartSupportDataExportOperationSerializer()
            deserializer = StartSupportDataExportOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartSupportDataExport"
            }
        }
        registerStartSupportDataExportMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(AuthAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
    }
}
