// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.marketplaceagreement.serde

import aws.sdk.kotlin.services.marketplaceagreement.model.Acceptor
import aws.sdk.kotlin.services.marketplaceagreement.model.AgreementStatus
import aws.sdk.kotlin.services.marketplaceagreement.model.DescribeAgreementResponse
import aws.sdk.kotlin.services.marketplaceagreement.model.EstimatedCharges
import aws.sdk.kotlin.services.marketplaceagreement.model.MarketplaceAgreementException
import aws.sdk.kotlin.services.marketplaceagreement.model.ProposalSummary
import aws.sdk.kotlin.services.marketplaceagreement.model.Proposer
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class DescribeAgreementOperationDeserializer: HttpDeserializer.NonStreaming<DescribeAgreementResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeAgreementResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeAgreementError(context, call, payload)
        }
        val builder = DescribeAgreementResponse.Builder()

        if (payload != null) {
            deserializeDescribeAgreementOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeAgreementError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw MarketplaceAgreementException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> MarketplaceAgreementException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeAgreementOperationBody(builder: DescribeAgreementResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ACCEPTANCETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("acceptanceTime"))
    val ACCEPTOR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("acceptor"))
    val AGREEMENTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("agreementId"))
    val AGREEMENTTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("agreementType"))
    val ENDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("endTime"))
    val ESTIMATEDCHARGES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("estimatedCharges"))
    val PROPOSALSUMMARY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("proposalSummary"))
    val PROPOSER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("proposer"))
    val STARTTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("startTime"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("status"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACCEPTANCETIME_DESCRIPTOR)
        field(ACCEPTOR_DESCRIPTOR)
        field(AGREEMENTID_DESCRIPTOR)
        field(AGREEMENTTYPE_DESCRIPTOR)
        field(ENDTIME_DESCRIPTOR)
        field(ESTIMATEDCHARGES_DESCRIPTOR)
        field(PROPOSALSUMMARY_DESCRIPTOR)
        field(PROPOSER_DESCRIPTOR)
        field(STARTTIME_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ACCEPTANCETIME_DESCRIPTOR.index -> builder.acceptanceTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                ACCEPTOR_DESCRIPTOR.index -> builder.acceptor = deserializeAcceptorDocument(deserializer)
                AGREEMENTID_DESCRIPTOR.index -> builder.agreementId = deserializeString()
                AGREEMENTTYPE_DESCRIPTOR.index -> builder.agreementType = deserializeString()
                ENDTIME_DESCRIPTOR.index -> builder.endTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                ESTIMATEDCHARGES_DESCRIPTOR.index -> builder.estimatedCharges = deserializeEstimatedChargesDocument(deserializer)
                PROPOSALSUMMARY_DESCRIPTOR.index -> builder.proposalSummary = deserializeProposalSummaryDocument(deserializer)
                PROPOSER_DESCRIPTOR.index -> builder.proposer = deserializeProposerDocument(deserializer)
                STARTTIME_DESCRIPTOR.index -> builder.startTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { AgreementStatus.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
