// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.marketplaceagreement.model

import aws.smithy.kotlin.runtime.SdkDsl

public class SearchAgreementsRequest private constructor(builder: Builder) {
    /**
     * The catalog in which the agreement was created.
     */
    public val catalog: kotlin.String? = builder.catalog
    /**
     * The filter name and value pair used to return a specific list of results.
     *
     * The following filters are supported:
     * + `ResourceIdentifier` – The unique identifier of the resource.
     * + `ResourceType` – Type of the resource, which is the product (`AmiProduct`, `ContainerProduct`, or `SaaSProduct`).
     * + `PartyType` – The party type (either `Acceptor` or `Proposer`) of the caller. For agreements where the caller is the proposer, use the `Proposer` filter. For agreements where the caller is the acceptor, use the `Acceptor` filter.
     * + `AcceptorAccountId` – The AWS account ID of the party accepting the agreement terms.
     * + `OfferId` – The unique identifier of the offer in which the terms are registered in the agreement token.
     * + `Status` – The current status of the agreement. Values include `ACTIVE`, `ARCHIVED`, `CANCELLED`, `EXPIRED`, `RENEWED`, `REPLACED`, and `TERMINATED`.
     * + `BeforeEndTime` – A date used to filter agreements with a date before the `endTime` of an agreement.
     * + `AfterEndTime` – A date used to filter agreements with a date after the `endTime` of an agreement.
     * + `AgreementType` – The type of agreement. Values include `PurchaseAgreement` or `VendorInsightsAgreement`.
     */
    public val filters: List<Filter>? = builder.filters
    /**
     * The maximum number of agreements to return in the response.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * A token to specify where to start pagination.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * An object that contains the `SortBy` and `SortOrder` attributes.
     */
    public val sort: aws.sdk.kotlin.services.marketplaceagreement.model.Sort? = builder.sort

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.marketplaceagreement.model.SearchAgreementsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SearchAgreementsRequest(")
        append("catalog=$catalog,")
        append("filters=$filters,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("sort=$sort")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = catalog?.hashCode() ?: 0
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (sort?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SearchAgreementsRequest

        if (catalog != other.catalog) return false
        if (filters != other.filters) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (sort != other.sort) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.marketplaceagreement.model.SearchAgreementsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The catalog in which the agreement was created.
         */
        public var catalog: kotlin.String? = null
        /**
         * The filter name and value pair used to return a specific list of results.
         *
         * The following filters are supported:
         * + `ResourceIdentifier` – The unique identifier of the resource.
         * + `ResourceType` – Type of the resource, which is the product (`AmiProduct`, `ContainerProduct`, or `SaaSProduct`).
         * + `PartyType` – The party type (either `Acceptor` or `Proposer`) of the caller. For agreements where the caller is the proposer, use the `Proposer` filter. For agreements where the caller is the acceptor, use the `Acceptor` filter.
         * + `AcceptorAccountId` – The AWS account ID of the party accepting the agreement terms.
         * + `OfferId` – The unique identifier of the offer in which the terms are registered in the agreement token.
         * + `Status` – The current status of the agreement. Values include `ACTIVE`, `ARCHIVED`, `CANCELLED`, `EXPIRED`, `RENEWED`, `REPLACED`, and `TERMINATED`.
         * + `BeforeEndTime` – A date used to filter agreements with a date before the `endTime` of an agreement.
         * + `AfterEndTime` – A date used to filter agreements with a date after the `endTime` of an agreement.
         * + `AgreementType` – The type of agreement. Values include `PurchaseAgreement` or `VendorInsightsAgreement`.
         */
        public var filters: List<Filter>? = null
        /**
         * The maximum number of agreements to return in the response.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * A token to specify where to start pagination.
         */
        public var nextToken: kotlin.String? = null
        /**
         * An object that contains the `SortBy` and `SortOrder` attributes.
         */
        public var sort: aws.sdk.kotlin.services.marketplaceagreement.model.Sort? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.marketplaceagreement.model.SearchAgreementsRequest) : this() {
            this.catalog = x.catalog
            this.filters = x.filters
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.sort = x.sort
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.marketplaceagreement.model.SearchAgreementsRequest = SearchAgreementsRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.marketplaceagreement.model.Sort] inside the given [block]
         */
        public fun sort(block: aws.sdk.kotlin.services.marketplaceagreement.model.Sort.Builder.() -> kotlin.Unit) {
            this.sort = aws.sdk.kotlin.services.marketplaceagreement.model.Sort.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
