// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.marketplaceagreement.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Defines an installment-based pricing model where customers are charged a fixed price on different dates during the agreement validity period. This is used most commonly for flexible payment schedule pricing.
 */
public class PaymentScheduleTerm private constructor(builder: Builder) {
    /**
     * Defines the currency for the prices mentioned in the term.
     */
    public val currencyCode: kotlin.String? = builder.currencyCode
    /**
     * List of the payment schedule where each element defines one installment of payment. It contains the information necessary for calculating the price.
     */
    public val schedule: List<ScheduleItem>? = builder.schedule
    /**
     * Type of the term.
     */
    public val type: kotlin.String? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.marketplaceagreement.model.PaymentScheduleTerm = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PaymentScheduleTerm(")
        append("currencyCode=$currencyCode,")
        append("schedule=$schedule,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = currencyCode?.hashCode() ?: 0
        result = 31 * result + (schedule?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PaymentScheduleTerm

        if (currencyCode != other.currencyCode) return false
        if (schedule != other.schedule) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.marketplaceagreement.model.PaymentScheduleTerm = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Defines the currency for the prices mentioned in the term.
         */
        public var currencyCode: kotlin.String? = null
        /**
         * List of the payment schedule where each element defines one installment of payment. It contains the information necessary for calculating the price.
         */
        public var schedule: List<ScheduleItem>? = null
        /**
         * Type of the term.
         */
        public var type: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.marketplaceagreement.model.PaymentScheduleTerm) : this() {
            this.currencyCode = x.currencyCode
            this.schedule = x.schedule
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.marketplaceagreement.model.PaymentScheduleTerm = PaymentScheduleTerm(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
