// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.marketplaceagreement.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Estimated cost of the agreement.
 */
public class EstimatedCharges private constructor(builder: Builder) {
    /**
     * The total known amount customer has to pay across the lifecycle of the agreement.
     *
     * This is the total contract value if accepted terms contain `ConfigurableUpfrontPricingTerm` or `FixedUpfrontPricingTerm`. In the case of pure contract pricing, this will be the total value of the contract. In the case of contracts with consumption pricing, this will only include the committed value and not include any overages that occur.
     *
     * If the accepted terms contain `PaymentScheduleTerm`, it will be the total payment schedule amount. This occurs when flexible payment schedule is used, and is the sum of all invoice charges in the payment schedule.
     *
     * In case a customer has amended an agreement, by purchasing more units of any dimension, this will include both the original cost as well as the added cost incurred due to addition of new units.
     *
     * This is `0` if the accepted terms contain `UsageBasedPricingTerm` without `ConfigurableUpfrontPricingTerm` or `RecurringPaymentTerm`. This occurs for usage-based pricing (such as SaaS metered or AMI/container hourly or monthly), because the exact usage is not known upfront.
     */
    public val agreementValue: kotlin.String? = builder.agreementValue
    /**
     * Defines the currency code for the charge.
     */
    public val currencyCode: kotlin.String? = builder.currencyCode

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.marketplaceagreement.model.EstimatedCharges = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EstimatedCharges(")
        append("agreementValue=$agreementValue,")
        append("currencyCode=$currencyCode")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = agreementValue?.hashCode() ?: 0
        result = 31 * result + (currencyCode?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EstimatedCharges

        if (agreementValue != other.agreementValue) return false
        if (currencyCode != other.currencyCode) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.marketplaceagreement.model.EstimatedCharges = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The total known amount customer has to pay across the lifecycle of the agreement.
         *
         * This is the total contract value if accepted terms contain `ConfigurableUpfrontPricingTerm` or `FixedUpfrontPricingTerm`. In the case of pure contract pricing, this will be the total value of the contract. In the case of contracts with consumption pricing, this will only include the committed value and not include any overages that occur.
         *
         * If the accepted terms contain `PaymentScheduleTerm`, it will be the total payment schedule amount. This occurs when flexible payment schedule is used, and is the sum of all invoice charges in the payment schedule.
         *
         * In case a customer has amended an agreement, by purchasing more units of any dimension, this will include both the original cost as well as the added cost incurred due to addition of new units.
         *
         * This is `0` if the accepted terms contain `UsageBasedPricingTerm` without `ConfigurableUpfrontPricingTerm` or `RecurringPaymentTerm`. This occurs for usage-based pricing (such as SaaS metered or AMI/container hourly or monthly), because the exact usage is not known upfront.
         */
        public var agreementValue: kotlin.String? = null
        /**
         * Defines the currency code for the charge.
         */
        public var currencyCode: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.marketplaceagreement.model.EstimatedCharges) : this() {
            this.agreementValue = x.agreementValue
            this.currencyCode = x.currencyCode
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.marketplaceagreement.model.EstimatedCharges = EstimatedCharges(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
