// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.marketplaceagreement.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * A summary of the agreement, including top-level attributes (for example, the agreement ID, version, proposer, and acceptor).
 */
public class AgreementViewSummary private constructor(builder: Builder) {
    /**
     * The date and time that the agreement was accepted.
     */
    public val acceptanceTime: aws.smithy.kotlin.runtime.time.Instant? = builder.acceptanceTime
    /**
     * Details of the party accepting the agreement terms. This is commonly the buyer for `PurchaseAgreement.`
     */
    public val acceptor: aws.sdk.kotlin.services.marketplaceagreement.model.Acceptor? = builder.acceptor
    /**
     * The unique identifier of the agreement.
     */
    public val agreementId: kotlin.String? = builder.agreementId
    /**
     * The type of agreement. Values are `PurchaseAgreement` or `VendorInsightsAgreement`.
     */
    public val agreementType: kotlin.String? = builder.agreementType
    /**
     * The date and time when the agreement ends. The field is `null` for pay-as-you-go agreements, which don’t have end dates.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * A summary of the proposal
     */
    public val proposalSummary: aws.sdk.kotlin.services.marketplaceagreement.model.ProposalSummary? = builder.proposalSummary
    /**
     * Details of the party proposing the agreement terms, most commonly the seller for `PurchaseAgreement`.
     */
    public val proposer: aws.sdk.kotlin.services.marketplaceagreement.model.Proposer? = builder.proposer
    /**
     * The date and time when the agreement starts.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * The current status of the agreement.
     */
    public val status: aws.sdk.kotlin.services.marketplaceagreement.model.AgreementStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.marketplaceagreement.model.AgreementViewSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AgreementViewSummary(")
        append("acceptanceTime=$acceptanceTime,")
        append("acceptor=$acceptor,")
        append("agreementId=$agreementId,")
        append("agreementType=$agreementType,")
        append("endTime=$endTime,")
        append("proposalSummary=$proposalSummary,")
        append("proposer=$proposer,")
        append("startTime=$startTime,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = acceptanceTime?.hashCode() ?: 0
        result = 31 * result + (acceptor?.hashCode() ?: 0)
        result = 31 * result + (agreementId?.hashCode() ?: 0)
        result = 31 * result + (agreementType?.hashCode() ?: 0)
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (proposalSummary?.hashCode() ?: 0)
        result = 31 * result + (proposer?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AgreementViewSummary

        if (acceptanceTime != other.acceptanceTime) return false
        if (acceptor != other.acceptor) return false
        if (agreementId != other.agreementId) return false
        if (agreementType != other.agreementType) return false
        if (endTime != other.endTime) return false
        if (proposalSummary != other.proposalSummary) return false
        if (proposer != other.proposer) return false
        if (startTime != other.startTime) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.marketplaceagreement.model.AgreementViewSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The date and time that the agreement was accepted.
         */
        public var acceptanceTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Details of the party accepting the agreement terms. This is commonly the buyer for `PurchaseAgreement.`
         */
        public var acceptor: aws.sdk.kotlin.services.marketplaceagreement.model.Acceptor? = null
        /**
         * The unique identifier of the agreement.
         */
        public var agreementId: kotlin.String? = null
        /**
         * The type of agreement. Values are `PurchaseAgreement` or `VendorInsightsAgreement`.
         */
        public var agreementType: kotlin.String? = null
        /**
         * The date and time when the agreement ends. The field is `null` for pay-as-you-go agreements, which don’t have end dates.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A summary of the proposal
         */
        public var proposalSummary: aws.sdk.kotlin.services.marketplaceagreement.model.ProposalSummary? = null
        /**
         * Details of the party proposing the agreement terms, most commonly the seller for `PurchaseAgreement`.
         */
        public var proposer: aws.sdk.kotlin.services.marketplaceagreement.model.Proposer? = null
        /**
         * The date and time when the agreement starts.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The current status of the agreement.
         */
        public var status: aws.sdk.kotlin.services.marketplaceagreement.model.AgreementStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.marketplaceagreement.model.AgreementViewSummary) : this() {
            this.acceptanceTime = x.acceptanceTime
            this.acceptor = x.acceptor
            this.agreementId = x.agreementId
            this.agreementType = x.agreementType
            this.endTime = x.endTime
            this.proposalSummary = x.proposalSummary
            this.proposer = x.proposer
            this.startTime = x.startTime
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.marketplaceagreement.model.AgreementViewSummary = AgreementViewSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.marketplaceagreement.model.Acceptor] inside the given [block]
         */
        public fun acceptor(block: aws.sdk.kotlin.services.marketplaceagreement.model.Acceptor.Builder.() -> kotlin.Unit) {
            this.acceptor = aws.sdk.kotlin.services.marketplaceagreement.model.Acceptor.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.marketplaceagreement.model.ProposalSummary] inside the given [block]
         */
        public fun proposalSummary(block: aws.sdk.kotlin.services.marketplaceagreement.model.ProposalSummary.Builder.() -> kotlin.Unit) {
            this.proposalSummary = aws.sdk.kotlin.services.marketplaceagreement.model.ProposalSummary.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.marketplaceagreement.model.Proposer] inside the given [block]
         */
        public fun proposer(block: aws.sdk.kotlin.services.marketplaceagreement.model.Proposer.Builder.() -> kotlin.Unit) {
            this.proposer = aws.sdk.kotlin.services.marketplaceagreement.model.Proposer.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
