// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.marketplaceagreement

import aws.sdk.kotlin.runtime.auth.credentials.StaticCredentialsProvider
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.interceptors.AwsSpanInterceptor
import aws.sdk.kotlin.runtime.http.interceptors.businessmetrics.AwsBusinessMetric
import aws.sdk.kotlin.runtime.http.interceptors.businessmetrics.BusinessMetricsInterceptor
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryHeaderMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.services.marketplaceagreement.auth.MarketplaceAgreementAuthSchemeProviderAdapter
import aws.sdk.kotlin.services.marketplaceagreement.auth.MarketplaceAgreementIdentityProviderConfigAdapter
import aws.sdk.kotlin.services.marketplaceagreement.endpoints.internal.EndpointResolverAdapter
import aws.sdk.kotlin.services.marketplaceagreement.model.*
import aws.sdk.kotlin.services.marketplaceagreement.serde.*
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.awsprotocol.AwsAttributes
import aws.smithy.kotlin.runtime.awsprotocol.json.AwsJsonProtocol
import aws.smithy.kotlin.runtime.businessmetrics.emitBusinessMetric
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.collections.attributesOf
import aws.smithy.kotlin.runtime.collections.putIfAbsent
import aws.smithy.kotlin.runtime.collections.putIfAbsentNotNull
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.SigV4AuthScheme
import aws.smithy.kotlin.runtime.http.operation.OperationAuthConfig
import aws.smithy.kotlin.runtime.http.operation.OperationMetrics
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.operation.telemetry
import aws.smithy.kotlin.runtime.io.SdkManagedGroup
import aws.smithy.kotlin.runtime.io.addIfManaged
import aws.smithy.kotlin.runtime.operation.ExecutionContext

internal class DefaultMarketplaceAgreementClient(override val config: MarketplaceAgreementClient.Config) : MarketplaceAgreementClient {
    private val managedResources = SdkManagedGroup()
    private val client = SdkHttpClient(config.httpClient)
    private val identityProviderConfig = MarketplaceAgreementIdentityProviderConfigAdapter(config)
    private val configuredAuthSchemes = with(config.authSchemes.associateBy(AuthScheme::schemeId).toMutableMap()){
        getOrPut(AuthSchemeId.AwsSigV4){
            SigV4AuthScheme(DefaultAwsSigner, "aws-marketplace")
        }
        toMap()
    }
    private val authSchemeAdapter = MarketplaceAgreementAuthSchemeProviderAdapter(config)
    private val telemetryScope = "aws.sdk.kotlin.services.marketplaceagreement"
    private val opMetrics = OperationMetrics(telemetryScope, config.telemetryProvider)

    init {
        managedResources.addIfManaged(config.httpClient)
        managedResources.addIfManaged(config.credentialsProvider)
    }

    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion), config.applicationId)

    /**
     * Provides details about an agreement, such as the proposer, acceptor, start date, and end date.
     */
    override suspend fun describeAgreement(input: DescribeAgreementRequest): DescribeAgreementResponse {
        val op = SdkHttpOperation.build<DescribeAgreementRequest, DescribeAgreementResponse> {
            serializeWith = DescribeAgreementOperationSerializer()
            deserializeWith = DescribeAgreementOperationDeserializer()
            operationName = "DescribeAgreement"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(AwsJsonProtocol("AWSMPCommerceService_v20200301", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Obtains details about the terms in an agreement that you participated in as proposer or acceptor.
     *
     * The details include:
     * + `TermType` – The type of term, such as `LegalTerm`, `RenewalTerm`, or `ConfigurableUpfrontPricingTerm`.
     * + `TermID` – The ID of the particular term, which is common between offer and agreement.
     * + `TermPayload` – The key information contained in the term, such as the EULA for `LegalTerm` or pricing and dimensions for various pricing terms, such as `ConfigurableUpfrontPricingTerm` or `UsageBasedPricingTerm`.
     *
     * + `Configuration` – The buyer/acceptor's selection at the time of agreement creation, such as the number of units purchased for a dimension or setting the `EnableAutoRenew` flag.
     */
    override suspend fun getAgreementTerms(input: GetAgreementTermsRequest): GetAgreementTermsResponse {
        val op = SdkHttpOperation.build<GetAgreementTermsRequest, GetAgreementTermsResponse> {
            serializeWith = GetAgreementTermsOperationSerializer()
            deserializeWith = GetAgreementTermsOperationDeserializer()
            operationName = "GetAgreementTerms"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(AwsJsonProtocol("AWSMPCommerceService_v20200301", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Searches across all agreements that a proposer or an acceptor has in AWS Marketplace. The search returns a list of agreements with basic agreement information.
     *
     * The following filter combinations are supported:
     * + `PartyType` as `Proposer` + `AgreementType` + `ResourceIdentifier`
     * + `PartyType` as `Proposer` + `AgreementType` + `OfferId`
     * + `PartyType` as `Proposer` + `AgreementType` + `AcceptorAccountId`
     * + `PartyType` as `Proposer` + `AgreementType` + `Status`
     * + `PartyType` as `Proposer` + `AgreementType` + `ResourceIdentifier` + `Status`
     * + `PartyType` as `Proposer` + `AgreementType` + `OfferId` + `Status`
     * + `PartyType` as `Proposer` + `AgreementType` + `AcceptorAccountId` + `Status`
     * + `PartyType` as `Proposer` + `AgreementType` + `ResourceType` + `Status`
     * + `PartyType` as `Proposer` + `AgreementType` + `AcceptorAccountId` + `ResourceType` + `Status`
     * + `PartyType` as `Proposer` + `AgreementType` + `AcceptorAccountId` + `OfferId`
     * + `PartyType` as `Proposer` + `AgreementType` + `AcceptorAccountId` + `OfferId` + `Status`
     * + `PartyType` as `Proposer` + `AgreementType` + `AcceptorAccountId` + `ResourceIdentifier`
     * + `PartyType` as `Proposer` + `AgreementType` + `AcceptorAccountId` + `ResourceIdentifier` + `Status`
     * + `PartyType` as `Proposer` + `AgreementType` + `AcceptorAccountId` + `ResourceType`
     */
    override suspend fun searchAgreements(input: SearchAgreementsRequest): SearchAgreementsResponse {
        val op = SdkHttpOperation.build<SearchAgreementsRequest, SearchAgreementsResponse> {
            serializeWith = SearchAgreementsOperationSerializer()
            deserializeWith = SearchAgreementsOperationDeserializer()
            operationName = "SearchAgreements"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        if (config.credentialsProvider is StaticCredentialsProvider) {
            op.context.emitBusinessMetric(AwsBusinessMetric.Credentials.CREDENTIALS_CODE)
        }
        op.install(AwsJsonProtocol("AWSMPCommerceService_v20200301", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    override fun close() {
        managedResources.unshareAll()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(SdkClientOption.ClientName, config.clientName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.logMode)
        ctx.putIfAbsentNotNull(AwsAttributes.Region, config.region)
        ctx.putIfAbsentNotNull(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "aws-marketplace")
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }

}
