// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.marketplaceagreement.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Defines the conditions that will keep an agreement created from this offer valid.
 */
public class ValidityTerm private constructor(builder: Builder) {
    /**
     * Defines the duration that the agreement remains active. If `AgreementStartDate` isn’t provided, the agreement duration is relative to the agreement signature time. The duration is represented in the ISO_8601 format.
     */
    public val agreementDuration: kotlin.String? = builder.agreementDuration
    /**
     * Defines the date when the agreement ends. The agreement ends at 23:59:59.999 UTC on the date provided. If `AgreementEndDate` isn’t provided, the agreement end date is determined by the validity of individual terms.
     */
    public val agreementEndDate: aws.smithy.kotlin.runtime.time.Instant? = builder.agreementEndDate
    /**
     * Defines the date when agreement starts. The agreement starts at 00:00:00.000 UTC on the date provided. If `AgreementStartDate` isn’t provided, the agreement start date is determined based on agreement signature time.
     */
    public val agreementStartDate: aws.smithy.kotlin.runtime.time.Instant? = builder.agreementStartDate
    /**
     * Category of the term being updated.
     */
    public val type: kotlin.String? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.marketplaceagreement.model.ValidityTerm = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ValidityTerm(")
        append("agreementDuration=$agreementDuration,")
        append("agreementEndDate=$agreementEndDate,")
        append("agreementStartDate=$agreementStartDate,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = agreementDuration?.hashCode() ?: 0
        result = 31 * result + (agreementEndDate?.hashCode() ?: 0)
        result = 31 * result + (agreementStartDate?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ValidityTerm

        if (agreementDuration != other.agreementDuration) return false
        if (agreementEndDate != other.agreementEndDate) return false
        if (agreementStartDate != other.agreementStartDate) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.marketplaceagreement.model.ValidityTerm = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Defines the duration that the agreement remains active. If `AgreementStartDate` isn’t provided, the agreement duration is relative to the agreement signature time. The duration is represented in the ISO_8601 format.
         */
        public var agreementDuration: kotlin.String? = null
        /**
         * Defines the date when the agreement ends. The agreement ends at 23:59:59.999 UTC on the date provided. If `AgreementEndDate` isn’t provided, the agreement end date is determined by the validity of individual terms.
         */
        public var agreementEndDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Defines the date when agreement starts. The agreement starts at 00:00:00.000 UTC on the date provided. If `AgreementStartDate` isn’t provided, the agreement start date is determined based on agreement signature time.
         */
        public var agreementStartDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Category of the term being updated.
         */
        public var type: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.marketplaceagreement.model.ValidityTerm) : this() {
            this.agreementDuration = x.agreementDuration
            this.agreementEndDate = x.agreementEndDate
            this.agreementStartDate = x.agreementStartDate
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.marketplaceagreement.model.ValidityTerm = ValidityTerm(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
