// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.marketplaceagreement.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Includes the list of references to legal resources proposed by the proposer to the acceptor. Each `DocumentItem` refers to an individual reference.
 */
public class DocumentItem private constructor(builder: Builder) {
    /**
     * Category of the document. Document types include:
     * + `CustomEula` – A custom EULA provided by you as seller. A URL for a EULA stored in an accessible Amazon S3 bucket is required for this document type.
     * + `CustomDsa` – A custom Data Subscription Agreement (DSA) provided by you as seller. A URL for a DSA stored in an accessible Amazon S3 bucket is required for this document type.
     * + `StandardEula` – The Standard Contract for AWS Marketplace (SCMP). For more information about SCMP, see the AWS Marketplace Seller Guide. You don’t provide a URL for this type because it’s managed by AWS Marketplace.
     * + `StandardDsa` – DSA for AWS Marketplace. For more information about the DSA, see the AWS Data Exchange User Guide. You don’t provide a URL for this type because it’s managed by AWS Marketplace.
     */
    public val type: kotlin.String? = builder.type
    /**
     * A URL to the legal document for buyers to read. Required when `Type` is `CustomEula`.
     */
    public val url: kotlin.String? = builder.url
    /**
     * Version of standard contracts provided by AWS Marketplace. Required when Type is `StandardEula` or `StandardDsa`.
     */
    public val version: kotlin.String? = builder.version

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.marketplaceagreement.model.DocumentItem = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DocumentItem(")
        append("type=$type,")
        append("url=$url,")
        append("version=$version")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = type?.hashCode() ?: 0
        result = 31 * result + (url?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DocumentItem

        if (type != other.type) return false
        if (url != other.url) return false
        if (version != other.version) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.marketplaceagreement.model.DocumentItem = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Category of the document. Document types include:
         * + `CustomEula` – A custom EULA provided by you as seller. A URL for a EULA stored in an accessible Amazon S3 bucket is required for this document type.
         * + `CustomDsa` – A custom Data Subscription Agreement (DSA) provided by you as seller. A URL for a DSA stored in an accessible Amazon S3 bucket is required for this document type.
         * + `StandardEula` – The Standard Contract for AWS Marketplace (SCMP). For more information about SCMP, see the AWS Marketplace Seller Guide. You don’t provide a URL for this type because it’s managed by AWS Marketplace.
         * + `StandardDsa` – DSA for AWS Marketplace. For more information about the DSA, see the AWS Data Exchange User Guide. You don’t provide a URL for this type because it’s managed by AWS Marketplace.
         */
        public var type: kotlin.String? = null
        /**
         * A URL to the legal document for buyers to read. Required when `Type` is `CustomEula`.
         */
        public var url: kotlin.String? = null
        /**
         * Version of standard contracts provided by AWS Marketplace. Required when Type is `StandardEula` or `StandardDsa`.
         */
        public var version: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.marketplaceagreement.model.DocumentItem) : this() {
            this.type = x.type
            this.url = x.url
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.marketplaceagreement.model.DocumentItem = DocumentItem(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
