// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.marketplaceagreement.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class DescribeAgreementResponse private constructor(builder: Builder) {
    /**
     * The date and time the offer was accepted or the agreement was created.
     *
     * `AcceptanceTime` and `StartTime` can differ for future dated agreements (FDAs).
     */
    public val acceptanceTime: aws.smithy.kotlin.runtime.time.Instant? = builder.acceptanceTime
    /**
     * The details of the party accepting the agreement terms. This is commonly the buyer for `PurchaseAgreement`.
     */
    public val acceptor: aws.sdk.kotlin.services.marketplaceagreement.model.Acceptor? = builder.acceptor
    /**
     * The unique identifier of the agreement.
     */
    public val agreementId: kotlin.String? = builder.agreementId
    /**
     * The type of agreement. Values are `PurchaseAgreement` or `VendorInsightsAgreement`.
     */
    public val agreementType: kotlin.String? = builder.agreementType
    /**
     * The date and time when the agreement ends. The field is `null` for pay-as-you-go agreements, which don’t have end dates.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * The estimated cost of the agreement.
     */
    public val estimatedCharges: aws.sdk.kotlin.services.marketplaceagreement.model.EstimatedCharges? = builder.estimatedCharges
    /**
     * A summary of the proposal received from the proposer.
     */
    public val proposalSummary: aws.sdk.kotlin.services.marketplaceagreement.model.ProposalSummary? = builder.proposalSummary
    /**
     * The details of the party proposing the agreement terms. This is commonly the seller for `PurchaseAgreement`.
     */
    public val proposer: aws.sdk.kotlin.services.marketplaceagreement.model.Proposer? = builder.proposer
    /**
     * The date and time when the agreement starts.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * The current status of the agreement.
     *
     * Statuses include:
     * + `ACTIVE` – The terms of the agreement are active.
     * + `ARCHIVED` – The agreement ended without a specified reason.
     * + `CANCELLED` – The acceptor ended the agreement before the defined end date.
     * + `EXPIRED` – The agreement ended on the defined end date.
     * + `RENEWED` – The agreement was renewed into a new agreement (for example, an auto-renewal).
     * + `REPLACED` – The agreement was replaced using an agreement replacement offer.
     * + `ROLLED_BACK` (Only applicable to inactive agreement revisions) – The agreement revision has been rolled back because of an error. An earlier revision is now active.
     * + `SUPERCEDED` (Only applicable to inactive agreement revisions) – The agreement revision is no longer active and another agreement revision is now active.
     * + `TERMINATED` – The agreement ended before the defined end date because of an AWS termination (for example, a payment failure).
     */
    public val status: aws.sdk.kotlin.services.marketplaceagreement.model.AgreementStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.marketplaceagreement.model.DescribeAgreementResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeAgreementResponse(")
        append("acceptanceTime=$acceptanceTime,")
        append("acceptor=$acceptor,")
        append("agreementId=$agreementId,")
        append("agreementType=$agreementType,")
        append("endTime=$endTime,")
        append("estimatedCharges=$estimatedCharges,")
        append("proposalSummary=$proposalSummary,")
        append("proposer=$proposer,")
        append("startTime=$startTime,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = acceptanceTime?.hashCode() ?: 0
        result = 31 * result + (acceptor?.hashCode() ?: 0)
        result = 31 * result + (agreementId?.hashCode() ?: 0)
        result = 31 * result + (agreementType?.hashCode() ?: 0)
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (estimatedCharges?.hashCode() ?: 0)
        result = 31 * result + (proposalSummary?.hashCode() ?: 0)
        result = 31 * result + (proposer?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeAgreementResponse

        if (acceptanceTime != other.acceptanceTime) return false
        if (acceptor != other.acceptor) return false
        if (agreementId != other.agreementId) return false
        if (agreementType != other.agreementType) return false
        if (endTime != other.endTime) return false
        if (estimatedCharges != other.estimatedCharges) return false
        if (proposalSummary != other.proposalSummary) return false
        if (proposer != other.proposer) return false
        if (startTime != other.startTime) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.marketplaceagreement.model.DescribeAgreementResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The date and time the offer was accepted or the agreement was created.
         *
         * `AcceptanceTime` and `StartTime` can differ for future dated agreements (FDAs).
         */
        public var acceptanceTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The details of the party accepting the agreement terms. This is commonly the buyer for `PurchaseAgreement`.
         */
        public var acceptor: aws.sdk.kotlin.services.marketplaceagreement.model.Acceptor? = null
        /**
         * The unique identifier of the agreement.
         */
        public var agreementId: kotlin.String? = null
        /**
         * The type of agreement. Values are `PurchaseAgreement` or `VendorInsightsAgreement`.
         */
        public var agreementType: kotlin.String? = null
        /**
         * The date and time when the agreement ends. The field is `null` for pay-as-you-go agreements, which don’t have end dates.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The estimated cost of the agreement.
         */
        public var estimatedCharges: aws.sdk.kotlin.services.marketplaceagreement.model.EstimatedCharges? = null
        /**
         * A summary of the proposal received from the proposer.
         */
        public var proposalSummary: aws.sdk.kotlin.services.marketplaceagreement.model.ProposalSummary? = null
        /**
         * The details of the party proposing the agreement terms. This is commonly the seller for `PurchaseAgreement`.
         */
        public var proposer: aws.sdk.kotlin.services.marketplaceagreement.model.Proposer? = null
        /**
         * The date and time when the agreement starts.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The current status of the agreement.
         *
         * Statuses include:
         * + `ACTIVE` – The terms of the agreement are active.
         * + `ARCHIVED` – The agreement ended without a specified reason.
         * + `CANCELLED` – The acceptor ended the agreement before the defined end date.
         * + `EXPIRED` – The agreement ended on the defined end date.
         * + `RENEWED` – The agreement was renewed into a new agreement (for example, an auto-renewal).
         * + `REPLACED` – The agreement was replaced using an agreement replacement offer.
         * + `ROLLED_BACK` (Only applicable to inactive agreement revisions) – The agreement revision has been rolled back because of an error. An earlier revision is now active.
         * + `SUPERCEDED` (Only applicable to inactive agreement revisions) – The agreement revision is no longer active and another agreement revision is now active.
         * + `TERMINATED` – The agreement ended before the defined end date because of an AWS termination (for example, a payment failure).
         */
        public var status: aws.sdk.kotlin.services.marketplaceagreement.model.AgreementStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.marketplaceagreement.model.DescribeAgreementResponse) : this() {
            this.acceptanceTime = x.acceptanceTime
            this.acceptor = x.acceptor
            this.agreementId = x.agreementId
            this.agreementType = x.agreementType
            this.endTime = x.endTime
            this.estimatedCharges = x.estimatedCharges
            this.proposalSummary = x.proposalSummary
            this.proposer = x.proposer
            this.startTime = x.startTime
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.marketplaceagreement.model.DescribeAgreementResponse = DescribeAgreementResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.marketplaceagreement.model.Acceptor] inside the given [block]
         */
        public fun acceptor(block: aws.sdk.kotlin.services.marketplaceagreement.model.Acceptor.Builder.() -> kotlin.Unit) {
            this.acceptor = aws.sdk.kotlin.services.marketplaceagreement.model.Acceptor.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.marketplaceagreement.model.EstimatedCharges] inside the given [block]
         */
        public fun estimatedCharges(block: aws.sdk.kotlin.services.marketplaceagreement.model.EstimatedCharges.Builder.() -> kotlin.Unit) {
            this.estimatedCharges = aws.sdk.kotlin.services.marketplaceagreement.model.EstimatedCharges.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.marketplaceagreement.model.ProposalSummary] inside the given [block]
         */
        public fun proposalSummary(block: aws.sdk.kotlin.services.marketplaceagreement.model.ProposalSummary.Builder.() -> kotlin.Unit) {
            this.proposalSummary = aws.sdk.kotlin.services.marketplaceagreement.model.ProposalSummary.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.marketplaceagreement.model.Proposer] inside the given [block]
         */
        public fun proposer(block: aws.sdk.kotlin.services.marketplaceagreement.model.Proposer.Builder.() -> kotlin.Unit) {
            this.proposer = aws.sdk.kotlin.services.marketplaceagreement.model.Proposer.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
