// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.managedblockchainquery.endpoints

import aws.smithy.kotlin.runtime.client.endpoints.Endpoint
import aws.smithy.kotlin.runtime.client.endpoints.EndpointProviderException
import aws.smithy.kotlin.runtime.net.Url
import aws.smithy.kotlin.runtime.net.UrlDecoding
import kotlin.test.*
import kotlinx.coroutines.test.runTest

public class DefaultEndpointProviderTest {
    // For region us-east-1 with FIPS enabled and DualStack enabled
    @Test
    fun test0() = runTest {
        val params = EndpointParameters {
            region = "us-east-1"
            useFips = true
            useDualStack = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://managedblockchain-query-fips.us-east-1.api.aws", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-east-1 with FIPS enabled and DualStack disabled
    @Test
    fun test1() = runTest {
        val params = EndpointParameters {
            region = "us-east-1"
            useFips = true
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://managedblockchain-query-fips.us-east-1.amazonaws.com", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-east-1 with FIPS disabled and DualStack enabled
    @Test
    fun test2() = runTest {
        val params = EndpointParameters {
            region = "us-east-1"
            useFips = false
            useDualStack = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://managedblockchain-query.us-east-1.api.aws", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-east-1 with FIPS disabled and DualStack disabled
    @Test
    fun test3() = runTest {
        val params = EndpointParameters {
            region = "us-east-1"
            useFips = false
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://managedblockchain-query.us-east-1.amazonaws.com", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region cn-north-1 with FIPS enabled and DualStack enabled
    @Test
    fun test4() = runTest {
        val params = EndpointParameters {
            region = "cn-north-1"
            useFips = true
            useDualStack = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://managedblockchain-query-fips.cn-north-1.api.amazonwebservices.com.cn", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region cn-north-1 with FIPS enabled and DualStack disabled
    @Test
    fun test5() = runTest {
        val params = EndpointParameters {
            region = "cn-north-1"
            useFips = true
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://managedblockchain-query-fips.cn-north-1.amazonaws.com.cn", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region cn-north-1 with FIPS disabled and DualStack enabled
    @Test
    fun test6() = runTest {
        val params = EndpointParameters {
            region = "cn-north-1"
            useFips = false
            useDualStack = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://managedblockchain-query.cn-north-1.api.amazonwebservices.com.cn", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region cn-north-1 with FIPS disabled and DualStack disabled
    @Test
    fun test7() = runTest {
        val params = EndpointParameters {
            region = "cn-north-1"
            useFips = false
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://managedblockchain-query.cn-north-1.amazonaws.com.cn", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-gov-east-1 with FIPS enabled and DualStack enabled
    @Test
    fun test8() = runTest {
        val params = EndpointParameters {
            region = "us-gov-east-1"
            useFips = true
            useDualStack = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://managedblockchain-query-fips.us-gov-east-1.api.aws", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-gov-east-1 with FIPS enabled and DualStack disabled
    @Test
    fun test9() = runTest {
        val params = EndpointParameters {
            region = "us-gov-east-1"
            useFips = true
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://managedblockchain-query-fips.us-gov-east-1.amazonaws.com", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-gov-east-1 with FIPS disabled and DualStack enabled
    @Test
    fun test10() = runTest {
        val params = EndpointParameters {
            region = "us-gov-east-1"
            useFips = false
            useDualStack = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://managedblockchain-query.us-gov-east-1.api.aws", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-gov-east-1 with FIPS disabled and DualStack disabled
    @Test
    fun test11() = runTest {
        val params = EndpointParameters {
            region = "us-gov-east-1"
            useFips = false
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://managedblockchain-query.us-gov-east-1.amazonaws.com", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-iso-east-1 with FIPS enabled and DualStack enabled
    @Test
    fun test12() = runTest {
        val params = EndpointParameters {
            region = "us-iso-east-1"
            useFips = true
            useDualStack = true
        }
        val ex = assertFailsWith<EndpointProviderException> {
            DefaultEndpointProvider().resolveEndpoint(params)
        }
        assertEquals("FIPS and DualStack are enabled, but this partition does not support one or both", ex.message)
    }

    // For region us-iso-east-1 with FIPS enabled and DualStack disabled
    @Test
    fun test13() = runTest {
        val params = EndpointParameters {
            region = "us-iso-east-1"
            useFips = true
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://managedblockchain-query-fips.us-iso-east-1.c2s.ic.gov", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-iso-east-1 with FIPS disabled and DualStack enabled
    @Test
    fun test14() = runTest {
        val params = EndpointParameters {
            region = "us-iso-east-1"
            useFips = false
            useDualStack = true
        }
        val ex = assertFailsWith<EndpointProviderException> {
            DefaultEndpointProvider().resolveEndpoint(params)
        }
        assertEquals("DualStack is enabled but this partition does not support DualStack", ex.message)
    }

    // For region us-iso-east-1 with FIPS disabled and DualStack disabled
    @Test
    fun test15() = runTest {
        val params = EndpointParameters {
            region = "us-iso-east-1"
            useFips = false
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://managedblockchain-query.us-iso-east-1.c2s.ic.gov", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-isob-east-1 with FIPS enabled and DualStack enabled
    @Test
    fun test16() = runTest {
        val params = EndpointParameters {
            region = "us-isob-east-1"
            useFips = true
            useDualStack = true
        }
        val ex = assertFailsWith<EndpointProviderException> {
            DefaultEndpointProvider().resolveEndpoint(params)
        }
        assertEquals("FIPS and DualStack are enabled, but this partition does not support one or both", ex.message)
    }

    // For region us-isob-east-1 with FIPS enabled and DualStack disabled
    @Test
    fun test17() = runTest {
        val params = EndpointParameters {
            region = "us-isob-east-1"
            useFips = true
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://managedblockchain-query-fips.us-isob-east-1.sc2s.sgov.gov", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-isob-east-1 with FIPS disabled and DualStack enabled
    @Test
    fun test18() = runTest {
        val params = EndpointParameters {
            region = "us-isob-east-1"
            useFips = false
            useDualStack = true
        }
        val ex = assertFailsWith<EndpointProviderException> {
            DefaultEndpointProvider().resolveEndpoint(params)
        }
        assertEquals("DualStack is enabled but this partition does not support DualStack", ex.message)
    }

    // For region us-isob-east-1 with FIPS disabled and DualStack disabled
    @Test
    fun test19() = runTest {
        val params = EndpointParameters {
            region = "us-isob-east-1"
            useFips = false
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://managedblockchain-query.us-isob-east-1.sc2s.sgov.gov", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For custom endpoint with region set and fips disabled and dualstack disabled
    @Test
    fun test20() = runTest {
        val params = EndpointParameters {
            region = "us-east-1"
            useFips = false
            useDualStack = false
            endpoint = "https://example.com"
        }
        val expected = Endpoint(
            uri = Url.parse("https://example.com", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For custom endpoint with region not set and fips disabled and dualstack disabled
    @Test
    fun test21() = runTest {
        val params = EndpointParameters {
            useFips = false
            useDualStack = false
            endpoint = "https://example.com"
        }
        val expected = Endpoint(
            uri = Url.parse("https://example.com", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For custom endpoint with fips enabled and dualstack disabled
    @Test
    fun test22() = runTest {
        val params = EndpointParameters {
            region = "us-east-1"
            useFips = true
            useDualStack = false
            endpoint = "https://example.com"
        }
        val ex = assertFailsWith<EndpointProviderException> {
            DefaultEndpointProvider().resolveEndpoint(params)
        }
        assertEquals("Invalid Configuration: FIPS and custom endpoint are not supported", ex.message)
    }

    // For custom endpoint with fips disabled and dualstack enabled
    @Test
    fun test23() = runTest {
        val params = EndpointParameters {
            region = "us-east-1"
            useFips = false
            useDualStack = true
            endpoint = "https://example.com"
        }
        val ex = assertFailsWith<EndpointProviderException> {
            DefaultEndpointProvider().resolveEndpoint(params)
        }
        assertEquals("Invalid Configuration: Dualstack and custom endpoint are not supported", ex.message)
    }

    // Missing region
    @Test
    fun test24() = runTest {
        val params = EndpointParameters {
        }
        val ex = assertFailsWith<EndpointProviderException> {
            DefaultEndpointProvider().resolveEndpoint(params)
        }
        assertEquals("Invalid Configuration: Missing Region", ex.message)
    }

}
