// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.managedblockchainquery.transform

import aws.sdk.kotlin.services.managedblockchainquery.model.BlockchainInstant
import aws.sdk.kotlin.services.managedblockchainquery.model.GetTokenBalanceResponse
import aws.sdk.kotlin.services.managedblockchainquery.model.ManagedBlockchainQueryException
import aws.sdk.kotlin.services.managedblockchainquery.model.OwnerIdentifier
import aws.sdk.kotlin.services.managedblockchainquery.model.TokenIdentifier
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetTokenBalanceOperationDeserializer: HttpDeserialize<GetTokenBalanceResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetTokenBalanceResponse {
        if (!response.status.isSuccess()) {
            throwGetTokenBalanceError(context, response)
        }
        val builder = GetTokenBalanceResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetTokenBalanceOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetTokenBalanceError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ManagedBlockchainQueryException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceQuotaExceededException" -> ServiceQuotaExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ManagedBlockchainQueryException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetTokenBalanceOperationBody(builder: GetTokenBalanceResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ATBLOCKCHAININSTANT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("atBlockchainInstant"))
    val BALANCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("balance"))
    val LASTUPDATEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("lastUpdatedTime"))
    val OWNERIDENTIFIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ownerIdentifier"))
    val TOKENIDENTIFIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("tokenIdentifier"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ATBLOCKCHAININSTANT_DESCRIPTOR)
        field(BALANCE_DESCRIPTOR)
        field(LASTUPDATEDTIME_DESCRIPTOR)
        field(OWNERIDENTIFIER_DESCRIPTOR)
        field(TOKENIDENTIFIER_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ATBLOCKCHAININSTANT_DESCRIPTOR.index -> builder.atBlockchainInstant = deserializeBlockchainInstantDocument(deserializer)
                BALANCE_DESCRIPTOR.index -> builder.balance = deserializeString()
                LASTUPDATEDTIME_DESCRIPTOR.index -> builder.lastUpdatedTime = deserializeBlockchainInstantDocument(deserializer)
                OWNERIDENTIFIER_DESCRIPTOR.index -> builder.ownerIdentifier = deserializeOwnerIdentifierDocument(deserializer)
                TOKENIDENTIFIER_DESCRIPTOR.index -> builder.tokenIdentifier = deserializeTokenIdentifierDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
