// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.managedblockchainquery.transform

import aws.sdk.kotlin.services.managedblockchainquery.model.BatchGetTokenBalanceErrorItem
import aws.sdk.kotlin.services.managedblockchainquery.model.BatchGetTokenBalanceOutputItem
import aws.sdk.kotlin.services.managedblockchainquery.model.BatchGetTokenBalanceResponse
import aws.sdk.kotlin.services.managedblockchainquery.model.ManagedBlockchainQueryException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class BatchGetTokenBalanceOperationDeserializer: HttpDeserialize<BatchGetTokenBalanceResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): BatchGetTokenBalanceResponse {
        if (!response.status.isSuccess()) {
            throwBatchGetTokenBalanceError(context, response)
        }
        val builder = BatchGetTokenBalanceResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeBatchGetTokenBalanceOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwBatchGetTokenBalanceError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ManagedBlockchainQueryException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceQuotaExceededException" -> ServiceQuotaExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ManagedBlockchainQueryException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeBatchGetTokenBalanceOperationBody(builder: BatchGetTokenBalanceResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ERRORS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("errors"))
    val TOKENBALANCES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("tokenBalances"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ERRORS_DESCRIPTOR)
        field(TOKENBALANCES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ERRORS_DESCRIPTOR.index -> builder.errors =
                    deserializer.deserializeList(ERRORS_DESCRIPTOR) {
                        val col0 = mutableListOf<BatchGetTokenBalanceErrorItem>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeBatchGetTokenBalanceErrorItemDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                TOKENBALANCES_DESCRIPTOR.index -> builder.tokenBalances =
                    deserializer.deserializeList(TOKENBALANCES_DESCRIPTOR) {
                        val col0 = mutableListOf<BatchGetTokenBalanceOutputItem>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeBatchGetTokenBalanceOutputItemDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
