// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.managedblockchainquery.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * There are two possible types of transactions used for this data type:
 * + A Bitcoin transaction is a movement of BTC from one address to another.
 * + An Ethereum transaction refers to an action initiated by an externally owned account, which is an account managed by a human, not a contract. For example, if Bob sends Alice 1 ETH, Bob's account must be debited and Alice's must be credited. This state-changing action occurs within a transaction.
 */
public class Transaction private constructor(builder: Builder) {
    /**
     * The block hash is a unique identifier for a block. It is a fixed-size string that is calculated by using the information in the block. The block hash is used to verify the integrity of the data in the block.
     */
    public val blockHash: kotlin.String? = builder.blockHash
    /**
     * The block number in which the transaction is recorded.
     */
    public val blockNumber: kotlin.String? = builder.blockNumber
    /**
     * The blockchain address for the contract.
     */
    public val contractAddress: kotlin.String? = builder.contractAddress
    /**
     * The amount of gas used up to the specified point in the block.
     */
    public val cumulativeGasUsed: kotlin.String? = builder.cumulativeGasUsed
    /**
     * The effective gas price.
     */
    public val effectiveGasPrice: kotlin.String? = builder.effectiveGasPrice
    /**
     * The initiator of the transaction. It is either in the form a public key or a contract address.
     */
    public val from: kotlin.String? = builder.from
    /**
     * The amount of gas used for the transaction.
     */
    public val gasUsed: kotlin.String? = builder.gasUsed
    /**
     * The blockchain network where the transaction occured.
     */
    public val network: aws.sdk.kotlin.services.managedblockchainquery.model.QueryNetwork? = builder.network
    /**
     * The number of transactions in the block.
     */
    public val numberOfTransactions: kotlin.Long? = builder.numberOfTransactions
    /**
     * The signature of the transaction. The X coordinate of a point R.
     */
    public val signaturer: kotlin.String? = builder.signaturer
    /**
     * The signature of the transaction. The Y coordinate of a point S.
     */
    public val signatures: kotlin.String? = builder.signatures
    /**
     * The signature of the transaction. The Z coordinate of a point V.
     */
    public val signaturev: kotlin.Int? = builder.signaturev
    /**
     * The status of the transaction.
     */
    public val status: aws.sdk.kotlin.services.managedblockchainquery.model.QueryTransactionStatus? = builder.status
    /**
     * The identifier of the transaction. It is generated whenever a transaction is verified and added to the blockchain.
     */
    public val to: kotlin.String? = builder.to
    /**
     * The transaction fee.
     */
    public val transactionFee: kotlin.String? = builder.transactionFee
    /**
     * The hash of the transaction. It is generated whenever a transaction is verified and added to the blockchain.
     */
    public val transactionHash: kotlin.String? = builder.transactionHash
    /**
     * The unique identifier of the transaction. It is generated whenever a transaction is verified and added to the blockchain.
     */
    public val transactionId: kotlin.String? = builder.transactionId
    /**
     * The index of the transaction within a blockchain.
     */
    public val transactionIndex: kotlin.Long? = builder.transactionIndex
    /**
     * The `Timestamp` of the transaction.
     */
    public val transactionTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.transactionTimestamp

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.managedblockchainquery.model.Transaction = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Transaction(")
        append("blockHash=$blockHash,")
        append("blockNumber=$blockNumber,")
        append("contractAddress=$contractAddress,")
        append("cumulativeGasUsed=$cumulativeGasUsed,")
        append("effectiveGasPrice=$effectiveGasPrice,")
        append("from=$from,")
        append("gasUsed=$gasUsed,")
        append("network=$network,")
        append("numberOfTransactions=$numberOfTransactions,")
        append("signaturer=$signaturer,")
        append("signatures=$signatures,")
        append("signaturev=$signaturev,")
        append("status=$status,")
        append("to=$to,")
        append("transactionFee=$transactionFee,")
        append("transactionHash=$transactionHash,")
        append("transactionId=$transactionId,")
        append("transactionIndex=$transactionIndex,")
        append("transactionTimestamp=$transactionTimestamp")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = blockHash?.hashCode() ?: 0
        result = 31 * result + (blockNumber?.hashCode() ?: 0)
        result = 31 * result + (contractAddress?.hashCode() ?: 0)
        result = 31 * result + (cumulativeGasUsed?.hashCode() ?: 0)
        result = 31 * result + (effectiveGasPrice?.hashCode() ?: 0)
        result = 31 * result + (from?.hashCode() ?: 0)
        result = 31 * result + (gasUsed?.hashCode() ?: 0)
        result = 31 * result + (network?.hashCode() ?: 0)
        result = 31 * result + (numberOfTransactions?.hashCode() ?: 0)
        result = 31 * result + (signaturer?.hashCode() ?: 0)
        result = 31 * result + (signatures?.hashCode() ?: 0)
        result = 31 * result + (signaturev ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (to?.hashCode() ?: 0)
        result = 31 * result + (transactionFee?.hashCode() ?: 0)
        result = 31 * result + (transactionHash?.hashCode() ?: 0)
        result = 31 * result + (transactionId?.hashCode() ?: 0)
        result = 31 * result + (transactionIndex?.hashCode() ?: 0)
        result = 31 * result + (transactionTimestamp?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Transaction

        if (blockHash != other.blockHash) return false
        if (blockNumber != other.blockNumber) return false
        if (contractAddress != other.contractAddress) return false
        if (cumulativeGasUsed != other.cumulativeGasUsed) return false
        if (effectiveGasPrice != other.effectiveGasPrice) return false
        if (from != other.from) return false
        if (gasUsed != other.gasUsed) return false
        if (network != other.network) return false
        if (numberOfTransactions != other.numberOfTransactions) return false
        if (signaturer != other.signaturer) return false
        if (signatures != other.signatures) return false
        if (signaturev != other.signaturev) return false
        if (status != other.status) return false
        if (to != other.to) return false
        if (transactionFee != other.transactionFee) return false
        if (transactionHash != other.transactionHash) return false
        if (transactionId != other.transactionId) return false
        if (transactionIndex != other.transactionIndex) return false
        if (transactionTimestamp != other.transactionTimestamp) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.managedblockchainquery.model.Transaction = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The block hash is a unique identifier for a block. It is a fixed-size string that is calculated by using the information in the block. The block hash is used to verify the integrity of the data in the block.
         */
        public var blockHash: kotlin.String? = null
        /**
         * The block number in which the transaction is recorded.
         */
        public var blockNumber: kotlin.String? = null
        /**
         * The blockchain address for the contract.
         */
        public var contractAddress: kotlin.String? = null
        /**
         * The amount of gas used up to the specified point in the block.
         */
        public var cumulativeGasUsed: kotlin.String? = null
        /**
         * The effective gas price.
         */
        public var effectiveGasPrice: kotlin.String? = null
        /**
         * The initiator of the transaction. It is either in the form a public key or a contract address.
         */
        public var from: kotlin.String? = null
        /**
         * The amount of gas used for the transaction.
         */
        public var gasUsed: kotlin.String? = null
        /**
         * The blockchain network where the transaction occured.
         */
        public var network: aws.sdk.kotlin.services.managedblockchainquery.model.QueryNetwork? = null
        /**
         * The number of transactions in the block.
         */
        public var numberOfTransactions: kotlin.Long? = null
        /**
         * The signature of the transaction. The X coordinate of a point R.
         */
        public var signaturer: kotlin.String? = null
        /**
         * The signature of the transaction. The Y coordinate of a point S.
         */
        public var signatures: kotlin.String? = null
        /**
         * The signature of the transaction. The Z coordinate of a point V.
         */
        public var signaturev: kotlin.Int? = null
        /**
         * The status of the transaction.
         */
        public var status: aws.sdk.kotlin.services.managedblockchainquery.model.QueryTransactionStatus? = null
        /**
         * The identifier of the transaction. It is generated whenever a transaction is verified and added to the blockchain.
         */
        public var to: kotlin.String? = null
        /**
         * The transaction fee.
         */
        public var transactionFee: kotlin.String? = null
        /**
         * The hash of the transaction. It is generated whenever a transaction is verified and added to the blockchain.
         */
        public var transactionHash: kotlin.String? = null
        /**
         * The unique identifier of the transaction. It is generated whenever a transaction is verified and added to the blockchain.
         */
        public var transactionId: kotlin.String? = null
        /**
         * The index of the transaction within a blockchain.
         */
        public var transactionIndex: kotlin.Long? = null
        /**
         * The `Timestamp` of the transaction.
         */
        public var transactionTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.managedblockchainquery.model.Transaction) : this() {
            this.blockHash = x.blockHash
            this.blockNumber = x.blockNumber
            this.contractAddress = x.contractAddress
            this.cumulativeGasUsed = x.cumulativeGasUsed
            this.effectiveGasPrice = x.effectiveGasPrice
            this.from = x.from
            this.gasUsed = x.gasUsed
            this.network = x.network
            this.numberOfTransactions = x.numberOfTransactions
            this.signaturer = x.signaturer
            this.signatures = x.signatures
            this.signaturev = x.signaturev
            this.status = x.status
            this.to = x.to
            this.transactionFee = x.transactionFee
            this.transactionHash = x.transactionHash
            this.transactionId = x.transactionId
            this.transactionIndex = x.transactionIndex
            this.transactionTimestamp = x.transactionTimestamp
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.managedblockchainquery.model.Transaction = Transaction(this)
    }
}
