// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.managedblockchainquery.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The container for the properties of a transaction event.
 */
public class TransactionEvent private constructor(builder: Builder) {
    /**
     * The container for time.
     */
    public val blockchainInstant: aws.sdk.kotlin.services.managedblockchainquery.model.BlockchainInstant? = builder.blockchainInstant
    /**
     * This container specifies whether the transaction has reached Finality.
     */
    public val confirmationStatus: aws.sdk.kotlin.services.managedblockchainquery.model.ConfirmationStatus? = builder.confirmationStatus
    /**
     * The blockchain address for the contract
     */
    public val contractAddress: kotlin.String? = builder.contractAddress
    /**
     * The type of transaction event.
     */
    public val eventType: aws.sdk.kotlin.services.managedblockchainquery.model.QueryTransactionEventType = requireNotNull(builder.eventType) { "A non-null value must be provided for eventType" }
    /**
     * The wallet address initiating the transaction. It can either be a public key or a contract.
     */
    public val from: kotlin.String? = builder.from
    /**
     * The blockchain network where the transaction occurred.
     */
    public val network: aws.sdk.kotlin.services.managedblockchainquery.model.QueryNetwork = requireNotNull(builder.network) { "A non-null value must be provided for network" }
    /**
     * The position of the spent transaction output in the output list of the *creating transaction*.
     *
     * This is only returned for `BITCOIN_VIN` event types.
     */
    public val spentVoutIndex: kotlin.Int? = builder.spentVoutIndex
    /**
     * The transactionHash that *created* the spent transaction output.
     *
     * This is only returned for `BITCOIN_VIN` event types.
     */
    public val spentVoutTransactionHash: kotlin.String? = builder.spentVoutTransactionHash
    /**
     * The transactionId that *created* the spent transaction output.
     *
     * This is only returned for `BITCOIN_VIN` event types.
     */
    public val spentVoutTransactionId: kotlin.String? = builder.spentVoutTransactionId
    /**
     * The wallet address receiving the transaction. It can either be a public key or a contract.
     */
    public val to: kotlin.String? = builder.to
    /**
     * The unique identifier for the token involved in the transaction.
     */
    public val tokenId: kotlin.String? = builder.tokenId
    /**
     * The hash of a transaction. It is generated when a transaction is created.
     */
    public val transactionHash: kotlin.String = requireNotNull(builder.transactionHash) { "A non-null value must be provided for transactionHash" }
    /**
     * The identifier of a Bitcoin transaction. It is generated when a transaction is created.
     */
    public val transactionId: kotlin.String? = builder.transactionId
    /**
     * The value that was transacted.
     */
    public val value: kotlin.String? = builder.value
    /**
     * The position of the transaction output in the transaction output list.
     */
    public val voutIndex: kotlin.Int? = builder.voutIndex
    /**
     * Specifies if the transaction output is spent or unspent. This is only returned for BITCOIN_VOUT event types.
     *
     * This is only returned for `BITCOIN_VOUT` event types.
     */
    public val voutSpent: kotlin.Boolean? = builder.voutSpent

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.managedblockchainquery.model.TransactionEvent = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TransactionEvent(")
        append("blockchainInstant=$blockchainInstant,")
        append("confirmationStatus=$confirmationStatus,")
        append("contractAddress=$contractAddress,")
        append("eventType=$eventType,")
        append("from=$from,")
        append("network=$network,")
        append("spentVoutIndex=$spentVoutIndex,")
        append("spentVoutTransactionHash=$spentVoutTransactionHash,")
        append("spentVoutTransactionId=$spentVoutTransactionId,")
        append("to=$to,")
        append("tokenId=$tokenId,")
        append("transactionHash=$transactionHash,")
        append("transactionId=$transactionId,")
        append("value=$value,")
        append("voutIndex=$voutIndex,")
        append("voutSpent=$voutSpent")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = blockchainInstant?.hashCode() ?: 0
        result = 31 * result + (confirmationStatus?.hashCode() ?: 0)
        result = 31 * result + (contractAddress?.hashCode() ?: 0)
        result = 31 * result + (eventType.hashCode())
        result = 31 * result + (from?.hashCode() ?: 0)
        result = 31 * result + (network.hashCode())
        result = 31 * result + (spentVoutIndex ?: 0)
        result = 31 * result + (spentVoutTransactionHash?.hashCode() ?: 0)
        result = 31 * result + (spentVoutTransactionId?.hashCode() ?: 0)
        result = 31 * result + (to?.hashCode() ?: 0)
        result = 31 * result + (tokenId?.hashCode() ?: 0)
        result = 31 * result + (transactionHash.hashCode())
        result = 31 * result + (transactionId?.hashCode() ?: 0)
        result = 31 * result + (value?.hashCode() ?: 0)
        result = 31 * result + (voutIndex ?: 0)
        result = 31 * result + (voutSpent?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TransactionEvent

        if (blockchainInstant != other.blockchainInstant) return false
        if (confirmationStatus != other.confirmationStatus) return false
        if (contractAddress != other.contractAddress) return false
        if (eventType != other.eventType) return false
        if (from != other.from) return false
        if (network != other.network) return false
        if (spentVoutIndex != other.spentVoutIndex) return false
        if (spentVoutTransactionHash != other.spentVoutTransactionHash) return false
        if (spentVoutTransactionId != other.spentVoutTransactionId) return false
        if (to != other.to) return false
        if (tokenId != other.tokenId) return false
        if (transactionHash != other.transactionHash) return false
        if (transactionId != other.transactionId) return false
        if (value != other.value) return false
        if (voutIndex != other.voutIndex) return false
        if (voutSpent != other.voutSpent) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.managedblockchainquery.model.TransactionEvent = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The container for time.
         */
        public var blockchainInstant: aws.sdk.kotlin.services.managedblockchainquery.model.BlockchainInstant? = null
        /**
         * This container specifies whether the transaction has reached Finality.
         */
        public var confirmationStatus: aws.sdk.kotlin.services.managedblockchainquery.model.ConfirmationStatus? = null
        /**
         * The blockchain address for the contract
         */
        public var contractAddress: kotlin.String? = null
        /**
         * The type of transaction event.
         */
        public var eventType: aws.sdk.kotlin.services.managedblockchainquery.model.QueryTransactionEventType? = null
        /**
         * The wallet address initiating the transaction. It can either be a public key or a contract.
         */
        public var from: kotlin.String? = null
        /**
         * The blockchain network where the transaction occurred.
         */
        public var network: aws.sdk.kotlin.services.managedblockchainquery.model.QueryNetwork? = null
        /**
         * The position of the spent transaction output in the output list of the *creating transaction*.
         *
         * This is only returned for `BITCOIN_VIN` event types.
         */
        public var spentVoutIndex: kotlin.Int? = null
        /**
         * The transactionHash that *created* the spent transaction output.
         *
         * This is only returned for `BITCOIN_VIN` event types.
         */
        public var spentVoutTransactionHash: kotlin.String? = null
        /**
         * The transactionId that *created* the spent transaction output.
         *
         * This is only returned for `BITCOIN_VIN` event types.
         */
        public var spentVoutTransactionId: kotlin.String? = null
        /**
         * The wallet address receiving the transaction. It can either be a public key or a contract.
         */
        public var to: kotlin.String? = null
        /**
         * The unique identifier for the token involved in the transaction.
         */
        public var tokenId: kotlin.String? = null
        /**
         * The hash of a transaction. It is generated when a transaction is created.
         */
        public var transactionHash: kotlin.String? = null
        /**
         * The identifier of a Bitcoin transaction. It is generated when a transaction is created.
         */
        public var transactionId: kotlin.String? = null
        /**
         * The value that was transacted.
         */
        public var value: kotlin.String? = null
        /**
         * The position of the transaction output in the transaction output list.
         */
        public var voutIndex: kotlin.Int? = null
        /**
         * Specifies if the transaction output is spent or unspent. This is only returned for BITCOIN_VOUT event types.
         *
         * This is only returned for `BITCOIN_VOUT` event types.
         */
        public var voutSpent: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.managedblockchainquery.model.TransactionEvent) : this() {
            this.blockchainInstant = x.blockchainInstant
            this.confirmationStatus = x.confirmationStatus
            this.contractAddress = x.contractAddress
            this.eventType = x.eventType
            this.from = x.from
            this.network = x.network
            this.spentVoutIndex = x.spentVoutIndex
            this.spentVoutTransactionHash = x.spentVoutTransactionHash
            this.spentVoutTransactionId = x.spentVoutTransactionId
            this.to = x.to
            this.tokenId = x.tokenId
            this.transactionHash = x.transactionHash
            this.transactionId = x.transactionId
            this.value = x.value
            this.voutIndex = x.voutIndex
            this.voutSpent = x.voutSpent
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.managedblockchainquery.model.TransactionEvent = TransactionEvent(this)

        /**
         * construct an [aws.sdk.kotlin.services.managedblockchainquery.model.BlockchainInstant] inside the given [block]
         */
        public fun blockchainInstant(block: aws.sdk.kotlin.services.managedblockchainquery.model.BlockchainInstant.Builder.() -> kotlin.Unit) {
            this.blockchainInstant = aws.sdk.kotlin.services.managedblockchainquery.model.BlockchainInstant.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (eventType == null) eventType = QueryTransactionEventType.SdkUnknown("no value provided")
            if (network == null) network = QueryNetwork.SdkUnknown("no value provided")
            if (transactionHash == null) transactionHash = ""
            return this
        }
    }
}
