// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.managedblockchainquery.model

import aws.smithy.kotlin.runtime.SdkDsl

public class ListFilteredTransactionEventsRequest private constructor(builder: Builder) {
    /**
     * This is the unique public address on the blockchain for which the transaction events are being requested.
     */
    public val addressIdentifierFilter: aws.sdk.kotlin.services.managedblockchainquery.model.AddressIdentifierFilter? = builder.addressIdentifierFilter
    /**
     * The container for the `ConfirmationStatusFilter` that filters for the *finality*[](https://docs.aws.amazon.com/managed-blockchain/latest/ambq-dg/key-concepts.html#finality) of the results.
     */
    public val confirmationStatusFilter: aws.sdk.kotlin.services.managedblockchainquery.model.ConfirmationStatusFilter? = builder.confirmationStatusFilter
    /**
     * The maximum number of transaction events to list.
     *
     * Default: `100`
     *
     * Even if additional results can be retrieved, the request can return less results than `maxResults` or an empty array of results.
     *
     * To retrieve the next set of results, make another request with the returned `nextToken` value. The value of `nextToken` is `null` when there are no more results to return
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The blockchain network where the transaction occurred.
     *
     * Valid Values: `BITCOIN_MAINNET` | `BITCOIN_TESTNET`
     */
    public val network: kotlin.String? = builder.network
    /**
     * The pagination token that indicates the next set of results to retrieve.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The order by which the results will be sorted.
     */
    public val sort: aws.sdk.kotlin.services.managedblockchainquery.model.ListFilteredTransactionEventsSort? = builder.sort
    /**
     * This container specifies the time frame for the transaction events returned in the response.
     */
    public val timeFilter: aws.sdk.kotlin.services.managedblockchainquery.model.TimeFilter? = builder.timeFilter
    /**
     * This container specifies filtering attributes related to BITCOIN_VOUT event types
     */
    public val voutFilter: aws.sdk.kotlin.services.managedblockchainquery.model.VoutFilter? = builder.voutFilter

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.managedblockchainquery.model.ListFilteredTransactionEventsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListFilteredTransactionEventsRequest(")
        append("addressIdentifierFilter=$addressIdentifierFilter,")
        append("confirmationStatusFilter=$confirmationStatusFilter,")
        append("maxResults=$maxResults,")
        append("network=$network,")
        append("nextToken=$nextToken,")
        append("sort=$sort,")
        append("timeFilter=$timeFilter,")
        append("voutFilter=$voutFilter")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = addressIdentifierFilter?.hashCode() ?: 0
        result = 31 * result + (confirmationStatusFilter?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (network?.hashCode() ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (sort?.hashCode() ?: 0)
        result = 31 * result + (timeFilter?.hashCode() ?: 0)
        result = 31 * result + (voutFilter?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListFilteredTransactionEventsRequest

        if (addressIdentifierFilter != other.addressIdentifierFilter) return false
        if (confirmationStatusFilter != other.confirmationStatusFilter) return false
        if (maxResults != other.maxResults) return false
        if (network != other.network) return false
        if (nextToken != other.nextToken) return false
        if (sort != other.sort) return false
        if (timeFilter != other.timeFilter) return false
        if (voutFilter != other.voutFilter) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.managedblockchainquery.model.ListFilteredTransactionEventsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * This is the unique public address on the blockchain for which the transaction events are being requested.
         */
        public var addressIdentifierFilter: aws.sdk.kotlin.services.managedblockchainquery.model.AddressIdentifierFilter? = null
        /**
         * The container for the `ConfirmationStatusFilter` that filters for the *finality*[](https://docs.aws.amazon.com/managed-blockchain/latest/ambq-dg/key-concepts.html#finality) of the results.
         */
        public var confirmationStatusFilter: aws.sdk.kotlin.services.managedblockchainquery.model.ConfirmationStatusFilter? = null
        /**
         * The maximum number of transaction events to list.
         *
         * Default: `100`
         *
         * Even if additional results can be retrieved, the request can return less results than `maxResults` or an empty array of results.
         *
         * To retrieve the next set of results, make another request with the returned `nextToken` value. The value of `nextToken` is `null` when there are no more results to return
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The blockchain network where the transaction occurred.
         *
         * Valid Values: `BITCOIN_MAINNET` | `BITCOIN_TESTNET`
         */
        public var network: kotlin.String? = null
        /**
         * The pagination token that indicates the next set of results to retrieve.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The order by which the results will be sorted.
         */
        public var sort: aws.sdk.kotlin.services.managedblockchainquery.model.ListFilteredTransactionEventsSort? = null
        /**
         * This container specifies the time frame for the transaction events returned in the response.
         */
        public var timeFilter: aws.sdk.kotlin.services.managedblockchainquery.model.TimeFilter? = null
        /**
         * This container specifies filtering attributes related to BITCOIN_VOUT event types
         */
        public var voutFilter: aws.sdk.kotlin.services.managedblockchainquery.model.VoutFilter? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.managedblockchainquery.model.ListFilteredTransactionEventsRequest) : this() {
            this.addressIdentifierFilter = x.addressIdentifierFilter
            this.confirmationStatusFilter = x.confirmationStatusFilter
            this.maxResults = x.maxResults
            this.network = x.network
            this.nextToken = x.nextToken
            this.sort = x.sort
            this.timeFilter = x.timeFilter
            this.voutFilter = x.voutFilter
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.managedblockchainquery.model.ListFilteredTransactionEventsRequest = ListFilteredTransactionEventsRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.managedblockchainquery.model.AddressIdentifierFilter] inside the given [block]
         */
        public fun addressIdentifierFilter(block: aws.sdk.kotlin.services.managedblockchainquery.model.AddressIdentifierFilter.Builder.() -> kotlin.Unit) {
            this.addressIdentifierFilter = aws.sdk.kotlin.services.managedblockchainquery.model.AddressIdentifierFilter.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.managedblockchainquery.model.ConfirmationStatusFilter] inside the given [block]
         */
        public fun confirmationStatusFilter(block: aws.sdk.kotlin.services.managedblockchainquery.model.ConfirmationStatusFilter.Builder.() -> kotlin.Unit) {
            this.confirmationStatusFilter = aws.sdk.kotlin.services.managedblockchainquery.model.ConfirmationStatusFilter.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.managedblockchainquery.model.ListFilteredTransactionEventsSort] inside the given [block]
         */
        public fun sort(block: aws.sdk.kotlin.services.managedblockchainquery.model.ListFilteredTransactionEventsSort.Builder.() -> kotlin.Unit) {
            this.sort = aws.sdk.kotlin.services.managedblockchainquery.model.ListFilteredTransactionEventsSort.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.managedblockchainquery.model.TimeFilter] inside the given [block]
         */
        public fun timeFilter(block: aws.sdk.kotlin.services.managedblockchainquery.model.TimeFilter.Builder.() -> kotlin.Unit) {
            this.timeFilter = aws.sdk.kotlin.services.managedblockchainquery.model.TimeFilter.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.managedblockchainquery.model.VoutFilter] inside the given [block]
         */
        public fun voutFilter(block: aws.sdk.kotlin.services.managedblockchainquery.model.VoutFilter.Builder.() -> kotlin.Unit) {
            this.voutFilter = aws.sdk.kotlin.services.managedblockchainquery.model.VoutFilter.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
