// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.managedblockchainquery.serde

import aws.sdk.kotlin.services.managedblockchainquery.model.BlockchainInstant
import aws.sdk.kotlin.services.managedblockchainquery.model.GetTokenBalanceResponse
import aws.sdk.kotlin.services.managedblockchainquery.model.ManagedBlockchainQueryException
import aws.sdk.kotlin.services.managedblockchainquery.model.OwnerIdentifier
import aws.sdk.kotlin.services.managedblockchainquery.model.TokenIdentifier
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetTokenBalanceOperationDeserializer: HttpDeserializer.NonStreaming<GetTokenBalanceResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetTokenBalanceResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetTokenBalanceError(context, call, payload)
        }
        val builder = GetTokenBalanceResponse.Builder()

        if (payload != null) {
            deserializeGetTokenBalanceOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetTokenBalanceError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ManagedBlockchainQueryException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceQuotaExceededException" -> ServiceQuotaExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> ManagedBlockchainQueryException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetTokenBalanceOperationBody(builder: GetTokenBalanceResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ATBLOCKCHAININSTANT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("atBlockchainInstant"))
    val BALANCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("balance"))
    val LASTUPDATEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("lastUpdatedTime"))
    val OWNERIDENTIFIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ownerIdentifier"))
    val TOKENIDENTIFIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("tokenIdentifier"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ATBLOCKCHAININSTANT_DESCRIPTOR)
        field(BALANCE_DESCRIPTOR)
        field(LASTUPDATEDTIME_DESCRIPTOR)
        field(OWNERIDENTIFIER_DESCRIPTOR)
        field(TOKENIDENTIFIER_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ATBLOCKCHAININSTANT_DESCRIPTOR.index -> builder.atBlockchainInstant = deserializeBlockchainInstantDocument(deserializer)
                BALANCE_DESCRIPTOR.index -> builder.balance = deserializeString()
                LASTUPDATEDTIME_DESCRIPTOR.index -> builder.lastUpdatedTime = deserializeBlockchainInstantDocument(deserializer)
                OWNERIDENTIFIER_DESCRIPTOR.index -> builder.ownerIdentifier = deserializeOwnerIdentifierDocument(deserializer)
                TOKENIDENTIFIER_DESCRIPTOR.index -> builder.tokenIdentifier = deserializeTokenIdentifierDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
