// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.managedblockchainquery.paginators

import aws.sdk.kotlin.services.managedblockchainquery.ManagedBlockchainQueryClient
import aws.sdk.kotlin.services.managedblockchainquery.model.AssetContract
import aws.sdk.kotlin.services.managedblockchainquery.model.ListAssetContractsRequest
import aws.sdk.kotlin.services.managedblockchainquery.model.ListAssetContractsResponse
import aws.sdk.kotlin.services.managedblockchainquery.model.ListFilteredTransactionEventsRequest
import aws.sdk.kotlin.services.managedblockchainquery.model.ListFilteredTransactionEventsResponse
import aws.sdk.kotlin.services.managedblockchainquery.model.ListTokenBalancesRequest
import aws.sdk.kotlin.services.managedblockchainquery.model.ListTokenBalancesResponse
import aws.sdk.kotlin.services.managedblockchainquery.model.ListTransactionEventsRequest
import aws.sdk.kotlin.services.managedblockchainquery.model.ListTransactionEventsResponse
import aws.sdk.kotlin.services.managedblockchainquery.model.ListTransactionsRequest
import aws.sdk.kotlin.services.managedblockchainquery.model.ListTransactionsResponse
import aws.sdk.kotlin.services.managedblockchainquery.model.TokenBalance
import aws.sdk.kotlin.services.managedblockchainquery.model.TransactionEvent
import aws.sdk.kotlin.services.managedblockchainquery.model.TransactionOutputItem
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListAssetContractsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAssetContractsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAssetContractsResponse]
 */
public fun ManagedBlockchainQueryClient.listAssetContractsPaginated(initialRequest: ListAssetContractsRequest): Flow<ListAssetContractsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAssetContractsPaginated.listAssetContracts(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListAssetContractsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAssetContractsResponse]
 */
public fun ManagedBlockchainQueryClient.listAssetContractsPaginated(block: ListAssetContractsRequest.Builder.() -> Unit): Flow<ListAssetContractsResponse> =
    listAssetContractsPaginated(ListAssetContractsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listAssetContractsPaginated]
 * to access the nested member [AssetContract]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AssetContract]
 */
@JvmName("listAssetContractsResponseAssetContract")
public fun Flow<ListAssetContractsResponse>.contracts(): Flow<AssetContract> =
    transform() { response ->
        response.contracts?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListFilteredTransactionEventsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListFilteredTransactionEventsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFilteredTransactionEventsResponse]
 */
public fun ManagedBlockchainQueryClient.listFilteredTransactionEventsPaginated(initialRequest: ListFilteredTransactionEventsRequest): Flow<ListFilteredTransactionEventsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listFilteredTransactionEventsPaginated.listFilteredTransactionEvents(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListFilteredTransactionEventsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFilteredTransactionEventsResponse]
 */
public fun ManagedBlockchainQueryClient.listFilteredTransactionEventsPaginated(block: ListFilteredTransactionEventsRequest.Builder.() -> Unit): Flow<ListFilteredTransactionEventsResponse> =
    listFilteredTransactionEventsPaginated(ListFilteredTransactionEventsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listFilteredTransactionEventsPaginated]
 * to access the nested member [TransactionEvent]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [TransactionEvent]
 */
@JvmName("listFilteredTransactionEventsResponseTransactionEvent")
public fun Flow<ListFilteredTransactionEventsResponse>.events(): Flow<TransactionEvent> =
    transform() { response ->
        response.events?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListTokenBalancesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTokenBalancesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTokenBalancesResponse]
 */
public fun ManagedBlockchainQueryClient.listTokenBalancesPaginated(initialRequest: ListTokenBalancesRequest): Flow<ListTokenBalancesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTokenBalancesPaginated.listTokenBalances(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListTokenBalancesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTokenBalancesResponse]
 */
public fun ManagedBlockchainQueryClient.listTokenBalancesPaginated(block: ListTokenBalancesRequest.Builder.() -> Unit): Flow<ListTokenBalancesResponse> =
    listTokenBalancesPaginated(ListTokenBalancesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listTokenBalancesPaginated]
 * to access the nested member [TokenBalance]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [TokenBalance]
 */
@JvmName("listTokenBalancesResponseTokenBalance")
public fun Flow<ListTokenBalancesResponse>.tokenBalances(): Flow<TokenBalance> =
    transform() { response ->
        response.tokenBalances?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListTransactionEventsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTransactionEventsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTransactionEventsResponse]
 */
public fun ManagedBlockchainQueryClient.listTransactionEventsPaginated(initialRequest: ListTransactionEventsRequest): Flow<ListTransactionEventsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTransactionEventsPaginated.listTransactionEvents(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListTransactionEventsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTransactionEventsResponse]
 */
public fun ManagedBlockchainQueryClient.listTransactionEventsPaginated(block: ListTransactionEventsRequest.Builder.() -> Unit): Flow<ListTransactionEventsResponse> =
    listTransactionEventsPaginated(ListTransactionEventsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listTransactionEventsPaginated]
 * to access the nested member [TransactionEvent]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [TransactionEvent]
 */
@JvmName("listTransactionEventsResponseTransactionEvent")
public fun Flow<ListTransactionEventsResponse>.events(): Flow<TransactionEvent> =
    transform() { response ->
        response.events?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListTransactionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTransactionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTransactionsResponse]
 */
public fun ManagedBlockchainQueryClient.listTransactionsPaginated(initialRequest: ListTransactionsRequest): Flow<ListTransactionsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTransactionsPaginated.listTransactions(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListTransactionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTransactionsResponse]
 */
public fun ManagedBlockchainQueryClient.listTransactionsPaginated(block: ListTransactionsRequest.Builder.() -> Unit): Flow<ListTransactionsResponse> =
    listTransactionsPaginated(ListTransactionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listTransactionsPaginated]
 * to access the nested member [TransactionOutputItem]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [TransactionOutputItem]
 */
@JvmName("listTransactionsResponseTransactionOutputItem")
public fun Flow<ListTransactionsResponse>.transactions(): Flow<TransactionOutputItem> =
    transform() { response ->
        response.transactions?.forEach {
            emit(it)
        }
    }
