// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.managedblockchainquery.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * The container of the transaction output.
 */
public class TransactionOutputItem private constructor(builder: Builder) {
    /**
     * Specifies whether to list transactions that have not reached Finality.
     */
    public val confirmationStatus: aws.sdk.kotlin.services.managedblockchainquery.model.ConfirmationStatus? = builder.confirmationStatus
    /**
     * The blockchain network where the transaction occurred.
     */
    public val network: aws.sdk.kotlin.services.managedblockchainquery.model.QueryNetwork = requireNotNull(builder.network) { "A non-null value must be provided for network" }
    /**
     * The hash of a transaction. It is generated when a transaction is created.
     */
    public val transactionHash: kotlin.String = requireNotNull(builder.transactionHash) { "A non-null value must be provided for transactionHash" }
    /**
     * The identifier of a Bitcoin transaction. It is generated when a transaction is created.
     */
    public val transactionId: kotlin.String? = builder.transactionId
    /**
     * The time when the transaction occurred.
     */
    public val transactionTimestamp: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.transactionTimestamp) { "A non-null value must be provided for transactionTimestamp" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.managedblockchainquery.model.TransactionOutputItem = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TransactionOutputItem(")
        append("confirmationStatus=$confirmationStatus,")
        append("network=$network,")
        append("transactionHash=$transactionHash,")
        append("transactionId=$transactionId,")
        append("transactionTimestamp=$transactionTimestamp")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = confirmationStatus?.hashCode() ?: 0
        result = 31 * result + (network.hashCode())
        result = 31 * result + (transactionHash.hashCode())
        result = 31 * result + (transactionId?.hashCode() ?: 0)
        result = 31 * result + (transactionTimestamp.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TransactionOutputItem

        if (confirmationStatus != other.confirmationStatus) return false
        if (network != other.network) return false
        if (transactionHash != other.transactionHash) return false
        if (transactionId != other.transactionId) return false
        if (transactionTimestamp != other.transactionTimestamp) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.managedblockchainquery.model.TransactionOutputItem = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies whether to list transactions that have not reached Finality.
         */
        public var confirmationStatus: aws.sdk.kotlin.services.managedblockchainquery.model.ConfirmationStatus? = null
        /**
         * The blockchain network where the transaction occurred.
         */
        public var network: aws.sdk.kotlin.services.managedblockchainquery.model.QueryNetwork? = null
        /**
         * The hash of a transaction. It is generated when a transaction is created.
         */
        public var transactionHash: kotlin.String? = null
        /**
         * The identifier of a Bitcoin transaction. It is generated when a transaction is created.
         */
        public var transactionId: kotlin.String? = null
        /**
         * The time when the transaction occurred.
         */
        public var transactionTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.managedblockchainquery.model.TransactionOutputItem) : this() {
            this.confirmationStatus = x.confirmationStatus
            this.network = x.network
            this.transactionHash = x.transactionHash
            this.transactionId = x.transactionId
            this.transactionTimestamp = x.transactionTimestamp
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.managedblockchainquery.model.TransactionOutputItem = TransactionOutputItem(this)

        internal fun correctErrors(): Builder {
            if (network == null) network = QueryNetwork.SdkUnknown("no value provided")
            if (transactionHash == null) transactionHash = ""
            if (transactionTimestamp == null) transactionTimestamp = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
