// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.managedblockchainquery.serde

import aws.sdk.kotlin.services.managedblockchainquery.model.BlockchainInstant
import aws.sdk.kotlin.services.managedblockchainquery.model.ConfirmationStatusFilter
import aws.sdk.kotlin.services.managedblockchainquery.model.ListTransactionsRequest
import aws.sdk.kotlin.services.managedblockchainquery.model.ListTransactionsSort
import aws.sdk.kotlin.services.managedblockchainquery.model.QueryNetwork
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ListTransactionsOperationSerializer: HttpSerializer.NonStreaming<ListTransactionsRequest> {
    override fun serialize(context: ExecutionContext, input: ListTransactionsRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/list-transactions"
        }

        val payload = serializeListTransactionsOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeListTransactionsOperationBody(context: ExecutionContext, input: ListTransactionsRequest): ByteArray {
    val serializer = JsonSerializer()
    val ADDRESS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("address"))
    val CONFIRMATIONSTATUSFILTER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("confirmationStatusFilter"))
    val FROMBLOCKCHAININSTANT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("fromBlockchainInstant"))
    val MAXRESULTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("maxResults"))
    val NETWORK_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("network"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("nextToken"))
    val SORT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("sort"))
    val TOBLOCKCHAININSTANT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("toBlockchainInstant"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ADDRESS_DESCRIPTOR)
        field(CONFIRMATIONSTATUSFILTER_DESCRIPTOR)
        field(FROMBLOCKCHAININSTANT_DESCRIPTOR)
        field(MAXRESULTS_DESCRIPTOR)
        field(NETWORK_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(SORT_DESCRIPTOR)
        field(TOBLOCKCHAININSTANT_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.address?.let { field(ADDRESS_DESCRIPTOR, it) }
        input.confirmationStatusFilter?.let { field(CONFIRMATIONSTATUSFILTER_DESCRIPTOR, it, ::serializeConfirmationStatusFilterDocument) }
        input.fromBlockchainInstant?.let { field(FROMBLOCKCHAININSTANT_DESCRIPTOR, it, ::serializeBlockchainInstantDocument) }
        input.maxResults?.let { field(MAXRESULTS_DESCRIPTOR, it) }
        input.network?.let { field(NETWORK_DESCRIPTOR, it.value) }
        input.nextToken?.let { field(NEXTTOKEN_DESCRIPTOR, it) }
        input.sort?.let { field(SORT_DESCRIPTOR, it, ::serializeListTransactionsSortDocument) }
        input.toBlockchainInstant?.let { field(TOBLOCKCHAININSTANT_DESCRIPTOR, it, ::serializeBlockchainInstantDocument) }
    }
    return serializer.toByteArray()
}
