// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.managedblockchainquery.model

import aws.smithy.kotlin.runtime.SdkDsl

public class ListTransactionEventsRequest private constructor(builder: Builder) {
    /**
     * The maximum number of transaction events to list.
     *
     * Default: `100`
     *
     * Even if additional results can be retrieved, the request can return less results than `maxResults` or an empty array of results.
     *
     * To retrieve the next set of results, make another request with the returned `nextToken` value. The value of `nextToken` is `null` when there are no more results to return
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The blockchain network where the transaction events occurred.
     */
    public val network: aws.sdk.kotlin.services.managedblockchainquery.model.QueryNetwork? = builder.network
    /**
     * The pagination token that indicates the next set of results to retrieve.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The hash of a transaction. It is generated when a transaction is created.
     */
    public val transactionHash: kotlin.String? = builder.transactionHash
    /**
     * The identifier of a Bitcoin transaction. It is generated when a transaction is created.
     *
     * `transactionId` is only supported on the Bitcoin networks.
     */
    public val transactionId: kotlin.String? = builder.transactionId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.managedblockchainquery.model.ListTransactionEventsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListTransactionEventsRequest(")
        append("maxResults=$maxResults,")
        append("network=$network,")
        append("nextToken=$nextToken,")
        append("transactionHash=$transactionHash,")
        append("transactionId=$transactionId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = maxResults ?: 0
        result = 31 * result + (network?.hashCode() ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (transactionHash?.hashCode() ?: 0)
        result = 31 * result + (transactionId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListTransactionEventsRequest

        if (maxResults != other.maxResults) return false
        if (network != other.network) return false
        if (nextToken != other.nextToken) return false
        if (transactionHash != other.transactionHash) return false
        if (transactionId != other.transactionId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.managedblockchainquery.model.ListTransactionEventsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The maximum number of transaction events to list.
         *
         * Default: `100`
         *
         * Even if additional results can be retrieved, the request can return less results than `maxResults` or an empty array of results.
         *
         * To retrieve the next set of results, make another request with the returned `nextToken` value. The value of `nextToken` is `null` when there are no more results to return
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The blockchain network where the transaction events occurred.
         */
        public var network: aws.sdk.kotlin.services.managedblockchainquery.model.QueryNetwork? = null
        /**
         * The pagination token that indicates the next set of results to retrieve.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The hash of a transaction. It is generated when a transaction is created.
         */
        public var transactionHash: kotlin.String? = null
        /**
         * The identifier of a Bitcoin transaction. It is generated when a transaction is created.
         *
         * `transactionId` is only supported on the Bitcoin networks.
         */
        public var transactionId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.managedblockchainquery.model.ListTransactionEventsRequest) : this() {
            this.maxResults = x.maxResults
            this.network = x.network
            this.nextToken = x.nextToken
            this.transactionHash = x.transactionHash
            this.transactionId = x.transactionId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.managedblockchainquery.model.ListTransactionEventsRequest = ListTransactionEventsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
