// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.managedblockchainquery

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.runtime.region.DefaultRegionProviderChain
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.managedblockchainquery.auth.DefaultManagedBlockchainQueryAuthSchemeProvider
import aws.sdk.kotlin.services.managedblockchainquery.auth.ManagedBlockchainQueryAuthSchemeProvider
import aws.sdk.kotlin.services.managedblockchainquery.endpoints.DefaultManagedBlockchainQueryEndpointProvider
import aws.sdk.kotlin.services.managedblockchainquery.endpoints.ManagedBlockchainQueryEndpointParameters
import aws.sdk.kotlin.services.managedblockchainquery.endpoints.ManagedBlockchainQueryEndpointProvider
import aws.sdk.kotlin.services.managedblockchainquery.model.BatchGetTokenBalanceRequest
import aws.sdk.kotlin.services.managedblockchainquery.model.BatchGetTokenBalanceResponse
import aws.sdk.kotlin.services.managedblockchainquery.model.GetAssetContractRequest
import aws.sdk.kotlin.services.managedblockchainquery.model.GetAssetContractResponse
import aws.sdk.kotlin.services.managedblockchainquery.model.GetTokenBalanceRequest
import aws.sdk.kotlin.services.managedblockchainquery.model.GetTokenBalanceResponse
import aws.sdk.kotlin.services.managedblockchainquery.model.GetTransactionRequest
import aws.sdk.kotlin.services.managedblockchainquery.model.GetTransactionResponse
import aws.sdk.kotlin.services.managedblockchainquery.model.ListAssetContractsRequest
import aws.sdk.kotlin.services.managedblockchainquery.model.ListAssetContractsResponse
import aws.sdk.kotlin.services.managedblockchainquery.model.ListFilteredTransactionEventsRequest
import aws.sdk.kotlin.services.managedblockchainquery.model.ListFilteredTransactionEventsResponse
import aws.sdk.kotlin.services.managedblockchainquery.model.ListTokenBalancesRequest
import aws.sdk.kotlin.services.managedblockchainquery.model.ListTokenBalancesResponse
import aws.sdk.kotlin.services.managedblockchainquery.model.ListTransactionEventsRequest
import aws.sdk.kotlin.services.managedblockchainquery.model.ListTransactionEventsResponse
import aws.sdk.kotlin.services.managedblockchainquery.model.ListTransactionsRequest
import aws.sdk.kotlin.services.managedblockchainquery.model.ListTransactionsResponse
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.region.RegionProvider
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.config.TimeoutConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic
import kotlin.time.Duration
import kotlinx.coroutines.runBlocking


public const val ServiceId: String = "ManagedBlockchain Query"
public const val SdkVersion: String = "1.5.18"
public const val ServiceApiVersion: String = "2023-05-04"

/**
 * Amazon Managed Blockchain (AMB) Query provides you with convenient access to multi-blockchain network data, which makes it easier for you to extract contextual data related to blockchain activity. You can use AMB Query to read data from public blockchain networks, such as Bitcoin Mainnet and Ethereum Mainnet. You can also get information such as the current and historical balances of addresses, or you can get a list of blockchain transactions for a given time period. Additionally, you can get details of a given transaction, such as transaction events, which you can further analyze or use in business logic for your applications.
 */
public interface ManagedBlockchainQueryClient : SdkClient {
    /**
     * ManagedBlockchainQueryClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, ManagedBlockchainQueryClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "ManagedBlockchainQuery",
                "MANAGEDBLOCKCHAIN_QUERY",
                "managedblockchain_query",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, ManagedBlockchainQueryClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): ManagedBlockchainQueryClient = DefaultManagedBlockchainQueryClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig, TimeoutConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region ?: runBlocking { builder.regionProvider?.getRegion() ?: resolveRegion() }
        override val regionProvider: RegionProvider = builder.regionProvider ?: DefaultRegionProviderChain()
        override val attemptTimeout: Duration? = builder.attemptTimeout
        override val authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = builder.authSchemePreference
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val callTimeout: Duration? = builder.callTimeout
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: ManagedBlockchainQueryEndpointProvider = builder.endpointProvider ?: DefaultManagedBlockchainQueryEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: ManagedBlockchainQueryAuthSchemeProvider = builder.authSchemeProvider ?: DefaultManagedBlockchainQueryAuthSchemeProvider(authSchemePreference = authSchemePreference)
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            regionProvider = this@Config.regionProvider
            attemptTimeout = this@Config.attemptTimeout
            authSchemePreference = this@Config.authSchemePreference
            authSchemes = this@Config.authSchemes
            callTimeout = this@Config.callTimeout
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder, TimeoutConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "ManagedBlockchain Query"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more information.
             * When specified, this static region configuration takes precedence over other region resolution methods.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var region: String? = null

            /**
             * An optional region provider that determines the AWS region for client operations. When specified, this provider
             * takes precedence over the default region provider chain, unless a static region is explicitly configured.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var regionProvider: RegionProvider? = null

            /**
             * The maximum amount of time to wait for any single attempt of a request within the retry loop. By default,
             * the value is `null` indicating no timeout is enforced. Attempt timeouts may be retried if allowed by the
             * current retry policy and retry capacity.
             */
            override var attemptTimeout: Duration? = null

            /**
             * The ordered preference of [AuthScheme] that this client will use.
             */
            override var authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The maximum amount of time to wait for completion of a call, including any retries after the first attempt.
             * By default, the value is `null` indicating no timeout is enforced. Call timeouts are not retried.
             */
            override var callTimeout: Duration? = null

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: ManagedBlockchainQueryEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: ManagedBlockchainQueryAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Gets the token balance for a batch of tokens by using the `BatchGetTokenBalance` action for every token in the request.
     *
     * Only the native tokens BTC and ETH, and the ERC-20, ERC-721, and ERC 1155 token standards are supported.
     */
    public suspend fun batchGetTokenBalance(input: BatchGetTokenBalanceRequest = BatchGetTokenBalanceRequest { }): BatchGetTokenBalanceResponse

    /**
     * Gets the information about a specific contract deployed on the blockchain.
     *
     * + The Bitcoin blockchain networks do not support this operation.
     * + Metadata is currently only available for some `ERC-20` contracts. Metadata will be available for additional contracts in the future.
     */
    public suspend fun getAssetContract(input: GetAssetContractRequest): GetAssetContractResponse

    /**
     * Gets the balance of a specific token, including native tokens, for a given address (wallet or contract) on the blockchain.
     *
     * Only the native tokens BTC and ETH, and the ERC-20, ERC-721, and ERC 1155 token standards are supported.
     */
    public suspend fun getTokenBalance(input: GetTokenBalanceRequest): GetTokenBalanceResponse

    /**
     * Gets the details of a transaction.
     *
     * This action will return transaction details for all transactions that are *confirmed* on the blockchain, even if they have not reached [finality](https://docs.aws.amazon.com/managed-blockchain/latest/ambq-dg/key-concepts.html#finality).
     */
    public suspend fun getTransaction(input: GetTransactionRequest): GetTransactionResponse

    /**
     * Lists all the contracts for a given contract type deployed by an address (either a contract address or a wallet address).
     *
     * The Bitcoin blockchain networks do not support this operation.
     */
    public suspend fun listAssetContracts(input: ListAssetContractsRequest): ListAssetContractsResponse

    /**
     * Lists all the transaction events for an address on the blockchain.
     *
     * This operation is only supported on the Bitcoin networks.
     */
    public suspend fun listFilteredTransactionEvents(input: ListFilteredTransactionEventsRequest): ListFilteredTransactionEventsResponse

    /**
     * This action returns the following for a given blockchain network:
     * + Lists all token balances owned by an address (either a contract address or a wallet address).
     * + Lists all token balances for all tokens created by a contract.
     * + Lists all token balances for a given token.
     *
     * You must always specify the network property of the `tokenFilter` when using this operation.
     */
    public suspend fun listTokenBalances(input: ListTokenBalancesRequest): ListTokenBalancesResponse

    /**
     * Lists all the transaction events for a transaction
     *
     * This action will return transaction details for all transactions that are *confirmed* on the blockchain, even if they have not reached [finality](https://docs.aws.amazon.com/managed-blockchain/latest/ambq-dg/key-concepts.html#finality).
     */
    public suspend fun listTransactionEvents(input: ListTransactionEventsRequest): ListTransactionEventsResponse

    /**
     * Lists all the transaction events for a transaction.
     */
    public suspend fun listTransactions(input: ListTransactionsRequest): ListTransactionsResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun ManagedBlockchainQueryClient.withConfig(block: ManagedBlockchainQueryClient.Config.Builder.() -> Unit): ManagedBlockchainQueryClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultManagedBlockchainQueryClient(newConfig)
}

/**
 * Gets the token balance for a batch of tokens by using the `BatchGetTokenBalance` action for every token in the request.
 *
 * Only the native tokens BTC and ETH, and the ERC-20, ERC-721, and ERC 1155 token standards are supported.
 */
public suspend inline fun ManagedBlockchainQueryClient.batchGetTokenBalance(crossinline block: BatchGetTokenBalanceRequest.Builder.() -> Unit): BatchGetTokenBalanceResponse = batchGetTokenBalance(BatchGetTokenBalanceRequest.Builder().apply(block).build())

/**
 * Gets the information about a specific contract deployed on the blockchain.
 *
 * + The Bitcoin blockchain networks do not support this operation.
 * + Metadata is currently only available for some `ERC-20` contracts. Metadata will be available for additional contracts in the future.
 */
public suspend inline fun ManagedBlockchainQueryClient.getAssetContract(crossinline block: GetAssetContractRequest.Builder.() -> Unit): GetAssetContractResponse = getAssetContract(GetAssetContractRequest.Builder().apply(block).build())

/**
 * Gets the balance of a specific token, including native tokens, for a given address (wallet or contract) on the blockchain.
 *
 * Only the native tokens BTC and ETH, and the ERC-20, ERC-721, and ERC 1155 token standards are supported.
 */
public suspend inline fun ManagedBlockchainQueryClient.getTokenBalance(crossinline block: GetTokenBalanceRequest.Builder.() -> Unit): GetTokenBalanceResponse = getTokenBalance(GetTokenBalanceRequest.Builder().apply(block).build())

/**
 * Gets the details of a transaction.
 *
 * This action will return transaction details for all transactions that are *confirmed* on the blockchain, even if they have not reached [finality](https://docs.aws.amazon.com/managed-blockchain/latest/ambq-dg/key-concepts.html#finality).
 */
public suspend inline fun ManagedBlockchainQueryClient.getTransaction(crossinline block: GetTransactionRequest.Builder.() -> Unit): GetTransactionResponse = getTransaction(GetTransactionRequest.Builder().apply(block).build())

/**
 * Lists all the contracts for a given contract type deployed by an address (either a contract address or a wallet address).
 *
 * The Bitcoin blockchain networks do not support this operation.
 */
public suspend inline fun ManagedBlockchainQueryClient.listAssetContracts(crossinline block: ListAssetContractsRequest.Builder.() -> Unit): ListAssetContractsResponse = listAssetContracts(ListAssetContractsRequest.Builder().apply(block).build())

/**
 * Lists all the transaction events for an address on the blockchain.
 *
 * This operation is only supported on the Bitcoin networks.
 */
public suspend inline fun ManagedBlockchainQueryClient.listFilteredTransactionEvents(crossinline block: ListFilteredTransactionEventsRequest.Builder.() -> Unit): ListFilteredTransactionEventsResponse = listFilteredTransactionEvents(ListFilteredTransactionEventsRequest.Builder().apply(block).build())

/**
 * This action returns the following for a given blockchain network:
 * + Lists all token balances owned by an address (either a contract address or a wallet address).
 * + Lists all token balances for all tokens created by a contract.
 * + Lists all token balances for a given token.
 *
 * You must always specify the network property of the `tokenFilter` when using this operation.
 */
public suspend inline fun ManagedBlockchainQueryClient.listTokenBalances(crossinline block: ListTokenBalancesRequest.Builder.() -> Unit): ListTokenBalancesResponse = listTokenBalances(ListTokenBalancesRequest.Builder().apply(block).build())

/**
 * Lists all the transaction events for a transaction
 *
 * This action will return transaction details for all transactions that are *confirmed* on the blockchain, even if they have not reached [finality](https://docs.aws.amazon.com/managed-blockchain/latest/ambq-dg/key-concepts.html#finality).
 */
public suspend inline fun ManagedBlockchainQueryClient.listTransactionEvents(crossinline block: ListTransactionEventsRequest.Builder.() -> Unit): ListTransactionEventsResponse = listTransactionEvents(ListTransactionEventsRequest.Builder().apply(block).build())

/**
 * Lists all the transaction events for a transaction.
 */
public suspend inline fun ManagedBlockchainQueryClient.listTransactions(crossinline block: ListTransactionsRequest.Builder.() -> Unit): ListTransactionsResponse = listTransactions(ListTransactionsRequest.Builder().apply(block).build())
