// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.managedblockchainquery

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.managedblockchainquery.auth.DefaultManagedBlockchainQueryAuthSchemeProvider
import aws.sdk.kotlin.services.managedblockchainquery.auth.ManagedBlockchainQueryAuthSchemeProvider
import aws.sdk.kotlin.services.managedblockchainquery.endpoints.DefaultManagedBlockchainQueryEndpointProvider
import aws.sdk.kotlin.services.managedblockchainquery.endpoints.ManagedBlockchainQueryEndpointParameters
import aws.sdk.kotlin.services.managedblockchainquery.endpoints.ManagedBlockchainQueryEndpointProvider
import aws.sdk.kotlin.services.managedblockchainquery.model.BatchGetTokenBalanceRequest
import aws.sdk.kotlin.services.managedblockchainquery.model.BatchGetTokenBalanceResponse
import aws.sdk.kotlin.services.managedblockchainquery.model.GetTokenBalanceRequest
import aws.sdk.kotlin.services.managedblockchainquery.model.GetTokenBalanceResponse
import aws.sdk.kotlin.services.managedblockchainquery.model.GetTransactionRequest
import aws.sdk.kotlin.services.managedblockchainquery.model.GetTransactionResponse
import aws.sdk.kotlin.services.managedblockchainquery.model.ListTokenBalancesRequest
import aws.sdk.kotlin.services.managedblockchainquery.model.ListTokenBalancesResponse
import aws.sdk.kotlin.services.managedblockchainquery.model.ListTransactionEventsRequest
import aws.sdk.kotlin.services.managedblockchainquery.model.ListTransactionEventsResponse
import aws.sdk.kotlin.services.managedblockchainquery.model.ListTransactionsRequest
import aws.sdk.kotlin.services.managedblockchainquery.model.ListTransactionsResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "ManagedBlockchain Query"
public const val SdkVersion: String = "0.32.0-beta"

/**
 * Amazon Managed Blockchain (AMB) Query provides you with convenient access to multi-blockchain network data, which makes it easier for you to extract contextual data related to blockchain activity. You can use AMB Query to read data from public blockchain networks, such as Bitcoin Mainnet and Ethereum Mainnet. You can also get information such as the current and historical balances of addresses, or you can get a list of blockchain transactions for a given time period. Additionally, you can get details of a given transaction, such as transaction events, which you can further analyze or use in business logic for your applications.
 */
public interface ManagedBlockchainQueryClient : SdkClient {
    /**
     * ManagedBlockchainQueryClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, ManagedBlockchainQueryClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, ManagedBlockchainQueryClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): ManagedBlockchainQueryClient = DefaultManagedBlockchainQueryClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        public val authSchemeProvider: ManagedBlockchainQueryAuthSchemeProvider = builder.authSchemeProvider ?: DefaultManagedBlockchainQueryAuthSchemeProvider
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: ManagedBlockchainQueryEndpointProvider = builder.endpointProvider ?: DefaultManagedBlockchainQueryEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsDefaultRetryPolicy
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemeProvider = this@Config.authSchemeProvider
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "ManagedBlockchain Query"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: ManagedBlockchainQueryAuthSchemeProvider? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: ManagedBlockchainQueryEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Gets the token balance for a batch of tokens by using the `GetTokenBalance` action for every token in the request.
     *
     * Only the native tokens BTC,ETH, and the ERC-20, ERC-721, and ERC 1155 token standards are supported.
     */
    public suspend fun batchGetTokenBalance(input: BatchGetTokenBalanceRequest = BatchGetTokenBalanceRequest {}): BatchGetTokenBalanceResponse

    /**
     * Gets the balance of a specific token, including native tokens, for a given address (wallet or contract) on the blockchain.
     *
     * Only the native tokens BTC,ETH, and the ERC-20, ERC-721, and ERC 1155 token standards are supported.
     */
    public suspend fun getTokenBalance(input: GetTokenBalanceRequest): GetTokenBalanceResponse

    /**
     * Get the details of a transaction.
     */
    public suspend fun getTransaction(input: GetTransactionRequest): GetTransactionResponse

    /**
     * This action returns the following for a given a blockchain network:
     * + Lists all token balances owned by an address (either a contact address or a wallet address).
     * + Lists all token balances for all tokens created by a contract.
     * + Lists all token balances for a given token.
     *
     * You must always specify the network property of the `tokenFilter` when using this operation.
     */
    public suspend fun listTokenBalances(input: ListTokenBalancesRequest): ListTokenBalancesResponse

    /**
     * An array of `TransactionEvent` objects. Each object contains details about the transaction event.
     */
    public suspend fun listTransactionEvents(input: ListTransactionEventsRequest): ListTransactionEventsResponse

    /**
     * Lists all of the transactions on a given wallet address or to a specific contract.
     */
    public suspend fun listTransactions(input: ListTransactionsRequest): ListTransactionsResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun ManagedBlockchainQueryClient.withConfig(block: ManagedBlockchainQueryClient.Config.Builder.() -> Unit): ManagedBlockchainQueryClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultManagedBlockchainQueryClient(newConfig)
}

/**
 * Gets the token balance for a batch of tokens by using the `GetTokenBalance` action for every token in the request.
 *
 * Only the native tokens BTC,ETH, and the ERC-20, ERC-721, and ERC 1155 token standards are supported.
 */
public suspend inline fun ManagedBlockchainQueryClient.batchGetTokenBalance(crossinline block: BatchGetTokenBalanceRequest.Builder.() -> Unit): BatchGetTokenBalanceResponse = batchGetTokenBalance(BatchGetTokenBalanceRequest.Builder().apply(block).build())

/**
 * Gets the balance of a specific token, including native tokens, for a given address (wallet or contract) on the blockchain.
 *
 * Only the native tokens BTC,ETH, and the ERC-20, ERC-721, and ERC 1155 token standards are supported.
 */
public suspend inline fun ManagedBlockchainQueryClient.getTokenBalance(crossinline block: GetTokenBalanceRequest.Builder.() -> Unit): GetTokenBalanceResponse = getTokenBalance(GetTokenBalanceRequest.Builder().apply(block).build())

/**
 * Get the details of a transaction.
 */
public suspend inline fun ManagedBlockchainQueryClient.getTransaction(crossinline block: GetTransactionRequest.Builder.() -> Unit): GetTransactionResponse = getTransaction(GetTransactionRequest.Builder().apply(block).build())

/**
 * This action returns the following for a given a blockchain network:
 * + Lists all token balances owned by an address (either a contact address or a wallet address).
 * + Lists all token balances for all tokens created by a contract.
 * + Lists all token balances for a given token.
 *
 * You must always specify the network property of the `tokenFilter` when using this operation.
 */
public suspend inline fun ManagedBlockchainQueryClient.listTokenBalances(crossinline block: ListTokenBalancesRequest.Builder.() -> Unit): ListTokenBalancesResponse = listTokenBalances(ListTokenBalancesRequest.Builder().apply(block).build())

/**
 * An array of `TransactionEvent` objects. Each object contains details about the transaction event.
 */
public suspend inline fun ManagedBlockchainQueryClient.listTransactionEvents(crossinline block: ListTransactionEventsRequest.Builder.() -> Unit): ListTransactionEventsResponse = listTransactionEvents(ListTransactionEventsRequest.Builder().apply(block).build())

/**
 * Lists all of the transactions on a given wallet address or to a specific contract.
 */
public suspend inline fun ManagedBlockchainQueryClient.listTransactions(crossinline block: ListTransactionsRequest.Builder.() -> Unit): ListTransactionsResponse = listTransactions(ListTransactionsRequest.Builder().apply(block).build())
