// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.managedblockchain.model



public class CreateNodeRequest private constructor(builder: Builder) {
    /**
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent operation completes no more than one time. This identifier is required only if you make a service request directly using an HTTP client. It is generated automatically if you use an Amazon Web Services SDK or the CLI.
     */
    public val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * The unique identifier of the member that owns this node.
     *
     * Applies only to Hyperledger Fabric.
     */
    public val memberId: kotlin.String? = builder.memberId
    /**
     * The unique identifier of the network for the node.
     *
     * Ethereum public networks have the following `NetworkId`s:
     * + `n-ethereum-mainnet`
     * + `n-ethereum-rinkeby`
     * + `n-ethereum-ropsten`
     */
    public val networkId: kotlin.String? = requireNotNull(builder.networkId) { "A non-null value must be provided for networkId" }
    /**
     * The properties of a node configuration.
     */
    public val nodeConfiguration: aws.sdk.kotlin.services.managedblockchain.model.NodeConfiguration? = builder.nodeConfiguration
    /**
     * Tags to assign to the node. Each tag consists of a key and optional value.
     *
     * When specifying tags during creation, you can specify multiple key-value pairs in a single request, with an overall maximum of 50 tags added to each resource.
     *
     * For more information about tags, see [Tagging Resources](https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html) in the *Amazon Managed Blockchain Ethereum Developer Guide*, or [Tagging Resources](https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html) in the *Amazon Managed Blockchain Hyperledger Fabric Developer Guide*.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.managedblockchain.model.CreateNodeRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateNodeRequest(")
        append("clientRequestToken=$clientRequestToken,")
        append("memberId=$memberId,")
        append("networkId=$networkId,")
        append("nodeConfiguration=$nodeConfiguration,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientRequestToken?.hashCode() ?: 0
        result = 31 * result + (memberId?.hashCode() ?: 0)
        result = 31 * result + (networkId?.hashCode() ?: 0)
        result = 31 * result + (nodeConfiguration?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateNodeRequest

        if (clientRequestToken != other.clientRequestToken) return false
        if (memberId != other.memberId) return false
        if (networkId != other.networkId) return false
        if (nodeConfiguration != other.nodeConfiguration) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.managedblockchain.model.CreateNodeRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent operation completes no more than one time. This identifier is required only if you make a service request directly using an HTTP client. It is generated automatically if you use an Amazon Web Services SDK or the CLI.
         */
        public var clientRequestToken: kotlin.String? = null
        /**
         * The unique identifier of the member that owns this node.
         *
         * Applies only to Hyperledger Fabric.
         */
        public var memberId: kotlin.String? = null
        /**
         * The unique identifier of the network for the node.
         *
         * Ethereum public networks have the following `NetworkId`s:
         * + `n-ethereum-mainnet`
         * + `n-ethereum-rinkeby`
         * + `n-ethereum-ropsten`
         */
        public var networkId: kotlin.String? = null
        /**
         * The properties of a node configuration.
         */
        public var nodeConfiguration: aws.sdk.kotlin.services.managedblockchain.model.NodeConfiguration? = null
        /**
         * Tags to assign to the node. Each tag consists of a key and optional value.
         *
         * When specifying tags during creation, you can specify multiple key-value pairs in a single request, with an overall maximum of 50 tags added to each resource.
         *
         * For more information about tags, see [Tagging Resources](https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html) in the *Amazon Managed Blockchain Ethereum Developer Guide*, or [Tagging Resources](https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html) in the *Amazon Managed Blockchain Hyperledger Fabric Developer Guide*.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.managedblockchain.model.CreateNodeRequest) : this() {
            this.clientRequestToken = x.clientRequestToken
            this.memberId = x.memberId
            this.networkId = x.networkId
            this.nodeConfiguration = x.nodeConfiguration
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.managedblockchain.model.CreateNodeRequest = CreateNodeRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.managedblockchain.model.NodeConfiguration] inside the given [block]
         */
        public fun nodeConfiguration(block: aws.sdk.kotlin.services.managedblockchain.model.NodeConfiguration.Builder.() -> kotlin.Unit) {
            this.nodeConfiguration = aws.sdk.kotlin.services.managedblockchain.model.NodeConfiguration.invoke(block)
        }
    }
}
