// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.managedblockchain.paginators

import aws.sdk.kotlin.services.managedblockchain.ManagedBlockchainClient
import aws.sdk.kotlin.services.managedblockchain.model.AccessorSummary
import aws.sdk.kotlin.services.managedblockchain.model.ListAccessorsRequest
import aws.sdk.kotlin.services.managedblockchain.model.ListAccessorsResponse
import aws.sdk.kotlin.services.managedblockchain.model.ListInvitationsRequest
import aws.sdk.kotlin.services.managedblockchain.model.ListInvitationsResponse
import aws.sdk.kotlin.services.managedblockchain.model.ListMembersRequest
import aws.sdk.kotlin.services.managedblockchain.model.ListMembersResponse
import aws.sdk.kotlin.services.managedblockchain.model.ListNetworksRequest
import aws.sdk.kotlin.services.managedblockchain.model.ListNetworksResponse
import aws.sdk.kotlin.services.managedblockchain.model.ListNodesRequest
import aws.sdk.kotlin.services.managedblockchain.model.ListNodesResponse
import aws.sdk.kotlin.services.managedblockchain.model.ListProposalVotesRequest
import aws.sdk.kotlin.services.managedblockchain.model.ListProposalVotesResponse
import aws.sdk.kotlin.services.managedblockchain.model.ListProposalsRequest
import aws.sdk.kotlin.services.managedblockchain.model.ListProposalsResponse
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListAccessorsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAccessorsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAccessorsResponse]
 */
public fun ManagedBlockchainClient.listAccessorsPaginated(initialRequest: ListAccessorsRequest = ListAccessorsRequest { }): Flow<ListAccessorsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAccessorsPaginated.listAccessors(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListAccessorsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAccessorsResponse]
 */
public fun ManagedBlockchainClient.listAccessorsPaginated(block: ListAccessorsRequest.Builder.() -> Unit): Flow<ListAccessorsResponse> =
    listAccessorsPaginated(ListAccessorsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listAccessorsPaginated]
 * to access the nested member [AccessorSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AccessorSummary]
 */
@JvmName("listAccessorsResponseAccessorSummary")
public fun Flow<ListAccessorsResponse>.accessors(): Flow<AccessorSummary> =
    transform() { response ->
        response.accessors?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListInvitationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListInvitationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListInvitationsResponse]
 */
public fun ManagedBlockchainClient.listInvitationsPaginated(initialRequest: ListInvitationsRequest = ListInvitationsRequest { }): Flow<ListInvitationsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listInvitationsPaginated.listInvitations(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListInvitationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListInvitationsResponse]
 */
public fun ManagedBlockchainClient.listInvitationsPaginated(block: ListInvitationsRequest.Builder.() -> Unit): Flow<ListInvitationsResponse> =
    listInvitationsPaginated(ListInvitationsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListMembersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListMembersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMembersResponse]
 */
public fun ManagedBlockchainClient.listMembersPaginated(initialRequest: ListMembersRequest): Flow<ListMembersResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listMembersPaginated.listMembers(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListMembersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMembersResponse]
 */
public fun ManagedBlockchainClient.listMembersPaginated(block: ListMembersRequest.Builder.() -> Unit): Flow<ListMembersResponse> =
    listMembersPaginated(ListMembersRequest.Builder().apply(block).build())

/**
 * Paginate over [ListNetworksResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListNetworksRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListNetworksResponse]
 */
public fun ManagedBlockchainClient.listNetworksPaginated(initialRequest: ListNetworksRequest = ListNetworksRequest { }): Flow<ListNetworksResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listNetworksPaginated.listNetworks(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListNetworksResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListNetworksResponse]
 */
public fun ManagedBlockchainClient.listNetworksPaginated(block: ListNetworksRequest.Builder.() -> Unit): Flow<ListNetworksResponse> =
    listNetworksPaginated(ListNetworksRequest.Builder().apply(block).build())

/**
 * Paginate over [ListNodesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListNodesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListNodesResponse]
 */
public fun ManagedBlockchainClient.listNodesPaginated(initialRequest: ListNodesRequest): Flow<ListNodesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listNodesPaginated.listNodes(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListNodesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListNodesResponse]
 */
public fun ManagedBlockchainClient.listNodesPaginated(block: ListNodesRequest.Builder.() -> Unit): Flow<ListNodesResponse> =
    listNodesPaginated(ListNodesRequest.Builder().apply(block).build())

/**
 * Paginate over [ListProposalsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListProposalsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListProposalsResponse]
 */
public fun ManagedBlockchainClient.listProposalsPaginated(initialRequest: ListProposalsRequest): Flow<ListProposalsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listProposalsPaginated.listProposals(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListProposalsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListProposalsResponse]
 */
public fun ManagedBlockchainClient.listProposalsPaginated(block: ListProposalsRequest.Builder.() -> Unit): Flow<ListProposalsResponse> =
    listProposalsPaginated(ListProposalsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListProposalVotesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListProposalVotesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListProposalVotesResponse]
 */
public fun ManagedBlockchainClient.listProposalVotesPaginated(initialRequest: ListProposalVotesRequest): Flow<ListProposalVotesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listProposalVotesPaginated.listProposalVotes(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListProposalVotesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListProposalVotesResponse]
 */
public fun ManagedBlockchainClient.listProposalVotesPaginated(block: ListProposalVotesRequest.Builder.() -> Unit): Flow<ListProposalVotesResponse> =
    listProposalVotesPaginated(ListProposalVotesRequest.Builder().apply(block).build())
