// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.managedblockchain.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * A summary of accessor properties.
 */
public class AccessorSummary private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the accessor. For more information about ARNs and their format, see [Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference*.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The creation date and time of the accessor.
     */
    public val creationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDate
    /**
     * The unique identifier of the accessor.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The blockchain network that the Accessor token is created for.
     */
    public val networkType: aws.sdk.kotlin.services.managedblockchain.model.AccessorNetworkType? = builder.networkType
    /**
     * The current status of the accessor.
     */
    public val status: aws.sdk.kotlin.services.managedblockchain.model.AccessorStatus? = builder.status
    /**
     * The type of the accessor.
     *
     * Currently accessor type is restricted to `BILLING_TOKEN`.
     */
    public val type: aws.sdk.kotlin.services.managedblockchain.model.AccessorType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.managedblockchain.model.AccessorSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AccessorSummary(")
        append("arn=$arn,")
        append("creationDate=$creationDate,")
        append("id=$id,")
        append("networkType=$networkType,")
        append("status=$status,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (creationDate?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (networkType?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AccessorSummary

        if (arn != other.arn) return false
        if (creationDate != other.creationDate) return false
        if (id != other.id) return false
        if (networkType != other.networkType) return false
        if (status != other.status) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.managedblockchain.model.AccessorSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the accessor. For more information about ARNs and their format, see [Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference*.
         */
        public var arn: kotlin.String? = null
        /**
         * The creation date and time of the accessor.
         */
        public var creationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The unique identifier of the accessor.
         */
        public var id: kotlin.String? = null
        /**
         * The blockchain network that the Accessor token is created for.
         */
        public var networkType: aws.sdk.kotlin.services.managedblockchain.model.AccessorNetworkType? = null
        /**
         * The current status of the accessor.
         */
        public var status: aws.sdk.kotlin.services.managedblockchain.model.AccessorStatus? = null
        /**
         * The type of the accessor.
         *
         * Currently accessor type is restricted to `BILLING_TOKEN`.
         */
        public var type: aws.sdk.kotlin.services.managedblockchain.model.AccessorType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.managedblockchain.model.AccessorSummary) : this() {
            this.arn = x.arn
            this.creationDate = x.creationDate
            this.id = x.id
            this.networkType = x.networkType
            this.status = x.status
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.managedblockchain.model.AccessorSummary = AccessorSummary(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
