// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.managedblockchain.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A summary of configuration properties for a member.
 *
 * Applies only to Hyperledger Fabric.
 */
public class MemberSummary private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the member. For more information about ARNs and their format, see [Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference*.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The date and time that the member was created.
     */
    public val creationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDate
    /**
     * An optional description of the member.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The unique identifier of the member.
     */
    public val id: kotlin.String? = builder.id
    /**
     * An indicator of whether the member is owned by your Amazon Web Services account or a different Amazon Web Services account.
     */
    public val isOwned: kotlin.Boolean? = builder.isOwned
    /**
     * The name of the member.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The status of the member.
     * + `CREATING` - The Amazon Web Services account is in the process of creating a member.
     * + `AVAILABLE` - The member has been created and can participate in the network.
     * + `CREATE_FAILED` - The Amazon Web Services account attempted to create a member and creation failed.
     * + `UPDATING` - The member is in the process of being updated.
     * + `DELETING` - The member and all associated resources are in the process of being deleted. Either the Amazon Web Services account that owns the member deleted it, or the member is being deleted as the result of an `APPROVED``PROPOSAL` to remove the member.
     * + `DELETED` - The member can no longer participate on the network and all associated resources are deleted. Either the Amazon Web Services account that owns the member deleted it, or the member is being deleted as the result of an `APPROVED``PROPOSAL` to remove the member.
     * + `INACCESSIBLE_ENCRYPTION_KEY` - The member is impaired and might not function as expected because it cannot access the specified customer managed key in Key Management Service (KMS) for encryption at rest. Either the KMS key was disabled or deleted, or the grants on the key were revoked.The effect of disabling or deleting a key or of revoking a grant isn't immediate. It might take some time for the member resource to discover that the key is inaccessible. When a resource is in this state, we recommend deleting and recreating the resource.
     */
    public val status: aws.sdk.kotlin.services.managedblockchain.model.MemberStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.managedblockchain.model.MemberSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MemberSummary(")
        append("arn=$arn,")
        append("creationDate=$creationDate,")
        append("description=$description,")
        append("id=$id,")
        append("isOwned=$isOwned,")
        append("name=$name,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (creationDate?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (isOwned?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MemberSummary

        if (arn != other.arn) return false
        if (creationDate != other.creationDate) return false
        if (description != other.description) return false
        if (id != other.id) return false
        if (isOwned != other.isOwned) return false
        if (name != other.name) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.managedblockchain.model.MemberSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the member. For more information about ARNs and their format, see [Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference*.
         */
        public var arn: kotlin.String? = null
        /**
         * The date and time that the member was created.
         */
        public var creationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * An optional description of the member.
         */
        public var description: kotlin.String? = null
        /**
         * The unique identifier of the member.
         */
        public var id: kotlin.String? = null
        /**
         * An indicator of whether the member is owned by your Amazon Web Services account or a different Amazon Web Services account.
         */
        public var isOwned: kotlin.Boolean? = null
        /**
         * The name of the member.
         */
        public var name: kotlin.String? = null
        /**
         * The status of the member.
         * + `CREATING` - The Amazon Web Services account is in the process of creating a member.
         * + `AVAILABLE` - The member has been created and can participate in the network.
         * + `CREATE_FAILED` - The Amazon Web Services account attempted to create a member and creation failed.
         * + `UPDATING` - The member is in the process of being updated.
         * + `DELETING` - The member and all associated resources are in the process of being deleted. Either the Amazon Web Services account that owns the member deleted it, or the member is being deleted as the result of an `APPROVED``PROPOSAL` to remove the member.
         * + `DELETED` - The member can no longer participate on the network and all associated resources are deleted. Either the Amazon Web Services account that owns the member deleted it, or the member is being deleted as the result of an `APPROVED``PROPOSAL` to remove the member.
         * + `INACCESSIBLE_ENCRYPTION_KEY` - The member is impaired and might not function as expected because it cannot access the specified customer managed key in Key Management Service (KMS) for encryption at rest. Either the KMS key was disabled or deleted, or the grants on the key were revoked.The effect of disabling or deleting a key or of revoking a grant isn't immediate. It might take some time for the member resource to discover that the key is inaccessible. When a resource is in this state, we recommend deleting and recreating the resource.
         */
        public var status: aws.sdk.kotlin.services.managedblockchain.model.MemberStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.managedblockchain.model.MemberSummary) : this() {
            this.arn = x.arn
            this.creationDate = x.creationDate
            this.description = x.description
            this.id = x.id
            this.isOwned = x.isOwned
            this.name = x.name
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.managedblockchain.model.MemberSummary = MemberSummary(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
