// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.managedblockchain.serde

import aws.sdk.kotlin.services.managedblockchain.model.CreateNetworkResponse
import aws.sdk.kotlin.services.managedblockchain.model.ManagedBlockchainException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateNetworkOperationDeserializer: HttpDeserialize<CreateNetworkResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): CreateNetworkResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateNetworkError(context, call)
        }
        val builder = CreateNetworkResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateNetworkOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwCreateNetworkError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ManagedBlockchainException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceLimitExceededException" -> ResourceLimitExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServiceErrorException" -> InternalServiceErrorExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall)
        "TooManyTagsException" -> TooManyTagsExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceAlreadyExistsException" -> ResourceAlreadyExistsExceptionDeserializer().deserialize(context, wrappedCall)
        else -> ManagedBlockchainException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateNetworkOperationBody(builder: CreateNetworkResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val MEMBERID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("MemberId"))
    val NETWORKID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NetworkId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(MEMBERID_DESCRIPTOR)
        field(NETWORKID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                MEMBERID_DESCRIPTOR.index -> builder.memberId = deserializeString()
                NETWORKID_DESCRIPTOR.index -> builder.networkId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
