// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.managedblockchain.model



public class CreateAccessorRequest private constructor(builder: Builder) {
    /**
     * The type of accessor.
     *
     * Currently, accessor type is restricted to `BILLING_TOKEN`.
     */
    public val accessorType: aws.sdk.kotlin.services.managedblockchain.model.AccessorType? = builder.accessorType
    /**
     * This is a unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent operation completes no more than once. This identifier is required only if you make a service request directly using an HTTP client. It is generated automatically if you use an Amazon Web Services SDK or the Amazon Web Services CLI.
     */
    public val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * The blockchain network that the `Accessor` token is created for.
     *
     * We recommend using the appropriate `networkType` value for the blockchain network that you are creating the `Accessor` token for. You cannnot use the value `ETHEREUM_MAINNET_AND_GOERLI` to specify a `networkType` for your Accessor token.
     *
     * The default value of `ETHEREUM_MAINNET_AND_GOERLI` is only applied:
     * + when the `CreateAccessor` action does not set a `networkType`.
     * + to all existing `Accessor` tokens that were created before the `networkType` property was introduced.
     */
    public val networkType: aws.sdk.kotlin.services.managedblockchain.model.AccessorNetworkType? = builder.networkType
    /**
     * Tags to assign to the Accessor.
     *
     *  Each tag consists of a key and an optional value. You can specify multiple key-value pairs in a single request with an overall maximum of 50 tags allowed per resource.
     *
     * For more information about tags, see [Tagging Resources](https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html) in the *Amazon Managed Blockchain Ethereum Developer Guide*, or [Tagging Resources](https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html) in the *Amazon Managed Blockchain Hyperledger Fabric Developer Guide*.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.managedblockchain.model.CreateAccessorRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateAccessorRequest(")
        append("accessorType=$accessorType,")
        append("clientRequestToken=$clientRequestToken,")
        append("networkType=$networkType,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessorType?.hashCode() ?: 0
        result = 31 * result + (clientRequestToken?.hashCode() ?: 0)
        result = 31 * result + (networkType?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateAccessorRequest

        if (accessorType != other.accessorType) return false
        if (clientRequestToken != other.clientRequestToken) return false
        if (networkType != other.networkType) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.managedblockchain.model.CreateAccessorRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The type of accessor.
         *
         * Currently, accessor type is restricted to `BILLING_TOKEN`.
         */
        public var accessorType: aws.sdk.kotlin.services.managedblockchain.model.AccessorType? = null
        /**
         * This is a unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent operation completes no more than once. This identifier is required only if you make a service request directly using an HTTP client. It is generated automatically if you use an Amazon Web Services SDK or the Amazon Web Services CLI.
         */
        public var clientRequestToken: kotlin.String? = null
        /**
         * The blockchain network that the `Accessor` token is created for.
         *
         * We recommend using the appropriate `networkType` value for the blockchain network that you are creating the `Accessor` token for. You cannnot use the value `ETHEREUM_MAINNET_AND_GOERLI` to specify a `networkType` for your Accessor token.
         *
         * The default value of `ETHEREUM_MAINNET_AND_GOERLI` is only applied:
         * + when the `CreateAccessor` action does not set a `networkType`.
         * + to all existing `Accessor` tokens that were created before the `networkType` property was introduced.
         */
        public var networkType: aws.sdk.kotlin.services.managedblockchain.model.AccessorNetworkType? = null
        /**
         * Tags to assign to the Accessor.
         *
         *  Each tag consists of a key and an optional value. You can specify multiple key-value pairs in a single request with an overall maximum of 50 tags allowed per resource.
         *
         * For more information about tags, see [Tagging Resources](https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html) in the *Amazon Managed Blockchain Ethereum Developer Guide*, or [Tagging Resources](https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html) in the *Amazon Managed Blockchain Hyperledger Fabric Developer Guide*.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.managedblockchain.model.CreateAccessorRequest) : this() {
            this.accessorType = x.accessorType
            this.clientRequestToken = x.clientRequestToken
            this.networkType = x.networkType
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.managedblockchain.model.CreateAccessorRequest = CreateAccessorRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
