// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.managedblockchain.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Member configuration properties.
 *
 * Applies only to Hyperledger Fabric.
 */
public class Member private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the member. For more information about ARNs and their format, see [Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference*.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The date and time that the member was created.
     */
    public val creationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDate
    /**
     * An optional description for the member.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Attributes relevant to a member for the blockchain framework that the Managed Blockchain network uses.
     */
    public val frameworkAttributes: aws.sdk.kotlin.services.managedblockchain.model.MemberFrameworkAttributes? = builder.frameworkAttributes
    /**
     * The unique identifier of the member.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The Amazon Resource Name (ARN) of the customer managed key in Key Management Service (KMS) that the member uses for encryption at rest. If the value of this parameter is `"AWS Owned KMS Key"`, the member uses an Amazon Web Services owned KMS key for encryption. This parameter is inherited by the nodes that this member owns.
     *
     * For more information, see [Encryption at Rest](https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/managed-blockchain-encryption-at-rest.html) in the *Amazon Managed Blockchain Hyperledger Fabric Developer Guide*.
     */
    public val kmsKeyArn: kotlin.String? = builder.kmsKeyArn
    /**
     * Configuration properties for logging events associated with a member.
     */
    public val logPublishingConfiguration: aws.sdk.kotlin.services.managedblockchain.model.MemberLogPublishingConfiguration? = builder.logPublishingConfiguration
    /**
     * The name of the member.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The unique identifier of the network to which the member belongs.
     */
    public val networkId: kotlin.String? = builder.networkId
    /**
     * The status of a member.
     * + `CREATING` - The Amazon Web Services account is in the process of creating a member.
     * + `AVAILABLE` - The member has been created and can participate in the network.
     * + `CREATE_FAILED` - The Amazon Web Services account attempted to create a member and creation failed.
     * + `UPDATING` - The member is in the process of being updated.
     * + `DELETING` - The member and all associated resources are in the process of being deleted. Either the Amazon Web Services account that owns the member deleted it, or the member is being deleted as the result of an `APPROVED``PROPOSAL` to remove the member.
     * + `DELETED` - The member can no longer participate on the network and all associated resources are deleted. Either the Amazon Web Services account that owns the member deleted it, or the member is being deleted as the result of an `APPROVED``PROPOSAL` to remove the member.
     * + `INACCESSIBLE_ENCRYPTION_KEY` - The member is impaired and might not function as expected because it cannot access the specified customer managed key in KMS for encryption at rest. Either the KMS key was disabled or deleted, or the grants on the key were revoked.The effect of disabling or deleting a key or of revoking a grant isn't immediate. It might take some time for the member resource to discover that the key is inaccessible. When a resource is in this state, we recommend deleting and recreating the resource.
     */
    public val status: aws.sdk.kotlin.services.managedblockchain.model.MemberStatus? = builder.status
    /**
     * Tags assigned to the member. Tags consist of a key and optional value.
     *
     * For more information about tags, see [Tagging Resources](https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html) in the *Amazon Managed Blockchain Ethereum Developer Guide*, or [Tagging Resources](https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html) in the *Amazon Managed Blockchain Hyperledger Fabric Developer Guide*.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.managedblockchain.model.Member = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Member(")
        append("arn=$arn,")
        append("creationDate=$creationDate,")
        append("description=$description,")
        append("frameworkAttributes=$frameworkAttributes,")
        append("id=$id,")
        append("kmsKeyArn=$kmsKeyArn,")
        append("logPublishingConfiguration=$logPublishingConfiguration,")
        append("name=$name,")
        append("networkId=$networkId,")
        append("status=$status,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (creationDate?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (frameworkAttributes?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyArn?.hashCode() ?: 0)
        result = 31 * result + (logPublishingConfiguration?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (networkId?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Member

        if (arn != other.arn) return false
        if (creationDate != other.creationDate) return false
        if (description != other.description) return false
        if (frameworkAttributes != other.frameworkAttributes) return false
        if (id != other.id) return false
        if (kmsKeyArn != other.kmsKeyArn) return false
        if (logPublishingConfiguration != other.logPublishingConfiguration) return false
        if (name != other.name) return false
        if (networkId != other.networkId) return false
        if (status != other.status) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.managedblockchain.model.Member = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the member. For more information about ARNs and their format, see [Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference*.
         */
        public var arn: kotlin.String? = null
        /**
         * The date and time that the member was created.
         */
        public var creationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * An optional description for the member.
         */
        public var description: kotlin.String? = null
        /**
         * Attributes relevant to a member for the blockchain framework that the Managed Blockchain network uses.
         */
        public var frameworkAttributes: aws.sdk.kotlin.services.managedblockchain.model.MemberFrameworkAttributes? = null
        /**
         * The unique identifier of the member.
         */
        public var id: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the customer managed key in Key Management Service (KMS) that the member uses for encryption at rest. If the value of this parameter is `"AWS Owned KMS Key"`, the member uses an Amazon Web Services owned KMS key for encryption. This parameter is inherited by the nodes that this member owns.
         *
         * For more information, see [Encryption at Rest](https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/managed-blockchain-encryption-at-rest.html) in the *Amazon Managed Blockchain Hyperledger Fabric Developer Guide*.
         */
        public var kmsKeyArn: kotlin.String? = null
        /**
         * Configuration properties for logging events associated with a member.
         */
        public var logPublishingConfiguration: aws.sdk.kotlin.services.managedblockchain.model.MemberLogPublishingConfiguration? = null
        /**
         * The name of the member.
         */
        public var name: kotlin.String? = null
        /**
         * The unique identifier of the network to which the member belongs.
         */
        public var networkId: kotlin.String? = null
        /**
         * The status of a member.
         * + `CREATING` - The Amazon Web Services account is in the process of creating a member.
         * + `AVAILABLE` - The member has been created and can participate in the network.
         * + `CREATE_FAILED` - The Amazon Web Services account attempted to create a member and creation failed.
         * + `UPDATING` - The member is in the process of being updated.
         * + `DELETING` - The member and all associated resources are in the process of being deleted. Either the Amazon Web Services account that owns the member deleted it, or the member is being deleted as the result of an `APPROVED``PROPOSAL` to remove the member.
         * + `DELETED` - The member can no longer participate on the network and all associated resources are deleted. Either the Amazon Web Services account that owns the member deleted it, or the member is being deleted as the result of an `APPROVED``PROPOSAL` to remove the member.
         * + `INACCESSIBLE_ENCRYPTION_KEY` - The member is impaired and might not function as expected because it cannot access the specified customer managed key in KMS for encryption at rest. Either the KMS key was disabled or deleted, or the grants on the key were revoked.The effect of disabling or deleting a key or of revoking a grant isn't immediate. It might take some time for the member resource to discover that the key is inaccessible. When a resource is in this state, we recommend deleting and recreating the resource.
         */
        public var status: aws.sdk.kotlin.services.managedblockchain.model.MemberStatus? = null
        /**
         * Tags assigned to the member. Tags consist of a key and optional value.
         *
         * For more information about tags, see [Tagging Resources](https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html) in the *Amazon Managed Blockchain Ethereum Developer Guide*, or [Tagging Resources](https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html) in the *Amazon Managed Blockchain Hyperledger Fabric Developer Guide*.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.managedblockchain.model.Member) : this() {
            this.arn = x.arn
            this.creationDate = x.creationDate
            this.description = x.description
            this.frameworkAttributes = x.frameworkAttributes
            this.id = x.id
            this.kmsKeyArn = x.kmsKeyArn
            this.logPublishingConfiguration = x.logPublishingConfiguration
            this.name = x.name
            this.networkId = x.networkId
            this.status = x.status
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.managedblockchain.model.Member = Member(this)

        /**
         * construct an [aws.sdk.kotlin.services.managedblockchain.model.MemberFrameworkAttributes] inside the given [block]
         */
        public fun frameworkAttributes(block: aws.sdk.kotlin.services.managedblockchain.model.MemberFrameworkAttributes.Builder.() -> kotlin.Unit) {
            this.frameworkAttributes = aws.sdk.kotlin.services.managedblockchain.model.MemberFrameworkAttributes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.managedblockchain.model.MemberLogPublishingConfiguration] inside the given [block]
         */
        public fun logPublishingConfiguration(block: aws.sdk.kotlin.services.managedblockchain.model.MemberLogPublishingConfiguration.Builder.() -> kotlin.Unit) {
            this.logPublishingConfiguration = aws.sdk.kotlin.services.managedblockchain.model.MemberLogPublishingConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
