// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.managedblockchain.model



/**
 * Configuration properties for Hyperledger Fabric for a member in a Managed Blockchain network that is using the Hyperledger Fabric framework.
 */
public class MemberFabricConfiguration private constructor(builder: Builder) {
    /**
     * The password for the member's initial administrative user. The `AdminPassword` must be at least 8 characters long and no more than 32 characters. It must contain at least one uppercase letter, one lowercase letter, and one digit. It cannot have a single quotation mark (‘), a double quotation marks (“), a forward slash(/), a backward slash(\), @, or a space.
     */
    public val adminPassword: kotlin.String = requireNotNull(builder.adminPassword) { "A non-null value must be provided for adminPassword" }
    /**
     * The user name for the member's initial administrative user.
     */
    public val adminUsername: kotlin.String = requireNotNull(builder.adminUsername) { "A non-null value must be provided for adminUsername" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.managedblockchain.model.MemberFabricConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MemberFabricConfiguration(")
        append("adminPassword=*** Sensitive Data Redacted ***,")
        append("adminUsername=$adminUsername")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = adminPassword.hashCode()
        result = 31 * result + (adminUsername.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MemberFabricConfiguration

        if (adminPassword != other.adminPassword) return false
        if (adminUsername != other.adminUsername) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.managedblockchain.model.MemberFabricConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The password for the member's initial administrative user. The `AdminPassword` must be at least 8 characters long and no more than 32 characters. It must contain at least one uppercase letter, one lowercase letter, and one digit. It cannot have a single quotation mark (‘), a double quotation marks (“), a forward slash(/), a backward slash(\), @, or a space.
         */
        public var adminPassword: kotlin.String? = null
        /**
         * The user name for the member's initial administrative user.
         */
        public var adminUsername: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.managedblockchain.model.MemberFabricConfiguration) : this() {
            this.adminPassword = x.adminPassword
            this.adminUsername = x.adminUsername
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.managedblockchain.model.MemberFabricConfiguration = MemberFabricConfiguration(this)

        internal fun correctErrors(): Builder {
            if (adminPassword == null) adminPassword = ""
            if (adminUsername == null) adminUsername = ""
            return this
        }
    }
}
