// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.managedblockchain

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.managedblockchain.auth.DefaultManagedBlockchainAuthSchemeProvider
import aws.sdk.kotlin.services.managedblockchain.auth.ManagedBlockchainAuthSchemeProvider
import aws.sdk.kotlin.services.managedblockchain.endpoints.DefaultManagedBlockchainEndpointProvider
import aws.sdk.kotlin.services.managedblockchain.endpoints.ManagedBlockchainEndpointParameters
import aws.sdk.kotlin.services.managedblockchain.endpoints.ManagedBlockchainEndpointProvider
import aws.sdk.kotlin.services.managedblockchain.model.CreateAccessorRequest
import aws.sdk.kotlin.services.managedblockchain.model.CreateAccessorResponse
import aws.sdk.kotlin.services.managedblockchain.model.CreateMemberRequest
import aws.sdk.kotlin.services.managedblockchain.model.CreateMemberResponse
import aws.sdk.kotlin.services.managedblockchain.model.CreateNetworkRequest
import aws.sdk.kotlin.services.managedblockchain.model.CreateNetworkResponse
import aws.sdk.kotlin.services.managedblockchain.model.CreateNodeRequest
import aws.sdk.kotlin.services.managedblockchain.model.CreateNodeResponse
import aws.sdk.kotlin.services.managedblockchain.model.CreateProposalRequest
import aws.sdk.kotlin.services.managedblockchain.model.CreateProposalResponse
import aws.sdk.kotlin.services.managedblockchain.model.DeleteAccessorRequest
import aws.sdk.kotlin.services.managedblockchain.model.DeleteAccessorResponse
import aws.sdk.kotlin.services.managedblockchain.model.DeleteMemberRequest
import aws.sdk.kotlin.services.managedblockchain.model.DeleteMemberResponse
import aws.sdk.kotlin.services.managedblockchain.model.DeleteNodeRequest
import aws.sdk.kotlin.services.managedblockchain.model.DeleteNodeResponse
import aws.sdk.kotlin.services.managedblockchain.model.GetAccessorRequest
import aws.sdk.kotlin.services.managedblockchain.model.GetAccessorResponse
import aws.sdk.kotlin.services.managedblockchain.model.GetMemberRequest
import aws.sdk.kotlin.services.managedblockchain.model.GetMemberResponse
import aws.sdk.kotlin.services.managedblockchain.model.GetNetworkRequest
import aws.sdk.kotlin.services.managedblockchain.model.GetNetworkResponse
import aws.sdk.kotlin.services.managedblockchain.model.GetNodeRequest
import aws.sdk.kotlin.services.managedblockchain.model.GetNodeResponse
import aws.sdk.kotlin.services.managedblockchain.model.GetProposalRequest
import aws.sdk.kotlin.services.managedblockchain.model.GetProposalResponse
import aws.sdk.kotlin.services.managedblockchain.model.ListAccessorsRequest
import aws.sdk.kotlin.services.managedblockchain.model.ListAccessorsResponse
import aws.sdk.kotlin.services.managedblockchain.model.ListInvitationsRequest
import aws.sdk.kotlin.services.managedblockchain.model.ListInvitationsResponse
import aws.sdk.kotlin.services.managedblockchain.model.ListMembersRequest
import aws.sdk.kotlin.services.managedblockchain.model.ListMembersResponse
import aws.sdk.kotlin.services.managedblockchain.model.ListNetworksRequest
import aws.sdk.kotlin.services.managedblockchain.model.ListNetworksResponse
import aws.sdk.kotlin.services.managedblockchain.model.ListNodesRequest
import aws.sdk.kotlin.services.managedblockchain.model.ListNodesResponse
import aws.sdk.kotlin.services.managedblockchain.model.ListProposalVotesRequest
import aws.sdk.kotlin.services.managedblockchain.model.ListProposalVotesResponse
import aws.sdk.kotlin.services.managedblockchain.model.ListProposalsRequest
import aws.sdk.kotlin.services.managedblockchain.model.ListProposalsResponse
import aws.sdk.kotlin.services.managedblockchain.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.managedblockchain.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.managedblockchain.model.RejectInvitationRequest
import aws.sdk.kotlin.services.managedblockchain.model.RejectInvitationResponse
import aws.sdk.kotlin.services.managedblockchain.model.TagResourceRequest
import aws.sdk.kotlin.services.managedblockchain.model.TagResourceResponse
import aws.sdk.kotlin.services.managedblockchain.model.UntagResourceRequest
import aws.sdk.kotlin.services.managedblockchain.model.UntagResourceResponse
import aws.sdk.kotlin.services.managedblockchain.model.UpdateMemberRequest
import aws.sdk.kotlin.services.managedblockchain.model.UpdateMemberResponse
import aws.sdk.kotlin.services.managedblockchain.model.UpdateNodeRequest
import aws.sdk.kotlin.services.managedblockchain.model.UpdateNodeResponse
import aws.sdk.kotlin.services.managedblockchain.model.VoteOnProposalRequest
import aws.sdk.kotlin.services.managedblockchain.model.VoteOnProposalResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "ManagedBlockchain"
public const val SdkVersion: String = "1.0.31"
public const val ServiceApiVersion: String = "2018-09-24"

/**
 * Amazon Managed Blockchain is a fully managed service for creating and managing blockchain networks using open-source frameworks. Blockchain allows you to build applications where multiple parties can securely and transparently run transactions and share data without the need for a trusted, central authority.
 *
 * Managed Blockchain supports the Hyperledger Fabric and Ethereum open-source frameworks. Because of fundamental differences between the frameworks, some API actions or data types may only apply in the context of one framework and not the other. For example, actions related to Hyperledger Fabric network members such as `CreateMember` and `DeleteMember` don't apply to Ethereum.
 *
 * The description for each action indicates the framework or frameworks to which it applies. Data types and properties that apply only in the context of a particular framework are similarly indicated.
 */
public interface ManagedBlockchainClient : SdkClient {
    /**
     * ManagedBlockchainClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, ManagedBlockchainClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override suspend fun finalizeConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "ManagedBlockchain",
                "MANAGEDBLOCKCHAIN",
                "managedblockchain",
            )
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, ManagedBlockchainClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): ManagedBlockchainClient = DefaultManagedBlockchainClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), IdempotencyTokenConfig, RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: ManagedBlockchainEndpointProvider = builder.endpointProvider ?: DefaultManagedBlockchainEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: ManagedBlockchainAuthSchemeProvider = builder.authSchemeProvider ?: DefaultManagedBlockchainAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), IdempotencyTokenConfig.Builder, RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "ManagedBlockchain"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: ManagedBlockchainEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: ManagedBlockchainAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Creates a new accessor for use with Amazon Managed Blockchain service that supports token based access. The accessor contains information required for token based access.
     */
    public suspend fun createAccessor(input: CreateAccessorRequest): CreateAccessorResponse

    /**
     * Creates a member within a Managed Blockchain network.
     *
     * Applies only to Hyperledger Fabric.
     */
    public suspend fun createMember(input: CreateMemberRequest): CreateMemberResponse

    /**
     * Creates a new blockchain network using Amazon Managed Blockchain.
     *
     * Applies only to Hyperledger Fabric.
     */
    public suspend fun createNetwork(input: CreateNetworkRequest): CreateNetworkResponse

    /**
     * Creates a node on the specified blockchain network.
     *
     * Applies to Hyperledger Fabric and Ethereum.
     */
    public suspend fun createNode(input: CreateNodeRequest): CreateNodeResponse

    /**
     * Creates a proposal for a change to the network that other members of the network can vote on, for example, a proposal to add a new member to the network. Any member can create a proposal.
     *
     * Applies only to Hyperledger Fabric.
     */
    public suspend fun createProposal(input: CreateProposalRequest): CreateProposalResponse

    /**
     * Deletes an accessor that your Amazon Web Services account owns. An accessor object is a container that has the information required for token based access to your Ethereum nodes including, the `BILLING_TOKEN`. After an accessor is deleted, the status of the accessor changes from `AVAILABLE` to `PENDING_DELETION`. An accessor in the `PENDING_DELETION` state can’t be used for new WebSocket requests or HTTP requests. However, WebSocket connections that were initiated while the accessor was in the `AVAILABLE` state remain open until they expire (up to 2 hours).
     */
    public suspend fun deleteAccessor(input: DeleteAccessorRequest): DeleteAccessorResponse

    /**
     * Deletes a member. Deleting a member removes the member and all associated resources from the network. `DeleteMember` can only be called for a specified `MemberId` if the principal performing the action is associated with the Amazon Web Services account that owns the member. In all other cases, the `DeleteMember` action is carried out as the result of an approved proposal to remove a member. If `MemberId` is the last member in a network specified by the last Amazon Web Services account, the network is deleted also.
     *
     * Applies only to Hyperledger Fabric.
     */
    public suspend fun deleteMember(input: DeleteMemberRequest): DeleteMemberResponse

    /**
     * Deletes a node that your Amazon Web Services account owns. All data on the node is lost and cannot be recovered.
     *
     * Applies to Hyperledger Fabric and Ethereum.
     */
    public suspend fun deleteNode(input: DeleteNodeRequest): DeleteNodeResponse

    /**
     * Returns detailed information about an accessor. An accessor object is a container that has the information required for token based access to your Ethereum nodes.
     */
    public suspend fun getAccessor(input: GetAccessorRequest): GetAccessorResponse

    /**
     * Returns detailed information about a member.
     *
     * Applies only to Hyperledger Fabric.
     */
    public suspend fun getMember(input: GetMemberRequest): GetMemberResponse

    /**
     * Returns detailed information about a network.
     *
     * Applies to Hyperledger Fabric and Ethereum.
     */
    public suspend fun getNetwork(input: GetNetworkRequest): GetNetworkResponse

    /**
     * Returns detailed information about a node.
     *
     * Applies to Hyperledger Fabric and Ethereum.
     */
    public suspend fun getNode(input: GetNodeRequest): GetNodeResponse

    /**
     * Returns detailed information about a proposal.
     *
     * Applies only to Hyperledger Fabric.
     */
    public suspend fun getProposal(input: GetProposalRequest): GetProposalResponse

    /**
     * Returns a list of the accessors and their properties. Accessor objects are containers that have the information required for token based access to your Ethereum nodes.
     */
    public suspend fun listAccessors(input: ListAccessorsRequest = ListAccessorsRequest { }): ListAccessorsResponse

    /**
     * Returns a list of all invitations for the current Amazon Web Services account.
     *
     * Applies only to Hyperledger Fabric.
     */
    public suspend fun listInvitations(input: ListInvitationsRequest = ListInvitationsRequest { }): ListInvitationsResponse

    /**
     * Returns a list of the members in a network and properties of their configurations.
     *
     * Applies only to Hyperledger Fabric.
     */
    public suspend fun listMembers(input: ListMembersRequest): ListMembersResponse

    /**
     * Returns information about the networks in which the current Amazon Web Services account participates.
     *
     * Applies to Hyperledger Fabric and Ethereum.
     */
    public suspend fun listNetworks(input: ListNetworksRequest = ListNetworksRequest { }): ListNetworksResponse

    /**
     * Returns information about the nodes within a network.
     *
     * Applies to Hyperledger Fabric and Ethereum.
     */
    public suspend fun listNodes(input: ListNodesRequest): ListNodesResponse

    /**
     * Returns the list of votes for a specified proposal, including the value of each vote and the unique identifier of the member that cast the vote.
     *
     * Applies only to Hyperledger Fabric.
     */
    public suspend fun listProposalVotes(input: ListProposalVotesRequest): ListProposalVotesResponse

    /**
     * Returns a list of proposals for the network.
     *
     * Applies only to Hyperledger Fabric.
     */
    public suspend fun listProposals(input: ListProposalsRequest): ListProposalsResponse

    /**
     * Returns a list of tags for the specified resource. Each tag consists of a key and optional value.
     *
     * For more information about tags, see [Tagging Resources](https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html) in the *Amazon Managed Blockchain Ethereum Developer Guide*, or [Tagging Resources](https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html) in the *Amazon Managed Blockchain Hyperledger Fabric Developer Guide*.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Rejects an invitation to join a network. This action can be called by a principal in an Amazon Web Services account that has received an invitation to create a member and join a network.
     *
     * Applies only to Hyperledger Fabric.
     */
    public suspend fun rejectInvitation(input: RejectInvitationRequest): RejectInvitationResponse

    /**
     * Adds or overwrites the specified tags for the specified Amazon Managed Blockchain resource. Each tag consists of a key and optional value.
     *
     * When you specify a tag key that already exists, the tag value is overwritten with the new value. Use `UntagResource` to remove tag keys.
     *
     * A resource can have up to 50 tags. If you try to create more than 50 tags for a resource, your request fails and returns an error.
     *
     * For more information about tags, see [Tagging Resources](https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html) in the *Amazon Managed Blockchain Ethereum Developer Guide*, or [Tagging Resources](https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html) in the *Amazon Managed Blockchain Hyperledger Fabric Developer Guide*.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes the specified tags from the Amazon Managed Blockchain resource.
     *
     * For more information about tags, see [Tagging Resources](https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html) in the *Amazon Managed Blockchain Ethereum Developer Guide*, or [Tagging Resources](https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html) in the *Amazon Managed Blockchain Hyperledger Fabric Developer Guide*.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates a member configuration with new parameters.
     *
     * Applies only to Hyperledger Fabric.
     */
    public suspend fun updateMember(input: UpdateMemberRequest): UpdateMemberResponse

    /**
     * Updates a node configuration with new parameters.
     *
     * Applies only to Hyperledger Fabric.
     */
    public suspend fun updateNode(input: UpdateNodeRequest): UpdateNodeResponse

    /**
     * Casts a vote for a specified `ProposalId` on behalf of a member. The member to vote as, specified by `VoterMemberId`, must be in the same Amazon Web Services account as the principal that calls the action.
     *
     * Applies only to Hyperledger Fabric.
     */
    public suspend fun voteOnProposal(input: VoteOnProposalRequest): VoteOnProposalResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun ManagedBlockchainClient.withConfig(block: ManagedBlockchainClient.Config.Builder.() -> Unit): ManagedBlockchainClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultManagedBlockchainClient(newConfig)
}

/**
 * Creates a new accessor for use with Amazon Managed Blockchain service that supports token based access. The accessor contains information required for token based access.
 */
public suspend inline fun ManagedBlockchainClient.createAccessor(crossinline block: CreateAccessorRequest.Builder.() -> Unit): CreateAccessorResponse = createAccessor(CreateAccessorRequest.Builder().apply(block).build())

/**
 * Creates a member within a Managed Blockchain network.
 *
 * Applies only to Hyperledger Fabric.
 */
public suspend inline fun ManagedBlockchainClient.createMember(crossinline block: CreateMemberRequest.Builder.() -> Unit): CreateMemberResponse = createMember(CreateMemberRequest.Builder().apply(block).build())

/**
 * Creates a new blockchain network using Amazon Managed Blockchain.
 *
 * Applies only to Hyperledger Fabric.
 */
public suspend inline fun ManagedBlockchainClient.createNetwork(crossinline block: CreateNetworkRequest.Builder.() -> Unit): CreateNetworkResponse = createNetwork(CreateNetworkRequest.Builder().apply(block).build())

/**
 * Creates a node on the specified blockchain network.
 *
 * Applies to Hyperledger Fabric and Ethereum.
 */
public suspend inline fun ManagedBlockchainClient.createNode(crossinline block: CreateNodeRequest.Builder.() -> Unit): CreateNodeResponse = createNode(CreateNodeRequest.Builder().apply(block).build())

/**
 * Creates a proposal for a change to the network that other members of the network can vote on, for example, a proposal to add a new member to the network. Any member can create a proposal.
 *
 * Applies only to Hyperledger Fabric.
 */
public suspend inline fun ManagedBlockchainClient.createProposal(crossinline block: CreateProposalRequest.Builder.() -> Unit): CreateProposalResponse = createProposal(CreateProposalRequest.Builder().apply(block).build())

/**
 * Deletes an accessor that your Amazon Web Services account owns. An accessor object is a container that has the information required for token based access to your Ethereum nodes including, the `BILLING_TOKEN`. After an accessor is deleted, the status of the accessor changes from `AVAILABLE` to `PENDING_DELETION`. An accessor in the `PENDING_DELETION` state can’t be used for new WebSocket requests or HTTP requests. However, WebSocket connections that were initiated while the accessor was in the `AVAILABLE` state remain open until they expire (up to 2 hours).
 */
public suspend inline fun ManagedBlockchainClient.deleteAccessor(crossinline block: DeleteAccessorRequest.Builder.() -> Unit): DeleteAccessorResponse = deleteAccessor(DeleteAccessorRequest.Builder().apply(block).build())

/**
 * Deletes a member. Deleting a member removes the member and all associated resources from the network. `DeleteMember` can only be called for a specified `MemberId` if the principal performing the action is associated with the Amazon Web Services account that owns the member. In all other cases, the `DeleteMember` action is carried out as the result of an approved proposal to remove a member. If `MemberId` is the last member in a network specified by the last Amazon Web Services account, the network is deleted also.
 *
 * Applies only to Hyperledger Fabric.
 */
public suspend inline fun ManagedBlockchainClient.deleteMember(crossinline block: DeleteMemberRequest.Builder.() -> Unit): DeleteMemberResponse = deleteMember(DeleteMemberRequest.Builder().apply(block).build())

/**
 * Deletes a node that your Amazon Web Services account owns. All data on the node is lost and cannot be recovered.
 *
 * Applies to Hyperledger Fabric and Ethereum.
 */
public suspend inline fun ManagedBlockchainClient.deleteNode(crossinline block: DeleteNodeRequest.Builder.() -> Unit): DeleteNodeResponse = deleteNode(DeleteNodeRequest.Builder().apply(block).build())

/**
 * Returns detailed information about an accessor. An accessor object is a container that has the information required for token based access to your Ethereum nodes.
 */
public suspend inline fun ManagedBlockchainClient.getAccessor(crossinline block: GetAccessorRequest.Builder.() -> Unit): GetAccessorResponse = getAccessor(GetAccessorRequest.Builder().apply(block).build())

/**
 * Returns detailed information about a member.
 *
 * Applies only to Hyperledger Fabric.
 */
public suspend inline fun ManagedBlockchainClient.getMember(crossinline block: GetMemberRequest.Builder.() -> Unit): GetMemberResponse = getMember(GetMemberRequest.Builder().apply(block).build())

/**
 * Returns detailed information about a network.
 *
 * Applies to Hyperledger Fabric and Ethereum.
 */
public suspend inline fun ManagedBlockchainClient.getNetwork(crossinline block: GetNetworkRequest.Builder.() -> Unit): GetNetworkResponse = getNetwork(GetNetworkRequest.Builder().apply(block).build())

/**
 * Returns detailed information about a node.
 *
 * Applies to Hyperledger Fabric and Ethereum.
 */
public suspend inline fun ManagedBlockchainClient.getNode(crossinline block: GetNodeRequest.Builder.() -> Unit): GetNodeResponse = getNode(GetNodeRequest.Builder().apply(block).build())

/**
 * Returns detailed information about a proposal.
 *
 * Applies only to Hyperledger Fabric.
 */
public suspend inline fun ManagedBlockchainClient.getProposal(crossinline block: GetProposalRequest.Builder.() -> Unit): GetProposalResponse = getProposal(GetProposalRequest.Builder().apply(block).build())

/**
 * Returns a list of the accessors and their properties. Accessor objects are containers that have the information required for token based access to your Ethereum nodes.
 */
public suspend inline fun ManagedBlockchainClient.listAccessors(crossinline block: ListAccessorsRequest.Builder.() -> Unit): ListAccessorsResponse = listAccessors(ListAccessorsRequest.Builder().apply(block).build())

/**
 * Returns a list of all invitations for the current Amazon Web Services account.
 *
 * Applies only to Hyperledger Fabric.
 */
public suspend inline fun ManagedBlockchainClient.listInvitations(crossinline block: ListInvitationsRequest.Builder.() -> Unit): ListInvitationsResponse = listInvitations(ListInvitationsRequest.Builder().apply(block).build())

/**
 * Returns a list of the members in a network and properties of their configurations.
 *
 * Applies only to Hyperledger Fabric.
 */
public suspend inline fun ManagedBlockchainClient.listMembers(crossinline block: ListMembersRequest.Builder.() -> Unit): ListMembersResponse = listMembers(ListMembersRequest.Builder().apply(block).build())

/**
 * Returns information about the networks in which the current Amazon Web Services account participates.
 *
 * Applies to Hyperledger Fabric and Ethereum.
 */
public suspend inline fun ManagedBlockchainClient.listNetworks(crossinline block: ListNetworksRequest.Builder.() -> Unit): ListNetworksResponse = listNetworks(ListNetworksRequest.Builder().apply(block).build())

/**
 * Returns information about the nodes within a network.
 *
 * Applies to Hyperledger Fabric and Ethereum.
 */
public suspend inline fun ManagedBlockchainClient.listNodes(crossinline block: ListNodesRequest.Builder.() -> Unit): ListNodesResponse = listNodes(ListNodesRequest.Builder().apply(block).build())

/**
 * Returns the list of votes for a specified proposal, including the value of each vote and the unique identifier of the member that cast the vote.
 *
 * Applies only to Hyperledger Fabric.
 */
public suspend inline fun ManagedBlockchainClient.listProposalVotes(crossinline block: ListProposalVotesRequest.Builder.() -> Unit): ListProposalVotesResponse = listProposalVotes(ListProposalVotesRequest.Builder().apply(block).build())

/**
 * Returns a list of proposals for the network.
 *
 * Applies only to Hyperledger Fabric.
 */
public suspend inline fun ManagedBlockchainClient.listProposals(crossinline block: ListProposalsRequest.Builder.() -> Unit): ListProposalsResponse = listProposals(ListProposalsRequest.Builder().apply(block).build())

/**
 * Returns a list of tags for the specified resource. Each tag consists of a key and optional value.
 *
 * For more information about tags, see [Tagging Resources](https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html) in the *Amazon Managed Blockchain Ethereum Developer Guide*, or [Tagging Resources](https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html) in the *Amazon Managed Blockchain Hyperledger Fabric Developer Guide*.
 */
public suspend inline fun ManagedBlockchainClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Rejects an invitation to join a network. This action can be called by a principal in an Amazon Web Services account that has received an invitation to create a member and join a network.
 *
 * Applies only to Hyperledger Fabric.
 */
public suspend inline fun ManagedBlockchainClient.rejectInvitation(crossinline block: RejectInvitationRequest.Builder.() -> Unit): RejectInvitationResponse = rejectInvitation(RejectInvitationRequest.Builder().apply(block).build())

/**
 * Adds or overwrites the specified tags for the specified Amazon Managed Blockchain resource. Each tag consists of a key and optional value.
 *
 * When you specify a tag key that already exists, the tag value is overwritten with the new value. Use `UntagResource` to remove tag keys.
 *
 * A resource can have up to 50 tags. If you try to create more than 50 tags for a resource, your request fails and returns an error.
 *
 * For more information about tags, see [Tagging Resources](https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html) in the *Amazon Managed Blockchain Ethereum Developer Guide*, or [Tagging Resources](https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html) in the *Amazon Managed Blockchain Hyperledger Fabric Developer Guide*.
 */
public suspend inline fun ManagedBlockchainClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes the specified tags from the Amazon Managed Blockchain resource.
 *
 * For more information about tags, see [Tagging Resources](https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html) in the *Amazon Managed Blockchain Ethereum Developer Guide*, or [Tagging Resources](https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html) in the *Amazon Managed Blockchain Hyperledger Fabric Developer Guide*.
 */
public suspend inline fun ManagedBlockchainClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates a member configuration with new parameters.
 *
 * Applies only to Hyperledger Fabric.
 */
public suspend inline fun ManagedBlockchainClient.updateMember(crossinline block: UpdateMemberRequest.Builder.() -> Unit): UpdateMemberResponse = updateMember(UpdateMemberRequest.Builder().apply(block).build())

/**
 * Updates a node configuration with new parameters.
 *
 * Applies only to Hyperledger Fabric.
 */
public suspend inline fun ManagedBlockchainClient.updateNode(crossinline block: UpdateNodeRequest.Builder.() -> Unit): UpdateNodeResponse = updateNode(UpdateNodeRequest.Builder().apply(block).build())

/**
 * Casts a vote for a specified `ProposalId` on behalf of a member. The member to vote as, specified by `VoterMemberId`, must be in the same Amazon Web Services account as the principal that calls the action.
 *
 * Applies only to Hyperledger Fabric.
 */
public suspend inline fun ManagedBlockchainClient.voteOnProposal(crossinline block: VoteOnProposalRequest.Builder.() -> Unit): VoteOnProposalResponse = voteOnProposal(VoteOnProposalRequest.Builder().apply(block).build())
