// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.managedblockchain.transform

import aws.sdk.kotlin.services.managedblockchain.model.VoteOnProposalRequest
import aws.sdk.kotlin.services.managedblockchain.model.VoteValue
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class VoteOnProposalOperationSerializer: HttpSerialize<VoteOnProposalRequest> {
    override suspend fun serialize(context: ExecutionContext, input: VoteOnProposalRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf<String>(
                "networks",
                "${input.networkId}".encodeLabel(),
                "proposals",
                "${input.proposalId}".encodeLabel(),
                "votes",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeVoteOnProposalOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeVoteOnProposalOperationBody(context: ExecutionContext, input: VoteOnProposalRequest): ByteArray {
    val serializer = JsonSerializer()
    val VOTE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Vote"))
    val VOTERMEMBERID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("VoterMemberId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(VOTE_DESCRIPTOR)
        field(VOTERMEMBERID_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.vote?.let { field(VOTE_DESCRIPTOR, it.value) }
        input.voterMemberId?.let { field(VOTERMEMBERID_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
