// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.managedblockchain.model



/**
 * Configuration properties of the member.
 *
 * Applies only to Hyperledger Fabric.
 */
public class MemberConfiguration private constructor(builder: Builder) {
    /**
     * An optional description of the member.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Configuration properties of the blockchain framework relevant to the member.
     */
    public val frameworkConfiguration: aws.sdk.kotlin.services.managedblockchain.model.MemberFrameworkConfiguration? = builder.frameworkConfiguration
    /**
     * The Amazon Resource Name (ARN) of the customer managed key in Key Management Service (KMS) to use for encryption at rest in the member. This parameter is inherited by any nodes that this member creates. For more information, see [Encryption at Rest](https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/managed-blockchain-encryption-at-rest.html) in the *Amazon Managed Blockchain Hyperledger Fabric Developer Guide*.
     *
     * Use one of the following options to specify this parameter:
     * + **Undefined or empty string** - By default, use an KMS key that is owned and managed by Amazon Web Services on your behalf.
     * + **A valid symmetric customer managed KMS key** - Use the specified KMS key in your account that you create, own, and manage.Amazon Managed Blockchain doesn't support asymmetric keys. For more information, see [Using symmetric and asymmetric keys](https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html) in the *Key Management Service Developer Guide*.The following is an example of a KMS key ARN: `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
     */
    public val kmsKeyArn: kotlin.String? = builder.kmsKeyArn
    /**
     * Configuration properties for logging events associated with a member of a Managed Blockchain network.
     */
    public val logPublishingConfiguration: aws.sdk.kotlin.services.managedblockchain.model.MemberLogPublishingConfiguration? = builder.logPublishingConfiguration
    /**
     * The name of the member.
     */
    public val name: kotlin.String? = builder.name
    /**
     * Tags assigned to the member. Tags consist of a key and optional value.
     *
     * When specifying tags during creation, you can specify multiple key-value pairs in a single request, with an overall maximum of 50 tags added to each resource.
     *
     * For more information about tags, see [Tagging Resources](https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html) in the *Amazon Managed Blockchain Ethereum Developer Guide*, or [Tagging Resources](https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html) in the *Amazon Managed Blockchain Hyperledger Fabric Developer Guide*.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.managedblockchain.model.MemberConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MemberConfiguration(")
        append("description=$description,")
        append("frameworkConfiguration=$frameworkConfiguration,")
        append("kmsKeyArn=$kmsKeyArn,")
        append("logPublishingConfiguration=$logPublishingConfiguration,")
        append("name=$name,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (frameworkConfiguration?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyArn?.hashCode() ?: 0)
        result = 31 * result + (logPublishingConfiguration?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MemberConfiguration

        if (description != other.description) return false
        if (frameworkConfiguration != other.frameworkConfiguration) return false
        if (kmsKeyArn != other.kmsKeyArn) return false
        if (logPublishingConfiguration != other.logPublishingConfiguration) return false
        if (name != other.name) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.managedblockchain.model.MemberConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An optional description of the member.
         */
        public var description: kotlin.String? = null
        /**
         * Configuration properties of the blockchain framework relevant to the member.
         */
        public var frameworkConfiguration: aws.sdk.kotlin.services.managedblockchain.model.MemberFrameworkConfiguration? = null
        /**
         * The Amazon Resource Name (ARN) of the customer managed key in Key Management Service (KMS) to use for encryption at rest in the member. This parameter is inherited by any nodes that this member creates. For more information, see [Encryption at Rest](https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/managed-blockchain-encryption-at-rest.html) in the *Amazon Managed Blockchain Hyperledger Fabric Developer Guide*.
         *
         * Use one of the following options to specify this parameter:
         * + **Undefined or empty string** - By default, use an KMS key that is owned and managed by Amazon Web Services on your behalf.
         * + **A valid symmetric customer managed KMS key** - Use the specified KMS key in your account that you create, own, and manage.Amazon Managed Blockchain doesn't support asymmetric keys. For more information, see [Using symmetric and asymmetric keys](https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html) in the *Key Management Service Developer Guide*.The following is an example of a KMS key ARN: `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
         */
        public var kmsKeyArn: kotlin.String? = null
        /**
         * Configuration properties for logging events associated with a member of a Managed Blockchain network.
         */
        public var logPublishingConfiguration: aws.sdk.kotlin.services.managedblockchain.model.MemberLogPublishingConfiguration? = null
        /**
         * The name of the member.
         */
        public var name: kotlin.String? = null
        /**
         * Tags assigned to the member. Tags consist of a key and optional value.
         *
         * When specifying tags during creation, you can specify multiple key-value pairs in a single request, with an overall maximum of 50 tags added to each resource.
         *
         * For more information about tags, see [Tagging Resources](https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html) in the *Amazon Managed Blockchain Ethereum Developer Guide*, or [Tagging Resources](https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html) in the *Amazon Managed Blockchain Hyperledger Fabric Developer Guide*.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.managedblockchain.model.MemberConfiguration) : this() {
            this.description = x.description
            this.frameworkConfiguration = x.frameworkConfiguration
            this.kmsKeyArn = x.kmsKeyArn
            this.logPublishingConfiguration = x.logPublishingConfiguration
            this.name = x.name
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.managedblockchain.model.MemberConfiguration = MemberConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.managedblockchain.model.MemberFrameworkConfiguration] inside the given [block]
         */
        public fun frameworkConfiguration(block: aws.sdk.kotlin.services.managedblockchain.model.MemberFrameworkConfiguration.Builder.() -> kotlin.Unit) {
            this.frameworkConfiguration = aws.sdk.kotlin.services.managedblockchain.model.MemberFrameworkConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.managedblockchain.model.MemberLogPublishingConfiguration] inside the given [block]
         */
        public fun logPublishingConfiguration(block: aws.sdk.kotlin.services.managedblockchain.model.MemberLogPublishingConfiguration.Builder.() -> kotlin.Unit) {
            this.logPublishingConfiguration = aws.sdk.kotlin.services.managedblockchain.model.MemberLogPublishingConfiguration.invoke(block)
        }
    }
}
