// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.managedblockchain.model



public class CreateProposalRequest private constructor(builder: Builder) {
    /**
     * The type of actions proposed, such as inviting a member or removing a member. The types of `Actions` in a proposal are mutually exclusive. For example, a proposal with `Invitations` actions cannot also contain `Removals` actions.
     */
    public val actions: aws.sdk.kotlin.services.managedblockchain.model.ProposalActions? = builder.actions
    /**
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent operation completes no more than one time. This identifier is required only if you make a service request directly using an HTTP client. It is generated automatically if you use an Amazon Web Services SDK or the CLI.
     */
    public val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * A description for the proposal that is visible to voting members, for example, "Proposal to add Example Corp. as member."
     */
    public val description: kotlin.String? = builder.description
    /**
     * The unique identifier of the member that is creating the proposal. This identifier is especially useful for identifying the member making the proposal when multiple members exist in a single Amazon Web Services account.
     */
    public val memberId: kotlin.String? = builder.memberId
    /**
     * The unique identifier of the network for which the proposal is made.
     */
    public val networkId: kotlin.String? = requireNotNull(builder.networkId) { "A non-null value must be provided for networkId" }
    /**
     * Tags to assign to the proposal. Each tag consists of a key and optional value.
     *
     * When specifying tags during creation, you can specify multiple key-value pairs in a single request, with an overall maximum of 50 tags added to each resource. If the proposal is for a network invitation, the invitation inherits the tags added to the proposal.
     *
     * For more information about tags, see [Tagging Resources](https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html) in the *Amazon Managed Blockchain Ethereum Developer Guide*, or [Tagging Resources](https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html) in the *Amazon Managed Blockchain Hyperledger Fabric Developer Guide*.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.managedblockchain.model.CreateProposalRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateProposalRequest(")
        append("actions=$actions,")
        append("clientRequestToken=$clientRequestToken,")
        append("description=$description,")
        append("memberId=$memberId,")
        append("networkId=$networkId,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = actions?.hashCode() ?: 0
        result = 31 * result + (clientRequestToken?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (memberId?.hashCode() ?: 0)
        result = 31 * result + (networkId?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateProposalRequest

        if (actions != other.actions) return false
        if (clientRequestToken != other.clientRequestToken) return false
        if (description != other.description) return false
        if (memberId != other.memberId) return false
        if (networkId != other.networkId) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.managedblockchain.model.CreateProposalRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The type of actions proposed, such as inviting a member or removing a member. The types of `Actions` in a proposal are mutually exclusive. For example, a proposal with `Invitations` actions cannot also contain `Removals` actions.
         */
        public var actions: aws.sdk.kotlin.services.managedblockchain.model.ProposalActions? = null
        /**
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent operation completes no more than one time. This identifier is required only if you make a service request directly using an HTTP client. It is generated automatically if you use an Amazon Web Services SDK or the CLI.
         */
        public var clientRequestToken: kotlin.String? = null
        /**
         * A description for the proposal that is visible to voting members, for example, "Proposal to add Example Corp. as member."
         */
        public var description: kotlin.String? = null
        /**
         * The unique identifier of the member that is creating the proposal. This identifier is especially useful for identifying the member making the proposal when multiple members exist in a single Amazon Web Services account.
         */
        public var memberId: kotlin.String? = null
        /**
         * The unique identifier of the network for which the proposal is made.
         */
        public var networkId: kotlin.String? = null
        /**
         * Tags to assign to the proposal. Each tag consists of a key and optional value.
         *
         * When specifying tags during creation, you can specify multiple key-value pairs in a single request, with an overall maximum of 50 tags added to each resource. If the proposal is for a network invitation, the invitation inherits the tags added to the proposal.
         *
         * For more information about tags, see [Tagging Resources](https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html) in the *Amazon Managed Blockchain Ethereum Developer Guide*, or [Tagging Resources](https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html) in the *Amazon Managed Blockchain Hyperledger Fabric Developer Guide*.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.managedblockchain.model.CreateProposalRequest) : this() {
            this.actions = x.actions
            this.clientRequestToken = x.clientRequestToken
            this.description = x.description
            this.memberId = x.memberId
            this.networkId = x.networkId
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.managedblockchain.model.CreateProposalRequest = CreateProposalRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.managedblockchain.model.ProposalActions] inside the given [block]
         */
        public fun actions(block: aws.sdk.kotlin.services.managedblockchain.model.ProposalActions.Builder.() -> kotlin.Unit) {
            this.actions = aws.sdk.kotlin.services.managedblockchain.model.ProposalActions.invoke(block)
        }
    }
}
