// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.managedblockchain.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The token based access feature is in preview release for Ethereum on Amazon Managed Blockchain and is subject to change. We recommend that you use this feature only with test scenarios, and not in production environments.
 *
 * The properties of the Accessor.
 */
public class Accessor private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the accessor. For more information about ARNs and their format, see [Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference*.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The billing token is a property of the accessor. Use this token to make Ethereum API calls to your Ethereum node. The billing token is used to track your accessor object for billing Ethereum API requests made to your Ethereum nodes.
     */
    public val billingToken: kotlin.String? = builder.billingToken
    /**
     * The creation date and time of the accessor.
     */
    public val creationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDate
    /**
     * The unique identifier of the accessor.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The current status of the accessor.
     */
    public val status: aws.sdk.kotlin.services.managedblockchain.model.AccessorStatus? = builder.status
    /**
     * The type of the accessor.
     *
     * Currently accessor type is restricted to `BILLING_TOKEN`.
     */
    public val type: aws.sdk.kotlin.services.managedblockchain.model.AccessorType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.managedblockchain.model.Accessor = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Accessor(")
        append("arn=$arn,")
        append("billingToken=$billingToken,")
        append("creationDate=$creationDate,")
        append("id=$id,")
        append("status=$status,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (billingToken?.hashCode() ?: 0)
        result = 31 * result + (creationDate?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Accessor

        if (arn != other.arn) return false
        if (billingToken != other.billingToken) return false
        if (creationDate != other.creationDate) return false
        if (id != other.id) return false
        if (status != other.status) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.managedblockchain.model.Accessor = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the accessor. For more information about ARNs and their format, see [Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference*.
         */
        public var arn: kotlin.String? = null
        /**
         * The billing token is a property of the accessor. Use this token to make Ethereum API calls to your Ethereum node. The billing token is used to track your accessor object for billing Ethereum API requests made to your Ethereum nodes.
         */
        public var billingToken: kotlin.String? = null
        /**
         * The creation date and time of the accessor.
         */
        public var creationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The unique identifier of the accessor.
         */
        public var id: kotlin.String? = null
        /**
         * The current status of the accessor.
         */
        public var status: aws.sdk.kotlin.services.managedblockchain.model.AccessorStatus? = null
        /**
         * The type of the accessor.
         *
         * Currently accessor type is restricted to `BILLING_TOKEN`.
         */
        public var type: aws.sdk.kotlin.services.managedblockchain.model.AccessorType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.managedblockchain.model.Accessor) : this() {
            this.arn = x.arn
            this.billingToken = x.billingToken
            this.creationDate = x.creationDate
            this.id = x.id
            this.status = x.status
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.managedblockchain.model.Accessor = Accessor(this)
    }
}
