// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mailmanager.serde

import aws.sdk.kotlin.services.mailmanager.model.ArchiveFilters
import aws.sdk.kotlin.services.mailmanager.model.GetArchiveSearchResponse
import aws.sdk.kotlin.services.mailmanager.model.MailManagerException
import aws.sdk.kotlin.services.mailmanager.model.SearchStatus
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class GetArchiveSearchOperationDeserializer: HttpDeserializer.NonStreaming<GetArchiveSearchResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetArchiveSearchResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetArchiveSearchError(context, call, payload)
        }
        val builder = GetArchiveSearchResponse.Builder()

        if (payload != null) {
            deserializeGetArchiveSearchOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetArchiveSearchError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw MailManagerException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> MailManagerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetArchiveSearchOperationBody(builder: GetArchiveSearchResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ARCHIVEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ArchiveId"))
    val FILTERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Filters"))
    val FROMTIMESTAMP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("FromTimestamp"))
    val MAXRESULTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("MaxResults"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Status"))
    val TOTIMESTAMP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("ToTimestamp"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ARCHIVEID_DESCRIPTOR)
        field(FILTERS_DESCRIPTOR)
        field(FROMTIMESTAMP_DESCRIPTOR)
        field(MAXRESULTS_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(TOTIMESTAMP_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ARCHIVEID_DESCRIPTOR.index -> builder.archiveId = deserializeString()
                FILTERS_DESCRIPTOR.index -> builder.filters = deserializeArchiveFiltersDocument(deserializer)
                FROMTIMESTAMP_DESCRIPTOR.index -> builder.fromTimestamp = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                MAXRESULTS_DESCRIPTOR.index -> builder.maxResults = deserializeInt()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeSearchStatusDocument(deserializer)
                TOTIMESTAMP_DESCRIPTOR.index -> builder.toTimestamp = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
