// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mailmanager.serde

import aws.sdk.kotlin.services.mailmanager.model.ArchiveRetention
import aws.sdk.kotlin.services.mailmanager.model.ArchiveState
import aws.sdk.kotlin.services.mailmanager.model.GetArchiveResponse
import aws.sdk.kotlin.services.mailmanager.model.MailManagerException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class GetArchiveOperationDeserializer: HttpDeserializer.NonStreaming<GetArchiveResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetArchiveResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetArchiveError(context, call, payload)
        }
        val builder = GetArchiveResponse.Builder()

        if (payload != null) {
            deserializeGetArchiveOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetArchiveError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw MailManagerException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> MailManagerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetArchiveOperationBody(builder: GetArchiveResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ARCHIVEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ArchiveArn"))
    val ARCHIVEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ArchiveId"))
    val ARCHIVENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ArchiveName"))
    val ARCHIVESTATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("ArchiveState"))
    val CREATEDTIMESTAMP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreatedTimestamp"))
    val KMSKEYARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("KmsKeyArn"))
    val LASTUPDATEDTIMESTAMP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastUpdatedTimestamp"))
    val RETENTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Retention"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ARCHIVEARN_DESCRIPTOR)
        field(ARCHIVEID_DESCRIPTOR)
        field(ARCHIVENAME_DESCRIPTOR)
        field(ARCHIVESTATE_DESCRIPTOR)
        field(CREATEDTIMESTAMP_DESCRIPTOR)
        field(KMSKEYARN_DESCRIPTOR)
        field(LASTUPDATEDTIMESTAMP_DESCRIPTOR)
        field(RETENTION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ARCHIVEARN_DESCRIPTOR.index -> builder.archiveArn = deserializeString()
                ARCHIVEID_DESCRIPTOR.index -> builder.archiveId = deserializeString()
                ARCHIVENAME_DESCRIPTOR.index -> builder.archiveName = deserializeString()
                ARCHIVESTATE_DESCRIPTOR.index -> builder.archiveState = deserializeString().let { ArchiveState.fromValue(it) }
                CREATEDTIMESTAMP_DESCRIPTOR.index -> builder.createdTimestamp = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                KMSKEYARN_DESCRIPTOR.index -> builder.kmsKeyArn = deserializeString()
                LASTUPDATEDTIMESTAMP_DESCRIPTOR.index -> builder.lastUpdatedTimestamp = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                RETENTION_DESCRIPTOR.index -> builder.retention = deserializeArchiveRetentionDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
