// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mailmanager.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * The request to initiate an export of emails from an archive.
 */
public class StartArchiveExportRequest private constructor(builder: Builder) {
    /**
     * The identifier of the archive to export emails from.
     */
    public val archiveId: kotlin.String? = builder.archiveId
    /**
     * Details on where to deliver the exported email data.
     */
    public val exportDestinationConfiguration: aws.sdk.kotlin.services.mailmanager.model.ExportDestinationConfiguration? = builder.exportDestinationConfiguration
    /**
     * Criteria to filter which emails are included in the export.
     */
    public val filters: aws.sdk.kotlin.services.mailmanager.model.ArchiveFilters? = builder.filters
    /**
     * The start of the timestamp range to include emails from.
     */
    public val fromTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.fromTimestamp
    /**
     * Whether to include message metadata as JSON files in the export.
     */
    public val includeMetadata: kotlin.Boolean? = builder.includeMetadata
    /**
     * The maximum number of email items to include in the export.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The end of the timestamp range to include emails from.
     */
    public val toTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.toTimestamp

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mailmanager.model.StartArchiveExportRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartArchiveExportRequest(")
        append("archiveId=$archiveId,")
        append("exportDestinationConfiguration=$exportDestinationConfiguration,")
        append("filters=$filters,")
        append("fromTimestamp=$fromTimestamp,")
        append("includeMetadata=$includeMetadata,")
        append("maxResults=$maxResults,")
        append("toTimestamp=$toTimestamp")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = archiveId?.hashCode() ?: 0
        result = 31 * result + (exportDestinationConfiguration?.hashCode() ?: 0)
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (fromTimestamp?.hashCode() ?: 0)
        result = 31 * result + (includeMetadata?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (toTimestamp?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartArchiveExportRequest

        if (archiveId != other.archiveId) return false
        if (exportDestinationConfiguration != other.exportDestinationConfiguration) return false
        if (filters != other.filters) return false
        if (fromTimestamp != other.fromTimestamp) return false
        if (includeMetadata != other.includeMetadata) return false
        if (maxResults != other.maxResults) return false
        if (toTimestamp != other.toTimestamp) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mailmanager.model.StartArchiveExportRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The identifier of the archive to export emails from.
         */
        public var archiveId: kotlin.String? = null
        /**
         * Details on where to deliver the exported email data.
         */
        public var exportDestinationConfiguration: aws.sdk.kotlin.services.mailmanager.model.ExportDestinationConfiguration? = null
        /**
         * Criteria to filter which emails are included in the export.
         */
        public var filters: aws.sdk.kotlin.services.mailmanager.model.ArchiveFilters? = null
        /**
         * The start of the timestamp range to include emails from.
         */
        public var fromTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Whether to include message metadata as JSON files in the export.
         */
        public var includeMetadata: kotlin.Boolean? = null
        /**
         * The maximum number of email items to include in the export.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The end of the timestamp range to include emails from.
         */
        public var toTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mailmanager.model.StartArchiveExportRequest) : this() {
            this.archiveId = x.archiveId
            this.exportDestinationConfiguration = x.exportDestinationConfiguration
            this.filters = x.filters
            this.fromTimestamp = x.fromTimestamp
            this.includeMetadata = x.includeMetadata
            this.maxResults = x.maxResults
            this.toTimestamp = x.toTimestamp
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mailmanager.model.StartArchiveExportRequest = StartArchiveExportRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.mailmanager.model.ArchiveFilters] inside the given [block]
         */
        public fun filters(block: aws.sdk.kotlin.services.mailmanager.model.ArchiveFilters.Builder.() -> kotlin.Unit) {
            this.filters = aws.sdk.kotlin.services.mailmanager.model.ArchiveFilters.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
