// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mailmanager.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * A result row containing metadata for an archived email message.
 */
public class Row private constructor(builder: Builder) {
    /**
     * The unique identifier of the archived message.
     */
    public val archivedMessageId: kotlin.String? = builder.archivedMessageId
    /**
     * The email addresses in the CC header.
     */
    public val cc: kotlin.String? = builder.cc
    /**
     * The date the email was sent.
     */
    public val date: kotlin.String? = builder.date
    /**
     * The SMTP envelope information of the email.
     */
    public val envelope: aws.sdk.kotlin.services.mailmanager.model.Envelope? = builder.envelope
    /**
     * The email address of the sender.
     */
    public val from: kotlin.String? = builder.from
    /**
     * A flag indicating if the email has attachments.
     */
    public val hasAttachments: kotlin.Boolean? = builder.hasAttachments
    /**
     * The email message ID this is a reply to.
     */
    public val inReplyTo: kotlin.String? = builder.inReplyTo
    /**
     * The ID of the ingress endpoint through which the email was received.
     */
    public val ingressPointId: kotlin.String? = builder.ingressPointId
    /**
     * The unique message ID of the email.
     */
    public val messageId: kotlin.String? = builder.messageId
    /**
     * The received headers from the email delivery path.
     */
    public val receivedHeaders: List<String>? = builder.receivedHeaders
    /**
     * The timestamp of when the email was received.
     */
    public val receivedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.receivedTimestamp
    /**
     * The name of the host from which the email was received.
     */
    public val senderHostname: kotlin.String? = builder.senderHostname
    /**
     * + Mail archived with Mail Manager: The IP address of the client that connects to the ingress endpoint.
     * + Mail sent through a configuration set with the archiving option enabled: The IP address of the client that makes the SendEmail API call.
     */
    public val senderIpAddress: kotlin.String? = builder.senderIpAddress
    /**
     * Specifies the archived email source, identified by either a Rule Set's ARN with an Archive action, or a Configuration Set's Archive ARN.
     */
    public val sourceArn: kotlin.String? = builder.sourceArn
    /**
     * The subject header value of the email.
     */
    public val subject: kotlin.String? = builder.subject
    /**
     * The email addresses in the To header.
     */
    public val to: kotlin.String? = builder.to
    /**
     * The user agent that sent the email.
     */
    public val xMailer: kotlin.String? = builder.xMailer
    /**
     * The original user agent that sent the email.
     */
    public val xOriginalMailer: kotlin.String? = builder.xOriginalMailer
    /**
     * The priority level of the email.
     */
    public val xPriority: kotlin.String? = builder.xPriority

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mailmanager.model.Row = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Row(")
        append("archivedMessageId=$archivedMessageId,")
        append("cc=$cc,")
        append("date=$date,")
        append("envelope=$envelope,")
        append("from=$from,")
        append("hasAttachments=$hasAttachments,")
        append("inReplyTo=$inReplyTo,")
        append("ingressPointId=$ingressPointId,")
        append("messageId=$messageId,")
        append("receivedHeaders=$receivedHeaders,")
        append("receivedTimestamp=$receivedTimestamp,")
        append("senderHostname=$senderHostname,")
        append("senderIpAddress=*** Sensitive Data Redacted ***,")
        append("sourceArn=$sourceArn,")
        append("subject=$subject,")
        append("to=$to,")
        append("xMailer=$xMailer,")
        append("xOriginalMailer=$xOriginalMailer,")
        append("xPriority=$xPriority")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = archivedMessageId?.hashCode() ?: 0
        result = 31 * result + (cc?.hashCode() ?: 0)
        result = 31 * result + (date?.hashCode() ?: 0)
        result = 31 * result + (envelope?.hashCode() ?: 0)
        result = 31 * result + (from?.hashCode() ?: 0)
        result = 31 * result + (hasAttachments?.hashCode() ?: 0)
        result = 31 * result + (inReplyTo?.hashCode() ?: 0)
        result = 31 * result + (ingressPointId?.hashCode() ?: 0)
        result = 31 * result + (messageId?.hashCode() ?: 0)
        result = 31 * result + (receivedHeaders?.hashCode() ?: 0)
        result = 31 * result + (receivedTimestamp?.hashCode() ?: 0)
        result = 31 * result + (senderHostname?.hashCode() ?: 0)
        result = 31 * result + (senderIpAddress?.hashCode() ?: 0)
        result = 31 * result + (sourceArn?.hashCode() ?: 0)
        result = 31 * result + (subject?.hashCode() ?: 0)
        result = 31 * result + (to?.hashCode() ?: 0)
        result = 31 * result + (xMailer?.hashCode() ?: 0)
        result = 31 * result + (xOriginalMailer?.hashCode() ?: 0)
        result = 31 * result + (xPriority?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Row

        if (archivedMessageId != other.archivedMessageId) return false
        if (cc != other.cc) return false
        if (date != other.date) return false
        if (envelope != other.envelope) return false
        if (from != other.from) return false
        if (hasAttachments != other.hasAttachments) return false
        if (inReplyTo != other.inReplyTo) return false
        if (ingressPointId != other.ingressPointId) return false
        if (messageId != other.messageId) return false
        if (receivedHeaders != other.receivedHeaders) return false
        if (receivedTimestamp != other.receivedTimestamp) return false
        if (senderHostname != other.senderHostname) return false
        if (senderIpAddress != other.senderIpAddress) return false
        if (sourceArn != other.sourceArn) return false
        if (subject != other.subject) return false
        if (to != other.to) return false
        if (xMailer != other.xMailer) return false
        if (xOriginalMailer != other.xOriginalMailer) return false
        if (xPriority != other.xPriority) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mailmanager.model.Row = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The unique identifier of the archived message.
         */
        public var archivedMessageId: kotlin.String? = null
        /**
         * The email addresses in the CC header.
         */
        public var cc: kotlin.String? = null
        /**
         * The date the email was sent.
         */
        public var date: kotlin.String? = null
        /**
         * The SMTP envelope information of the email.
         */
        public var envelope: aws.sdk.kotlin.services.mailmanager.model.Envelope? = null
        /**
         * The email address of the sender.
         */
        public var from: kotlin.String? = null
        /**
         * A flag indicating if the email has attachments.
         */
        public var hasAttachments: kotlin.Boolean? = null
        /**
         * The email message ID this is a reply to.
         */
        public var inReplyTo: kotlin.String? = null
        /**
         * The ID of the ingress endpoint through which the email was received.
         */
        public var ingressPointId: kotlin.String? = null
        /**
         * The unique message ID of the email.
         */
        public var messageId: kotlin.String? = null
        /**
         * The received headers from the email delivery path.
         */
        public var receivedHeaders: List<String>? = null
        /**
         * The timestamp of when the email was received.
         */
        public var receivedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the host from which the email was received.
         */
        public var senderHostname: kotlin.String? = null
        /**
         * + Mail archived with Mail Manager: The IP address of the client that connects to the ingress endpoint.
         * + Mail sent through a configuration set with the archiving option enabled: The IP address of the client that makes the SendEmail API call.
         */
        public var senderIpAddress: kotlin.String? = null
        /**
         * Specifies the archived email source, identified by either a Rule Set's ARN with an Archive action, or a Configuration Set's Archive ARN.
         */
        public var sourceArn: kotlin.String? = null
        /**
         * The subject header value of the email.
         */
        public var subject: kotlin.String? = null
        /**
         * The email addresses in the To header.
         */
        public var to: kotlin.String? = null
        /**
         * The user agent that sent the email.
         */
        public var xMailer: kotlin.String? = null
        /**
         * The original user agent that sent the email.
         */
        public var xOriginalMailer: kotlin.String? = null
        /**
         * The priority level of the email.
         */
        public var xPriority: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mailmanager.model.Row) : this() {
            this.archivedMessageId = x.archivedMessageId
            this.cc = x.cc
            this.date = x.date
            this.envelope = x.envelope
            this.from = x.from
            this.hasAttachments = x.hasAttachments
            this.inReplyTo = x.inReplyTo
            this.ingressPointId = x.ingressPointId
            this.messageId = x.messageId
            this.receivedHeaders = x.receivedHeaders
            this.receivedTimestamp = x.receivedTimestamp
            this.senderHostname = x.senderHostname
            this.senderIpAddress = x.senderIpAddress
            this.sourceArn = x.sourceArn
            this.subject = x.subject
            this.to = x.to
            this.xMailer = x.xMailer
            this.xOriginalMailer = x.xOriginalMailer
            this.xPriority = x.xPriority
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mailmanager.model.Row = Row(this)

        /**
         * construct an [aws.sdk.kotlin.services.mailmanager.model.Envelope] inside the given [block]
         */
        public fun envelope(block: aws.sdk.kotlin.services.mailmanager.model.Envelope.Builder.() -> kotlin.Unit) {
            this.envelope = aws.sdk.kotlin.services.mailmanager.model.Envelope.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
