// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mailmanager.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The action to deliver incoming emails to an Amazon Q Business application for indexing.
 */
public class DeliverToQBusinessAction private constructor(builder: Builder) {
    /**
     * A policy that states what to do in the case of failure. The action will fail if there are configuration errors. For example, the specified application has been deleted or the role lacks necessary permissions to call the `qbusiness:BatchPutDocument` API.
     */
    public val actionFailurePolicy: aws.sdk.kotlin.services.mailmanager.model.ActionFailurePolicy? = builder.actionFailurePolicy
    /**
     * The unique identifier of the Amazon Q Business application instance where the email content will be delivered.
     */
    public val applicationId: kotlin.String = requireNotNull(builder.applicationId) { "A non-null value must be provided for applicationId" }
    /**
     * The identifier of the knowledge base index within the Amazon Q Business application where the email content will be stored and indexed.
     */
    public val indexId: kotlin.String = requireNotNull(builder.indexId) { "A non-null value must be provided for indexId" }
    /**
     * The Amazon Resource Name (ARN) of the IAM Role to use while delivering to Amazon Q Business. This role must have access to the `qbusiness:BatchPutDocument` API for the given application and index.
     */
    public val roleArn: kotlin.String = requireNotNull(builder.roleArn) { "A non-null value must be provided for roleArn" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mailmanager.model.DeliverToQBusinessAction = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeliverToQBusinessAction(")
        append("actionFailurePolicy=$actionFailurePolicy,")
        append("applicationId=$applicationId,")
        append("indexId=$indexId,")
        append("roleArn=$roleArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = actionFailurePolicy?.hashCode() ?: 0
        result = 31 * result + (applicationId.hashCode())
        result = 31 * result + (indexId.hashCode())
        result = 31 * result + (roleArn.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeliverToQBusinessAction

        if (actionFailurePolicy != other.actionFailurePolicy) return false
        if (applicationId != other.applicationId) return false
        if (indexId != other.indexId) return false
        if (roleArn != other.roleArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mailmanager.model.DeliverToQBusinessAction = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A policy that states what to do in the case of failure. The action will fail if there are configuration errors. For example, the specified application has been deleted or the role lacks necessary permissions to call the `qbusiness:BatchPutDocument` API.
         */
        public var actionFailurePolicy: aws.sdk.kotlin.services.mailmanager.model.ActionFailurePolicy? = null
        /**
         * The unique identifier of the Amazon Q Business application instance where the email content will be delivered.
         */
        public var applicationId: kotlin.String? = null
        /**
         * The identifier of the knowledge base index within the Amazon Q Business application where the email content will be stored and indexed.
         */
        public var indexId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM Role to use while delivering to Amazon Q Business. This role must have access to the `qbusiness:BatchPutDocument` API for the given application and index.
         */
        public var roleArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mailmanager.model.DeliverToQBusinessAction) : this() {
            this.actionFailurePolicy = x.actionFailurePolicy
            this.applicationId = x.applicationId
            this.indexId = x.indexId
            this.roleArn = x.roleArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mailmanager.model.DeliverToQBusinessAction = DeliverToQBusinessAction(this)

        internal fun correctErrors(): Builder {
            if (applicationId == null) applicationId = ""
            if (indexId == null) indexId = ""
            if (roleArn == null) roleArn = ""
            return this
        }
    }
}
