// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mailmanager.serde

import aws.sdk.kotlin.services.mailmanager.model.ArchiveFilters
import aws.sdk.kotlin.services.mailmanager.model.StartArchiveSearchRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class StartArchiveSearchOperationSerializer: HttpSerializer.NonStreaming<StartArchiveSearchRequest> {
    override fun serialize(context: ExecutionContext, input: StartArchiveSearchRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/"
        }

        val payload = serializeStartArchiveSearchOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-amz-json-1.0")
        }
        return builder
    }
}

private fun serializeStartArchiveSearchOperationBody(context: ExecutionContext, input: StartArchiveSearchRequest): ByteArray {
    val serializer = JsonSerializer()
    val ARCHIVEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ArchiveId"))
    val FILTERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Filters"))
    val FROMTIMESTAMP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("FromTimestamp"))
    val MAXRESULTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("MaxResults"))
    val TOTIMESTAMP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("ToTimestamp"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ARCHIVEID_DESCRIPTOR)
        field(FILTERS_DESCRIPTOR)
        field(FROMTIMESTAMP_DESCRIPTOR)
        field(MAXRESULTS_DESCRIPTOR)
        field(TOTIMESTAMP_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.archiveId?.let { field(ARCHIVEID_DESCRIPTOR, it) }
        input.filters?.let { field(FILTERS_DESCRIPTOR, it, ::serializeArchiveFiltersDocument) }
        input.fromTimestamp?.let { field(FROMTIMESTAMP_DESCRIPTOR, it, TimestampFormat.EPOCH_SECONDS) }
        input.maxResults?.let { field(MAXRESULTS_DESCRIPTOR, it) }
        input.toTimestamp?.let { field(TOTIMESTAMP_DESCRIPTOR, it, TimestampFormat.EPOCH_SECONDS) }
    }
    return serializer.toByteArray()
}
