// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mailmanager.serde

import aws.sdk.kotlin.services.mailmanager.model.AcceptAction
import aws.sdk.kotlin.services.mailmanager.model.GetTrafficPolicyResponse
import aws.sdk.kotlin.services.mailmanager.model.MailManagerException
import aws.sdk.kotlin.services.mailmanager.model.PolicyStatement
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableListOf


internal class GetTrafficPolicyOperationDeserializer: HttpDeserializer.NonStreaming<GetTrafficPolicyResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetTrafficPolicyResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetTrafficPolicyError(context, call, payload)
        }
        val builder = GetTrafficPolicyResponse.Builder()

        if (payload != null) {
            deserializeGetTrafficPolicyOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetTrafficPolicyError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw MailManagerException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> MailManagerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetTrafficPolicyOperationBody(builder: GetTrafficPolicyResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATEDTIMESTAMP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreatedTimestamp"))
    val DEFAULTACTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("DefaultAction"))
    val LASTUPDATEDTIMESTAMP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastUpdatedTimestamp"))
    val MAXMESSAGESIZEBYTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("MaxMessageSizeBytes"))
    val POLICYSTATEMENTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("PolicyStatements"))
    val TRAFFICPOLICYARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TrafficPolicyArn"))
    val TRAFFICPOLICYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TrafficPolicyId"))
    val TRAFFICPOLICYNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TrafficPolicyName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATEDTIMESTAMP_DESCRIPTOR)
        field(DEFAULTACTION_DESCRIPTOR)
        field(LASTUPDATEDTIMESTAMP_DESCRIPTOR)
        field(MAXMESSAGESIZEBYTES_DESCRIPTOR)
        field(POLICYSTATEMENTS_DESCRIPTOR)
        field(TRAFFICPOLICYARN_DESCRIPTOR)
        field(TRAFFICPOLICYID_DESCRIPTOR)
        field(TRAFFICPOLICYNAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATEDTIMESTAMP_DESCRIPTOR.index -> builder.createdTimestamp = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                DEFAULTACTION_DESCRIPTOR.index -> builder.defaultAction = deserializeString().let { AcceptAction.fromValue(it) }
                LASTUPDATEDTIMESTAMP_DESCRIPTOR.index -> builder.lastUpdatedTimestamp = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                MAXMESSAGESIZEBYTES_DESCRIPTOR.index -> builder.maxMessageSizeBytes = deserializeInt()
                POLICYSTATEMENTS_DESCRIPTOR.index -> builder.policyStatements =
                    deserializer.deserializeList(POLICYSTATEMENTS_DESCRIPTOR) {
                        val col0 = mutableListOf<PolicyStatement>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializePolicyStatementDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                TRAFFICPOLICYARN_DESCRIPTOR.index -> builder.trafficPolicyArn = deserializeString()
                TRAFFICPOLICYID_DESCRIPTOR.index -> builder.trafficPolicyId = deserializeString()
                TRAFFICPOLICYNAME_DESCRIPTOR.index -> builder.trafficPolicyName = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
