// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mailmanager.paginators

import aws.sdk.kotlin.services.mailmanager.MailManagerClient
import aws.sdk.kotlin.services.mailmanager.model.AddonInstance
import aws.sdk.kotlin.services.mailmanager.model.AddonSubscription
import aws.sdk.kotlin.services.mailmanager.model.AddressList
import aws.sdk.kotlin.services.mailmanager.model.Archive
import aws.sdk.kotlin.services.mailmanager.model.ExportSummary
import aws.sdk.kotlin.services.mailmanager.model.ImportJob
import aws.sdk.kotlin.services.mailmanager.model.IngressPoint
import aws.sdk.kotlin.services.mailmanager.model.ListAddonInstancesRequest
import aws.sdk.kotlin.services.mailmanager.model.ListAddonInstancesResponse
import aws.sdk.kotlin.services.mailmanager.model.ListAddonSubscriptionsRequest
import aws.sdk.kotlin.services.mailmanager.model.ListAddonSubscriptionsResponse
import aws.sdk.kotlin.services.mailmanager.model.ListAddressListImportJobsRequest
import aws.sdk.kotlin.services.mailmanager.model.ListAddressListImportJobsResponse
import aws.sdk.kotlin.services.mailmanager.model.ListAddressListsRequest
import aws.sdk.kotlin.services.mailmanager.model.ListAddressListsResponse
import aws.sdk.kotlin.services.mailmanager.model.ListArchiveExportsRequest
import aws.sdk.kotlin.services.mailmanager.model.ListArchiveExportsResponse
import aws.sdk.kotlin.services.mailmanager.model.ListArchiveSearchesRequest
import aws.sdk.kotlin.services.mailmanager.model.ListArchiveSearchesResponse
import aws.sdk.kotlin.services.mailmanager.model.ListArchivesRequest
import aws.sdk.kotlin.services.mailmanager.model.ListArchivesResponse
import aws.sdk.kotlin.services.mailmanager.model.ListIngressPointsRequest
import aws.sdk.kotlin.services.mailmanager.model.ListIngressPointsResponse
import aws.sdk.kotlin.services.mailmanager.model.ListMembersOfAddressListRequest
import aws.sdk.kotlin.services.mailmanager.model.ListMembersOfAddressListResponse
import aws.sdk.kotlin.services.mailmanager.model.ListRelaysRequest
import aws.sdk.kotlin.services.mailmanager.model.ListRelaysResponse
import aws.sdk.kotlin.services.mailmanager.model.ListRuleSetsRequest
import aws.sdk.kotlin.services.mailmanager.model.ListRuleSetsResponse
import aws.sdk.kotlin.services.mailmanager.model.ListTrafficPoliciesRequest
import aws.sdk.kotlin.services.mailmanager.model.ListTrafficPoliciesResponse
import aws.sdk.kotlin.services.mailmanager.model.Relay
import aws.sdk.kotlin.services.mailmanager.model.RuleSet
import aws.sdk.kotlin.services.mailmanager.model.SavedAddress
import aws.sdk.kotlin.services.mailmanager.model.SearchSummary
import aws.sdk.kotlin.services.mailmanager.model.TrafficPolicy
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListAddonInstancesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAddonInstancesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAddonInstancesResponse]
 */
public fun MailManagerClient.listAddonInstancesPaginated(initialRequest: ListAddonInstancesRequest = ListAddonInstancesRequest { }): Flow<ListAddonInstancesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAddonInstancesPaginated.listAddonInstances(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListAddonInstancesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAddonInstancesResponse]
 */
public fun MailManagerClient.listAddonInstancesPaginated(block: ListAddonInstancesRequest.Builder.() -> Unit): Flow<ListAddonInstancesResponse> =
    listAddonInstancesPaginated(ListAddonInstancesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listAddonInstancesPaginated]
 * to access the nested member [AddonInstance]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AddonInstance]
 */
@JvmName("listAddonInstancesResponseAddonInstance")
public fun Flow<ListAddonInstancesResponse>.addonInstances(): Flow<AddonInstance> =
    transform() { response ->
        response.addonInstances?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListAddonSubscriptionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAddonSubscriptionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAddonSubscriptionsResponse]
 */
public fun MailManagerClient.listAddonSubscriptionsPaginated(initialRequest: ListAddonSubscriptionsRequest = ListAddonSubscriptionsRequest { }): Flow<ListAddonSubscriptionsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAddonSubscriptionsPaginated.listAddonSubscriptions(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListAddonSubscriptionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAddonSubscriptionsResponse]
 */
public fun MailManagerClient.listAddonSubscriptionsPaginated(block: ListAddonSubscriptionsRequest.Builder.() -> Unit): Flow<ListAddonSubscriptionsResponse> =
    listAddonSubscriptionsPaginated(ListAddonSubscriptionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listAddonSubscriptionsPaginated]
 * to access the nested member [AddonSubscription]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AddonSubscription]
 */
@JvmName("listAddonSubscriptionsResponseAddonSubscription")
public fun Flow<ListAddonSubscriptionsResponse>.addonSubscriptions(): Flow<AddonSubscription> =
    transform() { response ->
        response.addonSubscriptions?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListAddressListImportJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAddressListImportJobsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAddressListImportJobsResponse]
 */
public fun MailManagerClient.listAddressListImportJobsPaginated(initialRequest: ListAddressListImportJobsRequest): Flow<ListAddressListImportJobsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAddressListImportJobsPaginated.listAddressListImportJobs(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListAddressListImportJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAddressListImportJobsResponse]
 */
public fun MailManagerClient.listAddressListImportJobsPaginated(block: ListAddressListImportJobsRequest.Builder.() -> Unit): Flow<ListAddressListImportJobsResponse> =
    listAddressListImportJobsPaginated(ListAddressListImportJobsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listAddressListImportJobsPaginated]
 * to access the nested member [ImportJob]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ImportJob]
 */
@JvmName("listAddressListImportJobsResponseImportJob")
public fun Flow<ListAddressListImportJobsResponse>.importJobs(): Flow<ImportJob> =
    transform() { response ->
        response.importJobs?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListAddressListsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAddressListsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAddressListsResponse]
 */
public fun MailManagerClient.listAddressListsPaginated(initialRequest: ListAddressListsRequest = ListAddressListsRequest { }): Flow<ListAddressListsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAddressListsPaginated.listAddressLists(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListAddressListsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAddressListsResponse]
 */
public fun MailManagerClient.listAddressListsPaginated(block: ListAddressListsRequest.Builder.() -> Unit): Flow<ListAddressListsResponse> =
    listAddressListsPaginated(ListAddressListsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listAddressListsPaginated]
 * to access the nested member [AddressList]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AddressList]
 */
@JvmName("listAddressListsResponseAddressList")
public fun Flow<ListAddressListsResponse>.addressLists(): Flow<AddressList> =
    transform() { response ->
        response.addressLists?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListArchiveExportsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListArchiveExportsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListArchiveExportsResponse]
 */
public fun MailManagerClient.listArchiveExportsPaginated(initialRequest: ListArchiveExportsRequest): Flow<ListArchiveExportsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listArchiveExportsPaginated.listArchiveExports(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListArchiveExportsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListArchiveExportsResponse]
 */
public fun MailManagerClient.listArchiveExportsPaginated(block: ListArchiveExportsRequest.Builder.() -> Unit): Flow<ListArchiveExportsResponse> =
    listArchiveExportsPaginated(ListArchiveExportsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listArchiveExportsPaginated]
 * to access the nested member [ExportSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ExportSummary]
 */
@JvmName("listArchiveExportsResponseExportSummary")
public fun Flow<ListArchiveExportsResponse>.exports(): Flow<ExportSummary> =
    transform() { response ->
        response.exports?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListArchivesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListArchivesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListArchivesResponse]
 */
public fun MailManagerClient.listArchivesPaginated(initialRequest: ListArchivesRequest = ListArchivesRequest { }): Flow<ListArchivesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listArchivesPaginated.listArchives(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListArchivesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListArchivesResponse]
 */
public fun MailManagerClient.listArchivesPaginated(block: ListArchivesRequest.Builder.() -> Unit): Flow<ListArchivesResponse> =
    listArchivesPaginated(ListArchivesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listArchivesPaginated]
 * to access the nested member [Archive]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Archive]
 */
@JvmName("listArchivesResponseArchive")
public fun Flow<ListArchivesResponse>.archives(): Flow<Archive> =
    transform() { response ->
        response.archives?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListArchiveSearchesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListArchiveSearchesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListArchiveSearchesResponse]
 */
public fun MailManagerClient.listArchiveSearchesPaginated(initialRequest: ListArchiveSearchesRequest): Flow<ListArchiveSearchesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listArchiveSearchesPaginated.listArchiveSearches(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListArchiveSearchesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListArchiveSearchesResponse]
 */
public fun MailManagerClient.listArchiveSearchesPaginated(block: ListArchiveSearchesRequest.Builder.() -> Unit): Flow<ListArchiveSearchesResponse> =
    listArchiveSearchesPaginated(ListArchiveSearchesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listArchiveSearchesPaginated]
 * to access the nested member [SearchSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SearchSummary]
 */
@JvmName("listArchiveSearchesResponseSearchSummary")
public fun Flow<ListArchiveSearchesResponse>.searches(): Flow<SearchSummary> =
    transform() { response ->
        response.searches?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListIngressPointsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListIngressPointsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListIngressPointsResponse]
 */
public fun MailManagerClient.listIngressPointsPaginated(initialRequest: ListIngressPointsRequest = ListIngressPointsRequest { }): Flow<ListIngressPointsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listIngressPointsPaginated.listIngressPoints(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListIngressPointsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListIngressPointsResponse]
 */
public fun MailManagerClient.listIngressPointsPaginated(block: ListIngressPointsRequest.Builder.() -> Unit): Flow<ListIngressPointsResponse> =
    listIngressPointsPaginated(ListIngressPointsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listIngressPointsPaginated]
 * to access the nested member [IngressPoint]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [IngressPoint]
 */
@JvmName("listIngressPointsResponseIngressPoint")
public fun Flow<ListIngressPointsResponse>.ingressPoints(): Flow<IngressPoint> =
    transform() { response ->
        response.ingressPoints?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListMembersOfAddressListResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListMembersOfAddressListRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMembersOfAddressListResponse]
 */
public fun MailManagerClient.listMembersOfAddressListPaginated(initialRequest: ListMembersOfAddressListRequest): Flow<ListMembersOfAddressListResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listMembersOfAddressListPaginated.listMembersOfAddressList(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListMembersOfAddressListResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMembersOfAddressListResponse]
 */
public fun MailManagerClient.listMembersOfAddressListPaginated(block: ListMembersOfAddressListRequest.Builder.() -> Unit): Flow<ListMembersOfAddressListResponse> =
    listMembersOfAddressListPaginated(ListMembersOfAddressListRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listMembersOfAddressListPaginated]
 * to access the nested member [SavedAddress]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SavedAddress]
 */
@JvmName("listMembersOfAddressListResponseSavedAddress")
public fun Flow<ListMembersOfAddressListResponse>.addresses(): Flow<SavedAddress> =
    transform() { response ->
        response.addresses?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListRelaysResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListRelaysRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRelaysResponse]
 */
public fun MailManagerClient.listRelaysPaginated(initialRequest: ListRelaysRequest = ListRelaysRequest { }): Flow<ListRelaysResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listRelaysPaginated.listRelays(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListRelaysResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRelaysResponse]
 */
public fun MailManagerClient.listRelaysPaginated(block: ListRelaysRequest.Builder.() -> Unit): Flow<ListRelaysResponse> =
    listRelaysPaginated(ListRelaysRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listRelaysPaginated]
 * to access the nested member [Relay]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Relay]
 */
@JvmName("listRelaysResponseRelay")
public fun Flow<ListRelaysResponse>.relays(): Flow<Relay> =
    transform() { response ->
        response.relays?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListRuleSetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListRuleSetsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRuleSetsResponse]
 */
public fun MailManagerClient.listRuleSetsPaginated(initialRequest: ListRuleSetsRequest = ListRuleSetsRequest { }): Flow<ListRuleSetsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listRuleSetsPaginated.listRuleSets(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListRuleSetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRuleSetsResponse]
 */
public fun MailManagerClient.listRuleSetsPaginated(block: ListRuleSetsRequest.Builder.() -> Unit): Flow<ListRuleSetsResponse> =
    listRuleSetsPaginated(ListRuleSetsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listRuleSetsPaginated]
 * to access the nested member [RuleSet]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [RuleSet]
 */
@JvmName("listRuleSetsResponseRuleSet")
public fun Flow<ListRuleSetsResponse>.ruleSets(): Flow<RuleSet> =
    transform() { response ->
        response.ruleSets?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListTrafficPoliciesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTrafficPoliciesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTrafficPoliciesResponse]
 */
public fun MailManagerClient.listTrafficPoliciesPaginated(initialRequest: ListTrafficPoliciesRequest = ListTrafficPoliciesRequest { }): Flow<ListTrafficPoliciesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTrafficPoliciesPaginated.listTrafficPolicies(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListTrafficPoliciesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTrafficPoliciesResponse]
 */
public fun MailManagerClient.listTrafficPoliciesPaginated(block: ListTrafficPoliciesRequest.Builder.() -> Unit): Flow<ListTrafficPoliciesResponse> =
    listTrafficPoliciesPaginated(ListTrafficPoliciesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listTrafficPoliciesPaginated]
 * to access the nested member [TrafficPolicy]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [TrafficPolicy]
 */
@JvmName("listTrafficPoliciesResponseTrafficPolicy")
public fun Flow<ListTrafficPoliciesResponse>.trafficPolicies(): Flow<TrafficPolicy> =
    transform() { response ->
        response.trafficPolicies?.forEach {
            emit(it)
        }
    }
